/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.commands.cluster.ClusterConfigException;
import com.ibm.ws.management.commands.cluster.ClusterConfigHelper;
import com.ibm.ws.management.commands.nodegroup.NodeGroupHelper;
import com.ibm.ws.management.configservice.ConfigObjectDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.RootObjectDelegator;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.management.util.ConfigHelperFactory;
import com.ibm.ws.sm.workspace.ContextResourceSet;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.template.TemplateManager;
import com.ibm.ws.sm.workspace.template.TemplateManagerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

public class ServerClusterDelegator
extends RootObjectDelegator {
    private static TraceComponent tc = Tr.register(ServerClusterDelegator.class, "management", "com.ibm.ws.management.resources.configservice");

    public ServerClusterDelegator(ConfigServiceImpl configServiceImpl) {
        super(configServiceImpl, RepositoryMetaDataFactory.getRepositoryMetaData().getContextType("clusters"));
    }

    public ObjectName createConfigObject(Session session, ObjectName objectName, ConfigObjectDelegator.ChildTypeInfo childTypeInfo, AttributeList attributeList) throws ConfigServiceException {
        ObjectName objectName2 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigObject", new Object[]{session, objectName, childTypeInfo, attributeList});
        }
        try {
            Object object;
            try {
                object = ConfigServiceHelper.getAttributeValue(attributeList, "adjustPort");
                ConfigServiceHelper.removeAttribute(attributeList, "adjustPort");
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                // empty catch block
            }
            objectName2 = super.createConfigObject(session, objectName, childTypeInfo, attributeList);
            object = (String)ConfigServiceHelper.getAttributeValue(attributeList, "name");
            ClusterConfigHelper.addDefaultResources(this.baseConfigService, session, (String)object);
            ObjectName objectName3 = ConfigServiceHelper.createObjectName(null, "VariableMap");
            ObjectName[] objectNameArray = this.baseConfigService.queryConfigObjects(session, objectName2, objectName3, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Var maps = ", objectNameArray);
            }
            if (objectNameArray == null || objectNameArray.length == 0) {
                ObjectName objectName4 = this.baseConfigService.createConfigDataByTemplate(session, objectName2, "VariableMap", new AttributeList(), null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new varMap = ", objectName4);
                }
            }
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createConfigObject", new Object[]{exception});
            }
            throw new ConfigServiceException(exception);
        }
        catch (Throwable throwable) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createConfigObject", new Object[]{throwable});
            }
            throw new ConfigServiceException(throwable);
        }
        return objectName2;
    }

    public ObjectName createConfigData(Session session, ObjectName objectName, String string, AttributeList attributeList) throws ConfigServiceException {
        String string2 = null;
        try {
            string2 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "nodeName");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ObjectName objectName2 = super.createConfigData(session, objectName, string, attributeList);
        if (string.equals("members")) {
            this.clusterMemberCreated(session, objectName, -1);
        }
        return objectName2;
    }

    public void setAttributes(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException {
        try {
            ConfigServiceHelper.getAttributeValue(attributeList, "members");
            throw new UnsupportedOperationException("can not reset cluster member");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            super.setAttributes(session, objectName, attributeList);
            return;
        }
    }

    public void resetAttributes(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException {
        try {
            ConfigServiceHelper.getAttributeValue(attributeList, "members");
            throw new UnsupportedOperationException("can not reset cluster member");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            super.setAttributes(session, objectName, attributeList);
            return;
        }
    }

    public void addElement(Session session, ObjectName objectName, String string, Object object, int n) throws ConfigServiceException {
        super.addElement(session, objectName, string, object, n);
        this.clusterMemberCreated(session, objectName, n);
    }

    public void deleteConfigData(Session session, ObjectName objectName) throws ConfigServiceException {
        Object object;
        Object object2;
        Object object3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteConfigData", new Object[]{session, objectName});
        }
        String string = null;
        try {
            object3 = this.baseConfigService.getAppManagement();
            object2 = new ObjectName("WebSphere", ConfigServiceHelper.getObjectLocation(objectName));
            object = ConfigServiceHelper.getObjectLocation(objectName);
            string = ((Properties)object).getProperty("cluster");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cluster = " + object2 + " and clusterName = " + string);
            }
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            Object object4 = this.baseConfigService.getSessionProperty(session, "LOCALE");
            if (object4 != null) {
                hashtable.put("app.client.locale", object4);
            }
            object3.removeAllAppsFromCluster((ObjectName)object2, hashtable, session.toString());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.configservice.ServerClusterDelegator", "48", this);
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0011E", new Object[]{exception}, null));
        }
        object3 = this.baseConfigService.getAttributes(session, objectName, new String[]{"members"}, false);
        object2 = (List)((Attribute)((ArrayList)object3).get(0)).getValue();
        object = object2.iterator();
        while (object.hasNext()) {
            this.baseConfigService.deleteConfigData(session, (ObjectName)object.next());
        }
        super.deleteConfigData(session, objectName);
        try {
            object = ServerClusterDelegator.getClusterTemplateContext(string, session);
            if (object != null) {
                object.delete(true);
            }
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteConfigData", "Cannot get cluster template context");
            }
            throw new ConfigServiceException(exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteConfigData");
        }
    }

    protected static RepositoryContext findContext(RepositoryContext repositoryContext, String string, String string2) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findContext", new Object[]{repositoryContext, string, string2});
        }
        RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
        RepositoryContextType repositoryContextType = repositoryMetaData.getContextType(string);
        RepositoryContext repositoryContext2 = repositoryContext.getChild(repositoryContextType, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findContext", repositoryContext2);
        }
        return repositoryContext2;
    }

    protected static RepositoryContext getClusterTemplateContext(String string, Session session) throws ClusterConfigException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClusterContext", string);
        }
        WorkSpace workSpace = null;
        try {
            workSpace = WorkspaceHelper.getWorkspace(session);
        }
        catch (ConfigServiceException configServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusterTemplateContext", "Cannot get workspace");
            }
            throw new ClusterConfigException(configServiceException, configServiceException.getMessage());
        }
        TemplateManager templateManager = TemplateManagerFactory.getManager(workSpace);
        RepositoryContext repositoryContext = null;
        try {
            repositoryContext = templateManager.getRootTemplateContext();
        }
        catch (WorkSpaceException workSpaceException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusterTemplateContext", "Cannot find template context");
            }
            throw new ClusterConfigException(workSpaceException, workSpaceException.getMessage());
        }
        if (repositoryContext == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusterTemplateContext", "template context is null");
            }
            throw new ClusterConfigException("template context is null");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Found template context ", repositoryContext);
        }
        RepositoryContext repositoryContext2 = null;
        try {
            repositoryContext2 = ServerClusterDelegator.findContext(repositoryContext, "clusters", string);
        }
        catch (Throwable throwable) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getClusterTemplateContext", "Cannot find cluster template context");
            }
            throw new ClusterConfigException(throwable, throwable.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClusterContext", string);
        }
        return repositoryContext2;
    }

    private void clusterMemberCreated(Session session, ObjectName objectName, int n) throws ConfigServiceException {
        String string;
        ServerCluster serverCluster;
        Object object;
        List list = (List)this.baseConfigService.getAttribute(session, objectName, "members");
        int n2 = list.size();
        if (n == -1) {
            n = n2 - 1;
        }
        AttributeList attributeList = (AttributeList)list.get(n);
        ObjectName objectName2 = ConfigServiceHelper.createObjectName(attributeList);
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        try {
            string2 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "nodeName");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        if (string2 != null) {
            stringBuffer.append("Node=").append(string2).append(":");
        }
        String string3 = null;
        try {
            string3 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "memberName");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        if (string3 != null) {
            stringBuffer.append("Server=").append(string3);
        }
        ObjectName objectName3 = this.baseConfigService.resolve(session, stringBuffer.toString())[0];
        Server server2 = (Server)MOFUtil.convertToEObject(session, objectName3);
        RepositoryContext repositoryContext = null;
        RepositoryContext repositoryContext2 = ((ContextResourceSet)server2.eResource().getResourceSet()).getContext();
        repositoryContext = repositoryContext2.getParent();
        ObjectName objectName4 = this.baseConfigService.resolve(session, "Node=" + repositoryContext.getName())[0];
        Node node = (Node)MOFUtil.convertToEObject(session, objectName4);
        if (n2 == 1) {
            try {
                object = (String)this.baseConfigService.getAttribute(session, objectName, "nodeGroupName");
                if (object == null || ((String)object).length() <= 0) {
                    serverCluster = NodeGroupHelper.listNodeGroups(session, this.baseConfigService, string2);
                    if (serverCluster != null && ((String[])serverCluster).length > 0) {
                        string = serverCluster[0];
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "nodeGroup", string);
                        }
                        if (string != null && string.length() > 0) {
                            AttributeList attributeList2 = new AttributeList();
                            ConfigServiceHelper.setAttributeValue(attributeList2, "nodeGroupName", string);
                            this.baseConfigService.setAttributes(session, objectName, attributeList2);
                        }
                    } else {
                        string = ClusterConfigHelper.getMemberNodeVersion(this.baseConfigService, session, string2);
                        if (!string.equals("5")) {
                            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0447E", new Object[]{string2}, null));
                        }
                    }
                }
            }
            catch (Exception exception) {
                throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0011E", new Object[]{exception}, null));
            }
            object = ConfigHelperFactory.getPlatformClusterConfigHelper(node);
            serverCluster = (ServerCluster)MOFUtil.convertToEObject(session, objectName);
            object.configureServerClusterFromServer(serverCluster, server2);
        }
        object = ConfigHelperFactory.getPlatformClusterMemberConfigHelper(node);
        serverCluster = (ServerCluster)MOFUtil.convertToEObject(session, objectName2);
        object.configureClusterMember((ClusterMember)serverCluster, server2);
        if (repositoryContext != null) {
            string = (String)this.baseConfigService.getAttribute(session, objectName, "name");
            this.saveClusterConfig(repositoryContext.getParent(), string);
        }
    }

    private void saveClusterConfig(RepositoryContext repositoryContext, String string) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveClusterConfig", new Object[]{repositoryContext, string});
        }
        try {
            Collection collection = repositoryContext.findContext("clusters", string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "clusterCollection", new Object[]{collection});
            }
            RepositoryContext repositoryContext2 = (RepositoryContext)collection.iterator().next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "clusterCtx", new Object[]{repositoryContext2});
            }
            URI uRI = URI.createURI((String)"cluster.xml");
            Resource resource = repositoryContext2.getResourceSet().getResource(uRI, true);
            resource.save(new HashMap());
        }
        catch (Exception exception) {
            Tr.error(tc, "Error occured during save");
            throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0004E", new Object[]{exception}, null));
        }
    }
}

