/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.InvalidAttributeNameException;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.BaseServerDelegator;
import com.ibm.ws.management.configservice.ConfigObjectDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.EndpointConfigHelper;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.management.util.ConfigHelperFactory;
import com.ibm.ws.sm.workspace.RepositoryContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.ObjectName;

public class ServerDelegator
extends BaseServerDelegator {
    private static TraceComponent tc = Tr.register(ServerDelegator.class, "management", "com.ibm.ws.management.resources.configservice");

    public ServerDelegator(ConfigServiceImpl configServiceImpl) {
        super(configServiceImpl);
    }

    public AttributeList getAttributesMetaInfo(String string) throws InvalidConfigDataTypeException {
        AttributeList attributeList = super.getAttributesMetaInfo(string);
        AttributeList attributeList2 = new AttributeList();
        attributeList2.add(new Attribute("_Attribute_MetaInfo_Name", "adjustPort"));
        attributeList2.add(new Attribute("_Attribute_MetaInfo_Is_Collection", Boolean.FALSE));
        attributeList2.add(new Attribute("_Attribute_MetaInfo_Type", "Boolean"));
        attributeList2.add(new Attribute("_Attribute_MetaInfo_Is_Object", Boolean.TRUE));
        attributeList2.add(new Attribute("_Attribute_MetaInfo_Is_Reference", Boolean.FALSE));
        attributeList.add(new Attribute("adjustPort", attributeList2));
        return attributeList;
    }

    public ObjectName createConfigObject(Session session, ObjectName objectName, ConfigObjectDelegator.ChildTypeInfo childTypeInfo, AttributeList attributeList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigObject", new Object[]{session, objectName, childTypeInfo, attributeList});
        }
        try {
            Object object;
            Serializable serializable;
            ObjectName objectName2;
            AdminCommand adminCommand;
            ObjectName objectName3;
            boolean bl;
            block21: {
                boolean bl2 = true;
                try {
                    Object object2 = ConfigServiceHelper.getAttributeValue(attributeList, "adjustPort");
                    if (object2 instanceof Boolean && !((Boolean)object2).booleanValue()) {
                        bl2 = false;
                        EndpointConfigHelper.setAdjustFlag(new Boolean(false));
                    }
                    ConfigServiceHelper.removeAttribute(attributeList, "adjustPort");
                }
                catch (AttributeNotFoundException attributeNotFoundException) {
                    // empty catch block
                }
                bl = false;
                objectName3 = null;
                Node node = (Node)MOFUtil.convertToEObject(session, objectName);
                String string = node.getName();
                CommandMgr commandMgr = CommandMgr.getCommandMgr();
                adminCommand = commandMgr.createCommand("createApplicationServer");
                adminCommand.setConfigSession(session);
                adminCommand.setTargetObject(string);
                String string2 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "name");
                adminCommand.setParameter("name", string2);
                adminCommand.setParameter("genUniquePorts", new Boolean(bl2));
                String string3 = "APPLICATION_SERVER";
                objectName2 = null;
                try {
                    objectName2 = (ObjectName)ConfigServiceHelper.getAttributeValue(attributeList, "_Websphere_Config_Data_Template");
                }
                catch (AttributeNotFoundException attributeNotFoundException) {
                    if (!tc.isDebugEnabled()) break block21;
                    Tr.debug(tc, "No Template found");
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Template: " + objectName2);
            }
            if (objectName2 != null) {
                serializable = ConfigServiceHelper.getObjectLocation(objectName2);
                object = ((Properties)serializable).getProperty("servertype");
                String string = ((Properties)serializable).getProperty("server");
                String string4 = ((Properties)serializable).getProperty("node");
                Tr.debug(tc, "Location: ", new Object[]{object, string, string4});
                if (object == null || ((String)object).trim().equals("")) {
                    objectName3 = this.createServerTemplate(session, string4, string);
                    bl = true;
                    serializable = ConfigServiceHelper.getObjectLocation(objectName3);
                    string = ((Properties)serializable).getProperty("server");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Template: " + string);
                }
                if (string != null) {
                    if (string.endsWith("|server.xml")) {
                        string = string.substring(0, string.indexOf("|server.xml"));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Template: " + string);
                        }
                    }
                    adminCommand.setParameter("templateName", string);
                }
            }
            adminCommand.execute();
            serializable = adminCommand.getCommandResult();
            if (!serializable.isSuccessful()) {
                object = serializable.getException();
                throw object;
            }
            object = (ObjectName)serializable.getResult();
            this.baseConfigService.setAttributes(session, (ObjectName)object, attributeList);
            if (bl) {
                this.deleteServerTemplate(session, objectName3);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createConfigObject", new Object[]{object});
            }
            return object;
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createConfigObject", new Object[]{exception});
            }
            throw new ConfigServiceException(exception);
        }
        catch (Throwable throwable) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createConfigObject", new Object[]{throwable});
            }
            throw new ConfigServiceException(throwable);
        }
    }

    private void deleteServerTemplate(Session session, ObjectName objectName) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteServerTemplate", new Object[]{session, objectName});
        }
        if (objectName == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteServerTemplate", new Object[]{null});
            }
            return;
        }
        try {
            CommandMgr commandMgr = CommandMgr.getCommandMgr();
            AdminCommand adminCommand = commandMgr.createCommand("deleteServerTemplate");
            adminCommand.setConfigSession(session);
            adminCommand.setTargetObject(objectName);
            adminCommand.execute();
            CommandResult commandResult = adminCommand.getCommandResult();
            if (!commandResult.isSuccessful()) {
                Throwable throwable = commandResult.getException();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "deleteServerTemplate", new Object[]{throwable});
                }
                throw new ConfigServiceException(throwable);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteServerTemplate");
            }
            return;
        }
        catch (Exception exception) {
            throw new ConfigServiceException(exception);
        }
    }

    private ObjectName createServerTemplate(Session session, String string, String string2) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerTemplate", new Object[]{session, string, string2});
        }
        try {
            CommandMgr commandMgr = CommandMgr.getCommandMgr();
            AdminCommand adminCommand = commandMgr.createCommand("createApplicationServerTemplate");
            adminCommand.setConfigSession(session);
            adminCommand.setParameter("nodeName", string);
            adminCommand.setParameter("serverName", string2);
            String string3 = string2 + session + System.currentTimeMillis();
            adminCommand.setParameter("templateName", string3);
            adminCommand.execute();
            CommandResult commandResult = adminCommand.getCommandResult();
            if (!commandResult.isSuccessful()) {
                Throwable throwable = commandResult.getException();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createServerTemplate", new Object[]{throwable});
                }
                throw new ConfigServiceException(throwable);
            }
            ObjectName objectName = (ObjectName)commandResult.getResult();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createServerTemplate", new Object[]{objectName});
            }
            return objectName;
        }
        catch (Exception exception) {
            throw new ConfigServiceException(exception);
        }
    }

    public ObjectName createBasicConfigObject(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException {
        String string;
        AttributeList attributeList2;
        Object object;
        List list;
        boolean bl;
        ObjectName objectName2;
        ObjectName[] objectNameArray;
        Serializable serializable;
        Object object2;
        ObjectName[] objectNameArray2;
        String string2 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createBasicConfigObject", new Object[]{session, objectName, attributeList});
        }
        ConfigObjectDelegator.ChildTypeInfo childTypeInfo = null;
        try {
            childTypeInfo = this.getChildInfo("Server");
        }
        catch (InvalidAttributeNameException invalidAttributeNameException) {
            // empty catch block
        }
        ObjectName objectName3 = super.createConfigObject(session, objectName, childTypeInfo, attributeList);
        try {
            objectNameArray2 = ConfigServiceFactory.getConfigService();
            string2 = (String)objectNameArray2.getAttribute(session, objectName3, "serverType");
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.configservice.ServerDelegator", "999");
        }
        if (!string2.equals("WEB_SERVER")) {
            objectNameArray2 = ConfigHelperFactory.getPlatformServerConfigHelper((Node)MOFUtil.convertToEObject(session, objectName));
            objectNameArray2.configureServer((Server)MOFUtil.convertToEObject(session, objectName3));
        }
        if ((objectNameArray2 = this.baseConfigService.queryConfigObjects(session, objectName3, ConfigServiceHelper.createObjectName(null, "AdminService"), null)).length > 0) {
            object2 = objectNameArray2[0];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "adminService", object2);
            }
            serializable = ConfigServiceHelper.getObjectLocation(objectName);
            objectNameArray = ((Properties)serializable).getProperty("cell");
            objectName2 = this.baseConfigService.resolve(session, "Cell=" + (String)objectNameArray)[0];
            bl = "STANDALONE".equals(this.baseConfigService.getAttribute(session, objectName2, "cellType"));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "standAlone," + bl);
            }
            list = new AttributeList();
            ((AttributeList)list).add(new Attribute("standalone", new Boolean(bl)));
            this.baseConfigService.setAttributes(session, (ObjectName)object2, (AttributeList)list);
        }
        object2 = ConfigServiceHelper.getDisplayName(objectName3);
        try {
            serializable = ConfigServiceHelper.createObjectName(null, "VariableMap");
            objectNameArray = this.baseConfigService.queryConfigObjects(session, objectName3, (ObjectName)serializable, null);
            if (objectNameArray.length == 0) {
                objectName2 = this.baseConfigService.createConfigData(session, objectName3, "VariableMap", "VariableMap", new AttributeList());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new varMap = ", objectName2);
                }
            } else {
                objectName2 = objectNameArray[0];
            }
            bl = true;
            list = (List)this.baseConfigService.getAttribute(session, objectName2, "entries");
            object = list.iterator();
            while (object.hasNext()) {
                attributeList2 = (AttributeList)object.next();
                try {
                    string = (String)ConfigServiceHelper.getAttributeValue(attributeList2, "symbolicName");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "symbolicName = ", string);
                    }
                    if (!string.equals("SERVER_LOG_ROOT")) continue;
                    ConfigServiceHelper.setAttributeValue(attributeList2, "value", "${LOG_ROOT}/" + (String)object2);
                    this.baseConfigService.setAttributes(session, ConfigServiceHelper.createObjectName(attributeList2), attributeList2);
                    bl = false;
                    break;
                }
                catch (AttributeNotFoundException attributeNotFoundException) {
                }
            }
            if (bl) {
                object = new AttributeList();
                ((AttributeList)object).add(new Attribute("symbolicName", "SERVER_LOG_ROOT"));
                ((AttributeList)object).add(new Attribute("value", "${LOG_ROOT}/" + (String)object2));
                ((AttributeList)object).add(new Attribute("description", "The log root directory for server " + (String)object2 + "."));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "varAttrList = ", object);
                }
                this.baseConfigService.createConfigData(session, objectName2, "entries", "VariableSubstitutionEntry", (AttributeList)object);
            }
        }
        catch (ConfigServiceException configServiceException) {
            Tr.warning(tc, "ADMG0025W", new Object[]{object2, configServiceException});
        }
        try {
            serializable = ConfigServiceHelper.createObjectName(null, "VariableMap");
            objectNameArray = this.baseConfigService.queryConfigObjects(session, objectName3, (ObjectName)serializable, null);
            if (objectNameArray.length == 0) {
                objectName2 = this.baseConfigService.createConfigData(session, objectName3, "VariableMap", "VariableMap", new AttributeList());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new varMap = ", objectName2);
                }
            } else {
                objectName2 = objectNameArray[0];
            }
            bl = true;
            list = (List)this.baseConfigService.getAttribute(session, objectName2, "entries");
            object = list.iterator();
            while (object.hasNext()) {
                attributeList2 = (AttributeList)object.next();
                try {
                    string = (String)ConfigServiceHelper.getAttributeValue(attributeList2, "symbolicName");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "symbolicName = ", string);
                    }
                    if (!string.equals("WAS_SERVER_NAME")) continue;
                    ConfigServiceHelper.setAttributeValue(attributeList2, "value", object2);
                    this.baseConfigService.setAttributes(session, ConfigServiceHelper.createObjectName(attributeList2), attributeList2);
                    bl = false;
                    break;
                }
                catch (AttributeNotFoundException attributeNotFoundException) {
                }
            }
            if (bl) {
                object = new AttributeList();
                ((AttributeList)object).add(new Attribute("symbolicName", "WAS_SERVER_NAME"));
                ((AttributeList)object).add(new Attribute("value", object2));
                ((AttributeList)object).add(new Attribute("description", "Name of the application server."));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "varAttrList = ", object);
                }
                this.baseConfigService.createConfigData(session, objectName2, "entries", "VariableSubstitutionEntry", (AttributeList)object);
            }
        }
        catch (ConfigServiceException configServiceException) {
            Tr.warning(tc, "ADMG0025W", new Object[]{object2, configServiceException});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createBasicConfigObject", objectName3);
        }
        return objectName3;
    }

    public void deleteConfigData(Session session, ObjectName objectName) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteConfigData", new Object[]{session, objectName});
        }
        try {
            Properties properties = ConfigServiceHelper.getObjectLocation(objectName);
            String string = properties.getProperty("node");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Node Name: " + string);
            }
            String string2 = properties.getProperty("server");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server Name: " + string2);
            }
            CommandMgr commandMgr = CommandMgr.getCommandMgr();
            AdminCommand adminCommand = commandMgr.createCommand("deleteServer");
            adminCommand.setConfigSession(session);
            adminCommand.setParameter("nodeName", string);
            adminCommand.setParameter("serverName", string2);
            adminCommand.execute();
            CommandResult commandResult = adminCommand.getCommandResult();
            if (!commandResult.isSuccessful()) {
                Throwable throwable = commandResult.getException();
                throw throwable;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteConfigData", new Object[0]);
            }
            return;
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteConfigData", new Object[]{exception});
            }
            throw new ConfigServiceException(exception);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "deleteConfigData", new Object[]{throwable});
            }
            throw new ConfigServiceException(throwable);
        }
    }

    public void deleteBasicConfigData(Session session, ObjectName objectName) throws ConfigServiceException {
        Object object;
        Cloneable cloneable;
        ObjectName objectName2;
        ObjectName[] objectNameArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteBasicConfigData", new Object[]{session, objectName});
        }
        ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
        RepositoryContext repositoryContext = WorkspaceHelper.getContext(session, configDataId);
        String string = ConfigServiceHelper.getDisplayName(objectName);
        String string2 = ConfigServiceHelper.getObjectLocation(objectName).getProperty("node");
        String string3 = (String)this.baseConfigService.getAttribute(session, objectName, "clusterName");
        try {
            objectNameArray = this.baseConfigService.getAppManagement();
            objectName2 = new ObjectName("WebSphere", ConfigServiceHelper.getObjectLocation(objectName));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "server", objectName2);
            }
            cloneable = new Hashtable<String, Object>();
            object = this.baseConfigService.getSessionProperty(session, "LOCALE");
            if (object != null) {
                ((Hashtable)cloneable).put("app.client.locale", object);
            }
            objectNameArray.removeAllAppsFromServer(objectName2, (Hashtable)cloneable, session.toString());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.configservice.ServerDelegator", "78", this);
            throw new ConfigServiceException(exception, TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0011E", new Object[]{exception}, null));
        }
        if (string3 != null && string3.length() >= 0 && (objectNameArray = this.baseConfigService.resolve(session, "ServerCluster=" + string3)).length > 0) {
            objectName2 = objectNameArray[0];
            cloneable = this.baseConfigService.getAttributes(session, objectName2, new String[]{"members"}, false);
            object = (List)((Attribute)((ArrayList)cloneable).get(0)).getValue();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ObjectName objectName3 = (ObjectName)iterator.next();
                if (!this.baseConfigService.getAttribute(session, objectName3, "memberName").equals(string) || !this.baseConfigService.getAttribute(session, objectName3, "nodeName").equals(string2)) continue;
                this.baseConfigService.deleteConfigDataBasic(session, objectName3);
            }
        }
        super.deleteConfigData(session, objectName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteBasicConfigData");
        }
    }
}

