/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.management.configservice.CSMetadataMgr;
import com.ibm.ws.management.configservice.TypeRegistry;
import com.ibm.ws.management.configservice.csmetadata.EMFAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SpecialAttributeRegistry {
    private static TraceComponent tc;
    private static final HashSet readOnlyAttrs;
    private static final HashMap uniqueAttrs;

    public static boolean isReadOnlyAttribute(EStructuralFeature eStructuralFeature) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isReadOnlyAttribute", eStructuralFeature);
        }
        String string = ((EClass)eStructuralFeature.eContainer()).getInstanceClassName() + '.' + eStructuralFeature.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "attrId", string);
        }
        boolean bl = readOnlyAttrs.contains(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isReadOnlyAttribute," + bl);
        }
        return bl;
    }

    static void checkUnique(EClass eClass, List list, EObject eObject) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkUnique", new Object[]{eClass, list, eObject});
        }
        ArrayList arrayList = new ArrayList(list);
        String string = TypeRegistry.getTypeShortName((EClassifier)eClass);
        String string2 = (String)uniqueAttrs.get(string);
        if (string2 != null) {
            EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(string2);
            Object object = eObject.eGet(eStructuralFeature);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                EObject eObject2 = (EObject)iterator.next();
                String string3 = TypeRegistry.getTypeShortName((EClassifier)eObject2.eClass());
                if (!string3.equals(string) && !TypeRegistry.isSubType(string, string3) || !object.equals(eObject2.eGet(eStructuralFeature))) continue;
                throw new ConfigServiceException(TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0037E", new Object[]{string, string2, object}, null));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkUnique");
        }
    }

    static {
        EMFAttribute eMFAttribute;
        int n;
        tc = Tr.register(SpecialAttributeRegistry.class, "management", "com.ibm.ws.management.resources.configservice");
        readOnlyAttrs = new HashSet();
        EList eList = CSMetadataMgr.getConfigServiceMetadata().getReadOnlyAttributes();
        for (n = 0; n < eList.size(); ++n) {
            eMFAttribute = (EMFAttribute)eList.get(n);
            readOnlyAttrs.add(eMFAttribute.getTypeName() + '.' + eMFAttribute.getAttrName());
        }
        uniqueAttrs = new HashMap();
        eList = CSMetadataMgr.getConfigServiceMetadata().getUniqueAttributes();
        for (n = 0; n < eList.size(); ++n) {
            eMFAttribute = (EMFAttribute)eList.get(n);
            uniqueAttrs.put(TypeRegistry.getShortType(eMFAttribute.getTypeName()), eMFAttribute.getAttrName());
        }
    }
}

