/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.models.base.resources.init.ResourcesInit;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.InvalidConfigDataTypeException;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.websphere.models.config.util.WCCM;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.management.configservice.MetadataFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;

public class TypeRegistry {
    private static TraceComponent tc = Tr.register(TypeRegistry.class, "management", "com.ibm.ws.management.resources.configservice");
    private HashMap typeTable = new HashMap();
    private static final String[] validPackagePrefix = new String[]{"com.ibm.ejs.models.base.resources", "com.ibm.websphere.models.config", "com.ibm.etools.jca", "org.eclipse.jst.j2ee.jca", "org.eclipse.jst.j2ee.common", "com.ibm.etools.j2ee.common"};
    private static final String[] emptyStringArray = new String[0];
    private static final TypeRegistry instance = new TypeRegistry();

    public static String getFullyQualifiedType(String string) throws InvalidConfigDataTypeException {
        TypeInfo typeInfo = (TypeInfo)TypeRegistry.instance.typeTable.get(string);
        if (typeInfo == null) {
            throw new InvalidConfigDataTypeException(string);
        }
        return typeInfo.getFullyQualifiedType();
    }

    public static Set getAllTypes(Properties properties) {
        HashSet hashSet = new HashSet(TypeRegistry.getAllTypes());
        MetadataFilter.filterAllTypes(hashSet, properties);
        return hashSet;
    }

    public static Set getAllTypes() {
        return TypeRegistry.instance.typeTable.keySet();
    }

    public static String[] getSubTypes(String string, Properties properties) throws InvalidConfigDataTypeException {
        String[] stringArray = TypeRegistry.getSubTypes(string);
        EClass eClass = TypeRegistry.getMetaObject(string);
        LinkedList<String> linkedList = new LinkedList<String>(Arrays.asList(stringArray));
        MetadataFilter.filterSubTypes(eClass, linkedList, properties);
        return linkedList.toArray(new String[0]);
    }

    public static String[] getSubTypes(String string) throws InvalidConfigDataTypeException {
        TypeInfo typeInfo = (TypeInfo)TypeRegistry.instance.typeTable.get(string);
        if (typeInfo == null) {
            throw new InvalidConfigDataTypeException(string);
        }
        return typeInfo.getSubTypes();
    }

    public static boolean isSubType(String string, String string2, Properties properties) throws InvalidConfigDataTypeException {
        EClass eClass = TypeRegistry.getMetaObject(string);
        EClass eClass2 = TypeRegistry.getMetaObject(string2);
        return MetadataFilter.isSubType(eClass, eClass2, properties);
    }

    public static boolean isSubType(String string, String string2) throws InvalidConfigDataTypeException {
        String[] stringArray = TypeRegistry.getSubTypes(string);
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static String getShortType(String string) {
        return string.substring(string.lastIndexOf(46) + 1, string.length());
    }

    public static EClass getMetaObject(String string, Properties properties) throws InvalidConfigDataTypeException {
        EClass eClass = TypeRegistry.getMetaObject(string);
        boolean bl = MetadataFilter.isValidType(eClass, properties);
        if (!bl) {
            throw new InvalidConfigDataTypeException("Config Type: " + string + "is not valid in version: " + properties);
        }
        return eClass;
    }

    public static EClass getMetaObject(String string) throws InvalidConfigDataTypeException {
        TypeInfo typeInfo = (TypeInfo)TypeRegistry.instance.typeTable.get(string);
        if (typeInfo == null) {
            throw new InvalidConfigDataTypeException(string);
        }
        return typeInfo.getMetaObject();
    }

    public static String getTypeShortName(EClassifier eClassifier) {
        if (TypeRegistry.isEnumType(eClassifier)) {
            return "ENUM";
        }
        String string = eClassifier.getInstanceClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public static void main(String[] stringArray) {
        System.out.println("currentTime:" + new Date(System.currentTimeMillis()).toString());
        ConfigInit.init();
        ResourcesInit.init();
        System.out.println("start generate type registry");
        System.out.println("currentTime:" + new Date(System.currentTimeMillis()).toString());
        TypeRegistry typeRegistry = new TypeRegistry();
        typeRegistry.generate();
        System.out.println("currentTime:" + new Date(System.currentTimeMillis()).toString());
        StringBuffer stringBuffer = new StringBuffer();
        typeRegistry.dumpState(stringBuffer);
        System.out.println(stringBuffer.toString());
    }

    private TypeRegistry() {
    }

    private void generate() {
        EPackage.Registry registry = null;
        ModelMgr.initialize("ws-server");
        registry = EPackage.Registry.INSTANCE;
        if (registry instanceof EPackageRegistryImpl.Delegator) {
            this.generateMultipleClassLoaderTypeRegistry();
        } else if (registry instanceof EPackageRegistryImpl) {
            this.generateSingleClassLoaderTypeRegistry();
        } else {
            System.out.println("Error creating TypeRegistry: Unrecognized EMF Package registry implemnetation found: " + registry);
        }
    }

    private void generateSingleClassLoaderTypeRegistry() {
        EPackage.Registry registry = null;
        registry = WCCM.getPackageRegistry();
        if (registry == null) {
            ConfigInit.init();
            registry = WCCM.getPackageRegistry();
        }
        Set set = registry.keySet();
        Object[] objectArray = set.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            EPackage ePackage;
            Object object = objectArray[i];
            if (object == null || (ePackage = registry.getEPackage(object.toString())) == null || !this.isValidType(ePackage.getClass().getName())) continue;
            EList eList = ePackage.getEClassifiers();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!(e2 instanceof EClass)) continue;
                this.registerType((EClass)e2);
            }
        }
    }

    private void generateMultipleClassLoaderTypeRegistry() {
        EPackage.Registry registry = null;
        for (Object object = ExtClassLoader.getInstance(); object != null; object = object.getParent()) {
            registry = EPackageRegistryImpl.getRegistry((ClassLoader)object);
            Set set = registry.keySet();
            Object[] objectArray = set.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                EPackage ePackage;
                Object object2 = objectArray[i];
                if (object2 == null || (ePackage = registry.getEPackage(object2.toString())) == null || !this.isValidType(ePackage.getClass().getName())) continue;
                EList eList = ePackage.getEClassifiers();
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    if (!(e2 instanceof EClass)) continue;
                    this.registerType((EClass)e2);
                    EClass eClass = (EClass)e2;
                }
            }
        }
    }

    private boolean isValidType(String string, Properties properties) throws InvalidConfigDataTypeException {
        EClass eClass = TypeRegistry.getMetaObject(string);
        return MetadataFilter.isValidType(eClass, properties);
    }

    private boolean isValidType(String string) {
        boolean bl = false;
        for (int i = 0; i < validPackagePrefix.length; ++i) {
            if (!string.startsWith(validPackagePrefix[i])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private TypeInfo basicRegisterType(EClass eClass) {
        String string = TypeRegistry.getTypeShortName((EClassifier)eClass);
        TypeInfo typeInfo = (TypeInfo)this.typeTable.get(string);
        if (typeInfo == null) {
            typeInfo = new TypeInfo(eClass);
            this.typeTable.put(string, typeInfo);
        }
        return typeInfo;
    }

    private void registerType(EClass eClass) {
        if (eClass.getInstanceClass() == null) {
            return;
        }
        String string = eClass.getInstanceClass().getName();
        if (this.isValidType(string)) {
            String string2 = TypeRegistry.getTypeShortName((EClassifier)eClass);
            TypeInfo typeInfo = this.basicRegisterType(eClass);
            if (eClass instanceof EClass) {
                EList eList = eClass.getEAllSuperTypes();
                Iterator iterator = eList.iterator();
                while (iterator.hasNext()) {
                    EClassifier eClassifier = (EClassifier)iterator.next();
                    String string3 = eClassifier.getInstanceClass().getName();
                    if (!this.isValidType(string3)) continue;
                    TypeInfo typeInfo2 = this.basicRegisterType((EClass)eClassifier);
                    typeInfo2.addSubType(string2);
                }
            }
        }
    }

    private void dumpState(StringBuffer stringBuffer) {
        Set set = this.typeTable.entrySet();
        stringBuffer.append("Dump the state of type registry\n");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuffer.append("Short type name:").append(entry.getKey()).append('\n');
            TypeInfo typeInfo = (TypeInfo)entry.getValue();
            stringBuffer.append("FQ type name:").append(typeInfo.getFullyQualifiedType()).append('\n');
            String[] stringArray = typeInfo.getSubTypes();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i == 0) {
                    stringBuffer.append("Subtype names:");
                }
                stringBuffer.append(stringArray[i]);
                if (i < stringArray.length - 1) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append('\n');
            }
            stringBuffer.append('\n');
        }
    }

    static boolean isEnumType(EClassifier eClassifier) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "metaObj", eClassifier);
        }
        return eClassifier instanceof EEnum;
    }

    static {
        instance.generate();
    }

    private class TypeInfo {
        private EClass metaObj;
        private List subTypes = null;

        public TypeInfo(EClass eClass) {
            this.metaObj = eClass;
        }

        public void addSubType(String string) {
            if (this.subTypes == null) {
                this.subTypes = new ArrayList(3);
            }
            this.subTypes.add(string);
        }

        public String[] getSubTypes() {
            String[] stringArray;
            if (this.subTypes == null) {
                stringArray = emptyStringArray;
            } else {
                stringArray = new String[this.subTypes.size()];
                this.subTypes.toArray(stringArray);
            }
            return stringArray;
        }

        public String getFullyQualifiedType() {
            return this.metaObj.getInstanceClass().getName();
        }

        public EClass getMetaObject() {
            return this.metaObj;
        }
    }
}

