/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.management.configservice.ConfigObjectDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.RootObjectDelegator;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class VariableMapDelegator
extends RootObjectDelegator {
    private static TraceComponent tc = Tr.register(VariableMapDelegator.class, "management", "com.ibm.ws.management.resources.configservice");

    public VariableMapDelegator(ConfigServiceImpl configServiceImpl) {
        super(configServiceImpl, "VariableMap", RepositoryMetaDataFactory.getRepositoryMetaData().getDocumentType("Variables"));
    }

    protected ObjectName createConfigObject(Session session, ObjectName objectName, ConfigObjectDelegator.ChildTypeInfo childTypeInfo, AttributeList attributeList) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigData", new Object[]{session, objectName, childTypeInfo, attributeList});
        }
        String string = WorkspaceHelper.getType(session, objectName);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "type", string);
        }
        if (string.equals("ServerCluster") && WorkspaceHelper.containVersion5Memeber(session, objectName)) {
            String string2 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0500E", new Object[]{objectName}, null);
            throw new ConfigServiceException(string2);
        }
        if (string.equals("Deployment") && WorkspaceHelper.containVersion5DeploymentTarget(session, objectName)) {
            String string3 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0501E", new Object[]{objectName}, null);
            throw new ConfigServiceException(string3);
        }
        ObjectName[] objectNameArray = this.baseConfigService.getRelationship(session, objectName, "VariableMap");
        if (objectNameArray.length > 0) {
            String string4 = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0502E", new Object[]{objectName, objectNameArray[0]}, null);
            throw new ConfigServiceException(string4);
        }
        ObjectName objectName2 = super.createConfigObject(session, objectName, childTypeInfo, attributeList);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigObject", objectName2);
        }
        return objectName2;
    }
}

