/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigDataId;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigDataNotFoundException;
import com.ibm.websphere.management.exception.ConfigDocumentLoadException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.InvalidAttributeNameException;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.ConfigServiceDelegator;
import com.ibm.ws.management.configservice.ConfigServiceImpl;
import com.ibm.ws.management.configservice.DocAccessor;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.RootObjectDelegator;
import com.ibm.ws.management.configservice.TypeRegistry;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.RestrictedAccess;
import com.ibm.ws.sm.validation.ValidationHelper;
import com.ibm.ws.sm.validation.ValidationManager;
import com.ibm.ws.sm.validation.ValidationManagerException;
import com.ibm.ws.sm.validation.ValidationManagerRegistry;
import com.ibm.ws.sm.validation.ValidationPolicy;
import com.ibm.ws.sm.workspace.ContextResourceSet;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.WorkSpaceManager;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.ws.sm.workspace.template.TemplateManager;
import com.ibm.ws.sm.workspace.template.TemplateManagerFactory;
import java.io.File;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class WorkspaceHelper {
    private static TraceComponent tc = Tr.register(WorkspaceHelper.class, "management", "com.ibm.ws.management.resources.configservice");
    public static final String SESSION = "_WEBSPHERE_CONFIG_SESSION";

    public static WorkSpace getWorkspace(EObject eObject) {
        WorkSpace workSpace = null;
        Resource resource = eObject.eResource();
        if (resource != null) {
            ResourceSet resourceSet = resource.getResourceSet();
            RepositoryContext repositoryContext = WorkspaceHelper.getContext(resource);
            if (repositoryContext != null) {
                workSpace = repositoryContext.getWorkSpace();
            }
        }
        return workSpace;
    }

    public static WorkSpace getWorkspace(Session session) throws ConfigServiceException {
        WorkSpace workSpace;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWorkspace", session);
        }
        WorkSpaceManager workSpaceManager = WorkSpaceManagerFactory.getManager();
        try {
            workSpace = session.isShareWorkspace() ? workSpaceManager.getWorkSpace(session.getUserName()) : workSpaceManager.getWorkSpace(session.toString());
        }
        catch (WorkSpaceException workSpaceException) {
            FFDCFilter.processException(workSpaceException, "com.ibm.ws.management.configservice.WorkspaceHelper.getWorkspace", "47");
            throw new ConfigServiceException(workSpaceException, workSpaceException.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWorkspace", workSpace);
        }
        return workSpace;
    }

    public static RepositoryContext getContext(Session session, ConfigDataId configDataId) throws ConfigServiceException {
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        return WorkspaceHelper.getContext(workSpace, configDataId);
    }

    public static RepositoryContext getContext(WorkSpace workSpace, ConfigDataId configDataId) throws ConfigServiceException {
        RepositoryContext repositoryContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContext", new Object[]{workSpace, configDataId});
        }
        try {
            repositoryContext = workSpace.findContext(configDataId.getContextUri());
        }
        catch (WorkSpaceException workSpaceException) {
            FFDCFilter.processException(workSpaceException, "com.ibm.ws.management.configservice.WorkspaceHelper.getContext", "69");
            throw new ConfigServiceException(workSpaceException, workSpaceException.getMessage());
        }
        if (repositoryContext == null) {
            throw new ConfigDataNotFoundException(MOFUtil.getURI(configDataId).path(), configDataId, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContext", repositoryContext);
        }
        return repositoryContext;
    }

    public static DocAccessor getDocAccessor(WorkSpace workSpace, ConfigDataId configDataId) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDocAccessor", new Object[]{workSpace, configDataId});
        }
        RepositoryContext repositoryContext = WorkspaceHelper.getContext(workSpace, configDataId);
        String string = MOFUtil.getURI(configDataId).path();
        DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(repositoryContext, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDocAccessor", docAccessor);
        }
        return docAccessor;
    }

    public static DocAccessor getDocAccessorNoCreate(RepositoryContext repositoryContext, String string) throws ConfigServiceException {
        return WorkspaceHelper.getDocAccessorInternal(repositoryContext, string, false);
    }

    public static DocAccessor getDocAccessor(RepositoryContext repositoryContext, String string) throws ConfigServiceException {
        return WorkspaceHelper.getDocAccessorInternal(repositoryContext, string, true);
    }

    private static DocAccessor getDocAccessorInternal(final RepositoryContext repositoryContext, final String string, boolean bl) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDocAccessor", new Object[]{repositoryContext, string});
        }
        Thread thread = null;
        ClassLoader classLoader = null;
        try {
            Object object;
            thread = Thread.currentThread();
            classLoader = thread.getContextClassLoader();
            thread.setContextClassLoader((ClassLoader)ExtClassLoader.getInstance());
            Resource resource = repositoryContext.getResourceSet().getResource(URI.createURI((String)string), false);
            if (resource == null) {
                if (repositoryContext.isAvailable(string)) {
                    if (!repositoryContext.isExtracted(string)) {
                        if (!RestrictedAccess.isReadable(string)) {
                            try {
                                object = ContextManagerFactory.getInstance().getServerSubject();
                                ContextManagerFactory.getInstance().runAsSpecified((Subject)object, new PrivilegedExceptionAction(){

                                    public Object run() throws Exception {
                                        repositoryContext.extract(string, false);
                                        return null;
                                    }
                                });
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                throw privilegedActionException.getException();
                            }
                        } else {
                            repositoryContext.extract(string, false);
                        }
                    }
                    resource = repositoryContext.getResourceSet().getResource(URI.createURI((String)string), true);
                } else if (bl) {
                    object = repositoryContext.getResourceSet().getResourceFactoryRegistry().getFactory(URI.createURI((String)string));
                    resource = object.createResource(URI.createURI((String)string));
                    repositoryContext.getResourceSet().getResources().add((Object)resource);
                }
            }
            if (resource == null) {
                object = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0505E", new Object[]{string}, null);
                throw new Exception((String)object);
            }
            resource.setTrackingModification(true);
            object = new DocAccessor(resource);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getDocAccessor", object);
            }
            Object object2 = object;
            return object2;
        }
        catch (Exception exception) {
            if (bl) {
                FFDCFilter.processException(exception, "com.ibm.ws.management.configservice.WorkspaceHelper.getDocAccessor", "96");
            }
            throw new ConfigDocumentLoadException(repositoryContext.getURI() + '/' + string, exception);
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }

    public static DocAccessor getDocAccessor(Session session, ConfigDataId configDataId) throws ConfigServiceException {
        WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
        return WorkspaceHelper.getDocAccessor(workSpace, configDataId);
    }

    public static DocAccessor getDocAccessor(Session session, WorkSpaceFile workSpaceFile) throws ConfigServiceException {
        String string;
        String string2 = workSpaceFile.getURI();
        int n = string2.lastIndexOf(string = workSpaceFile.getFileName().replace(File.separatorChar, '/'));
        String string3 = n <= 0 ? "" : string2.substring(0, n - 1);
        return WorkspaceHelper.getDocAccessor(session, new ConfigDataId(string3, string));
    }

    public static Collection getScopeContexts(Session session, ObjectName objectName) throws ConfigServiceException {
        Collection<RepositoryContext> collection;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getScopeContexts", new Object[]{session, objectName});
        }
        try {
            if (objectName == null) {
                WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
                RepositoryMetaData repositoryMetaData = RepositoryMetaDataFactory.getRepositoryMetaData();
                collection = workSpace.findContext(repositoryMetaData.getContextType("cells"));
            } else {
                collection = new ArrayList<RepositoryContext>(1);
                collection.add(WorkspaceHelper.getContext(session, ConfigServiceHelper.getConfigDataId(objectName)));
            }
        }
        catch (WorkSpaceException workSpaceException) {
            throw new ConfigServiceException(workSpaceException, workSpaceException.getLocalizedMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getScopeContexts", collection);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EObject getTemplate(WorkSpace workSpace, EClassifier eClassifier, ObjectName objectName) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTemplate", new Object[]{workSpace, eClassifier, objectName});
        }
        EObject eObject = null;
        if (objectName == null) {
            eObject = WorkspaceHelper.getTemplate(workSpace, eClassifier);
        } else {
            ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
            WorkSpace workSpace2 = workSpace;
            Session session = WorkspaceHelper.getConfigSession(objectName);
            if (session != null) {
                workSpace2 = WorkspaceHelper.getWorkspace(session);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "template workspace", workSpace2);
            }
            DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(workSpace2, configDataId);
            Resource resource = docAccessor.getResource();
            synchronized (resource) {
                eObject = docAccessor.lookup(configDataId);
                if (!eClassifier.isInstance((Object)eObject)) {
                    String string = TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0021E", new Object[]{TypeRegistry.getTypeShortName(eClassifier), TypeRegistry.getTypeShortName((EClassifier)eObject.eClass())}, null);
                    throw new ConfigServiceException(string);
                }
                TemplateManager templateManager = TemplateManagerFactory.getManager(workSpace2);
                eObject = templateManager.getRefObjectHelper().clone(eObject);
                WorkspaceHelper.clearNameAttribute(eObject);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTemplate", eObject);
        }
        return eObject;
    }

    private static EObject getTemplate(WorkSpace workSpace, EClassifier eClassifier) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTemplate", new Object[]{workSpace, eClassifier});
        }
        EObject eObject = null;
        try {
            TemplateManager templateManager = TemplateManagerFactory.getManager(workSpace);
            RepositoryContext repositoryContext = templateManager.getRootTemplateContext();
            if (repositoryContext == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getTemplate", eObject);
                }
                return eObject;
            }
            repositoryContext = repositoryContext.findContext("default");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "templateContext", repositoryContext);
            }
            List list = null;
            list = TypeRegistry.getTypeShortName(eClassifier).equals("Server") ? repositoryContext.getAllList(true) : repositoryContext.getAllList(false);
            ArrayList<EObject> arrayList = new ArrayList<EObject>();
            Object object = list.iterator();
            block4: while (object.hasNext()) {
                WorkSpaceFile workSpaceFile = (WorkSpaceFile)object.next();
                if (!workSpaceFile.getFileName().endsWith(".xml")) continue;
                try {
                    DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(workSpaceFile.getContext(), workSpaceFile.getFileName());
                    Resource resource = docAccessor.getResource();
                    EList eList = resource.getContents();
                    Iterator iterator = eList.iterator();
                    while (iterator.hasNext()) {
                        EObject eObject2 = (EObject)iterator.next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "root obj", eObject2);
                        }
                        if (!eClassifier.equals(eObject2.eClass())) continue;
                        arrayList.add(eObject2);
                        break block4;
                    }
                }
                catch (Exception exception) {
                    if (!tc.isEventEnabled()) continue;
                    Tr.event(tc, "unable to load templates", "templates" + workSpaceFile.getFileName());
                }
            }
            if (arrayList.size() == 0) {
                eObject = null;
            } else {
                eObject = (EObject)arrayList.iterator().next();
                object = templateManager.getRefObjectHelper();
                eObject = object.clone(eObject);
                WorkspaceHelper.clearNameAttribute(eObject);
            }
        }
        catch (Exception exception) {
            throw new ConfigServiceException(exception, exception.getLocalizedMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTemplate", eObject);
        }
        return eObject;
    }

    public static ValidationManager getValidationManager(Session session) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getValidationManager", session);
        }
        try {
            WorkSpace workSpace = WorkspaceHelper.getWorkspace(session);
            ValidationManagerRegistry validationManagerRegistry = ValidationHelper.getRegistry();
            ValidationManager validationManager = validationManagerRegistry.getValidationManager(workSpace);
            if (validationManager == null) {
                ValidationPolicy validationPolicy = ValidationHelper.createPolicy();
                validationPolicy.setIncludeCross(true);
                validationPolicy.setIncludeExtracted(true);
                validationPolicy.setIncludeParentChain(true);
                validationPolicy.setIncludeLocalSiblings(true);
                validationPolicy.setIncludeAll(false);
                validationManager = validationManagerRegistry.getValidationManager(workSpace, validationPolicy, true);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getValidationManager", validationManager);
            }
            return validationManager;
        }
        catch (ValidationManagerException validationManagerException) {
            throw new ConfigServiceException(validationManagerException, TraceNLS.getFormattedMessage("com.ibm.ws.management.resources.configservice", "ADMG0016E", new Object[]{session}, null));
        }
    }

    public static boolean isConfigDocument(RepositoryContextType repositoryContextType, String string) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isConfigDocument", new Object[]{repositoryContextType, string});
        }
        boolean bl2 = bl = repositoryContextType.getChildDocumentType(string) != null;
        if (!bl) {
            Iterator iterator = repositoryContextType.getChildContextTypes().iterator();
            while (iterator.hasNext() && !(bl = WorkspaceHelper.isConfigDocument((RepositoryContextType)iterator.next(), string))) {
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isConfigDocument," + bl);
        }
        return bl;
    }

    public static RepositoryContext getContext(Resource resource) {
        ContextResourceSet contextResourceSet = (ContextResourceSet)resource.getResourceSet();
        return contextResourceSet.getContext();
    }

    static String getType(Session session, ObjectName objectName) throws ConfigServiceException {
        String string = ConfigServiceHelper.getConfigDataType(objectName);
        if (string == null) {
            ConfigDataId configDataId = ConfigServiceHelper.getConfigDataId(objectName);
            DocAccessor docAccessor = WorkspaceHelper.getDocAccessor(session, configDataId);
            string = ConfigServiceHelper.getConfigDataType(docAccessor.resolveObjectName(session, configDataId));
        }
        return string;
    }

    static ConfigServiceDelegator getDelegator(Session session, ObjectName objectName) throws ConfigServiceException {
        ConfigServiceImpl configServiceImpl = ConfigServiceImpl.getInstance();
        return configServiceImpl.getDelegator(WorkspaceHelper.getType(session, objectName));
    }

    static boolean isScopeContext(Session session, ObjectName objectName) throws ConfigServiceException {
        ConfigDataId configDataId;
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isScopeContext", new Object[]{session, objectName});
        }
        boolean bl2 = bl = (configDataId = ConfigServiceHelper.getConfigDataId(objectName)).getHref() == null;
        if (!bl) {
            ConfigServiceDelegator configServiceDelegator = WorkspaceHelper.getDelegator(session, objectName);
            boolean bl3 = bl = configServiceDelegator instanceof RootObjectDelegator && ((RootObjectDelegator)configServiceDelegator).isRootDocumentType();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isScopeContext," + bl);
        }
        return bl;
    }

    private static void clearNameAttribute(EObject eObject) {
        try {
            EStructuralFeature eStructuralFeature = MOFUtil.getAttributeMetaObj((EObject)eObject.eClass(), "name", false);
            eObject.eUnset(eStructuralFeature);
        }
        catch (InvalidAttributeNameException invalidAttributeNameException) {
            // empty catch block
        }
    }

    public static ObjectName createObjectName(ConfigDataId configDataId, String string, String string2, Session session) {
        ObjectName objectName = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (string2 != null && (string2.indexOf("=") > 0 || string2.indexOf(":") > 0)) {
            string2 = "\"" + string2 + "\"";
        }
        if (configDataId != null) {
            hashtable.put("_Websphere_Config_Data_Id", configDataId.toString());
        }
        if (string != null) {
            hashtable.put("_Websphere_Config_Data_Type", string);
        }
        if (string2 != null && !string2.trim().equals("")) {
            hashtable.put("_Websphere_Config_Data_Display_Name", string2);
        }
        if (session != null && session.toString().trim().length() > 0) {
            hashtable.put(SESSION, session.toString());
        }
        try {
            objectName = new ObjectName("Websphere", hashtable);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            FFDCFilter.processException(malformedObjectNameException, "com.ibm.ws.management.configservice.WorkspaceHelper.createObjectName", "171");
        }
        return objectName;
    }

    public static Session getConfigSession(ObjectName objectName) {
        String string = objectName.getKeyProperty(SESSION);
        return string == null ? null : new Session(string, true);
    }

    public static boolean containVersion5Memeber(Session session, ObjectName objectName) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "containVersion5Member", new Object[]{session, objectName});
        }
        boolean bl = false;
        try {
            ConfigServiceImpl configServiceImpl = ConfigServiceImpl.getInstance();
            List list = (List)configServiceImpl.getAttribute(session, objectName, "members");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AttributeList attributeList = (AttributeList)iterator.next();
                String string = (String)ConfigServiceHelper.getAttributeValue(attributeList, "nodeName");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "nodeName", string);
                }
                if (!(bl = MOFUtil.isNodeVersion5(WorkspaceHelper.getWorkspace(session), string))) continue;
                break;
            }
        }
        catch (ConnectorException connectorException) {
            FFDCFilter.processException(connectorException, "com.ibm.ws.management.configservice.WorkspaceHelper.containVersion5Memeber", "426");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            FFDCFilter.processException(attributeNotFoundException, "com.ibm.ws.management.configservice.WorkspaceHelper.containVersion5Memeber", "435");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "containVersion5Member" + bl);
        }
        return bl;
    }

    public static boolean containVersion5DeploymentTarget(Session session, ObjectName objectName) throws ConfigServiceException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "containVersion5DeploymentTarget", new Object[]{session, objectName});
        }
        boolean bl = false;
        try {
            ConfigServiceImpl configServiceImpl = ConfigServiceImpl.getInstance();
            List list = (List)configServiceImpl.getAttribute(session, objectName, "deploymentTargets");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object;
                AttributeList attributeList = (AttributeList)iterator.next();
                String string = (String)ConfigServiceHelper.getAttributeValue(attributeList, "name");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "name", string);
                }
                String string2 = (String)ConfigServiceHelper.getAttributeValue(attributeList, "_Websphere_Config_Data_Type");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "type", string2);
                }
                if (string2.equals("ClusteredTarget")) {
                    object = ConfigServiceHelper.createObjectName(null, "ServerCluster", null);
                    ObjectName[] objectNameArray = configServiceImpl.queryConfigObjects(session, null, (ObjectName)object, null);
                    if (objectNameArray.length <= 0 || !(bl = WorkspaceHelper.containVersion5Memeber(session, objectNameArray[0]))) continue;
                } else {
                    object = (String)ConfigServiceHelper.getAttributeValue(attributeList, "nodeName");
                    bl = MOFUtil.isNodeVersion5(WorkspaceHelper.getWorkspace(session), (String)object);
                    if (!bl) continue;
                }
                break;
            }
        }
        catch (ConnectorException connectorException) {
            FFDCFilter.processException(connectorException, "com.ibm.ws.management.configservice.WorkspaceHelper.containVersion5Memeber", "426");
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            FFDCFilter.processException(attributeNotFoundException, "com.ibm.ws.management.configservice.WorkspaceHelper.containVersion5Memeber", "435");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "containVersion5DeploymentTarget" + bl);
        }
        return bl;
    }
}

