/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice.configdiff;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.configservice.schemadiff.ChangedObject;
import com.ibm.ws.management.configservice.schemadiff.Property;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.eclipse.emf.common.util.EList;

public class ConfigChangeId {
    private static TraceComponent tc = Tr.register(ConfigChangeId.class, "management", "com.ibm.ws.management.resources.configservice");
    private String id;
    private Properties props;

    public ConfigChangeId(String string, Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConfigChangeId", new Object[]{string, properties});
        }
        this.sort(string, properties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConfigChangeId");
        }
    }

    public ConfigChangeId(String string, ChangedObject changedObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConfigChangeId", new Object[]{string, changedObject});
        }
        EList eList = changedObject.getProperty();
        Properties properties = new Properties();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            properties.put(property.getName(), property.getValue());
        }
        this.sort(string, properties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConfigChangeId");
        }
    }

    private void sort(String string, Properties properties) {
        this.id = "#" + string + "#";
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>(properties);
        Iterator<Map.Entry<Object, Object>> iterator = treeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            this.id = this.id + entry.getKey() + "=" + entry.getValue() + "#";
        }
    }

    public String toString() {
        return this.id;
    }

    public Properties getConfigChange() {
        return this.props;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) throws ClassCastException {
        ConfigChangeId configChangeId = (ConfigChangeId)object;
        return this.hashCode() == configChangeId.hashCode();
    }
}

