/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice.configdiff;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.configservice.configdiff.ConfigChangeId;
import com.ibm.ws.management.configservice.configdiff.TimeLineDataBase;
import com.ibm.ws.management.configservice.configdiff.TimeLineSegment;
import com.ibm.ws.management.configservice.configdiff.Version;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class ConfigTimeLineDataBase
extends TimeLineDataBase {
    private static TraceComponent tc = Tr.register(ConfigTimeLineDataBase.class, "management", "com.ibm.ws.management.resources.configservice");
    private String SCHEMADIFF_FILE_NAME = "META-INF/ws-config-schemadiff.xml";
    private static ConfigTimeLineDataBase instance = null;
    private String SCHEMA_TYPE = "config";
    private static String VALIDITY = "validity";
    private static String VALID = "valid";
    private static String REMOVED = "removed";
    private static String DEPRECATED = "deprecated";
    private static String PACKAGE = "package";
    private static String TYPE = "type";
    private static String ATTRIBUTE = "attribute";

    protected ConfigTimeLineDataBase() {
        this.init(this.SCHEMADIFF_FILE_NAME);
    }

    public static ConfigTimeLineDataBase getInstance() {
        if (instance == null) {
            instance = new ConfigTimeLineDataBase();
        }
        return instance;
    }

    public boolean isPackageValid(Properties properties, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isPackageValid", new Object[]{properties, string});
        }
        Properties properties2 = new Properties();
        properties2.put(PACKAGE, string);
        ConfigChangeId configChangeId = new ConfigChangeId(this.SCHEMA_TYPE, properties2);
        boolean bl = this.determineValidity(configChangeId, properties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isPackageValid", new Boolean(bl));
        }
        return bl;
    }

    public boolean isTypeValid(Properties properties, String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTypeValid", new Object[]{properties, string, string2});
        }
        Properties properties2 = new Properties();
        properties2.put(PACKAGE, string);
        properties2.put(TYPE, string2);
        ConfigChangeId configChangeId = new ConfigChangeId(this.SCHEMA_TYPE, properties2);
        boolean bl = this.determineValidity(configChangeId, properties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTypeValid", new Boolean(bl));
        }
        return bl;
    }

    public boolean isAttributeValid(Properties properties, String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAttributeValid", new Object[]{properties, string, string2, string3});
        }
        Properties properties2 = new Properties();
        properties2.put(PACKAGE, string);
        properties2.put(TYPE, string2);
        properties2.put(ATTRIBUTE, string3);
        ConfigChangeId configChangeId = new ConfigChangeId(this.SCHEMA_TYPE, properties2);
        boolean bl = this.determineValidity(configChangeId, properties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAttributeValid", new Boolean(bl));
        }
        return bl;
    }

    public boolean determineValidity(ConfigChangeId configChangeId, Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "determineValidity", new Object[]{configChangeId, properties});
        }
        if (properties == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "determineValidity - nodeProperties is null", new Boolean(true));
            }
            return true;
        }
        List list = super.getTimeLineSegments(configChangeId, properties);
        if (list.size() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "determineValidity - no match", new Boolean(true));
            }
            return true;
        }
        TimeLineSegment timeLineSegment = null;
        String string = null;
        String string2 = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string3;
            TimeLineSegment timeLineSegment2 = (TimeLineSegment)iterator.next();
            String string4 = timeLineSegment2.getTimeLine().getVersionKey();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Version Key: " + string4);
            }
            String string5 = (String)properties.get(string4);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Node Version: " + string5);
            }
            if (string5 == null || string5.trim().equals("")) {
                Tr.audit(tc, "Node Version not found, skipping");
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TimeLineSegment", timeLineSegment2);
            }
            if ((string3 = (String)timeLineSegment2.getChangedData().get(VALIDITY)) == null) continue;
            Version version = new Version(string5);
            String string6 = timeLineSegment2.getVersion();
            Version version2 = new Version(timeLineSegment2.getVersion());
            int n = version.compareTo(version2);
            if (n >= 0) {
                string2 = string6;
                if (string3.equals(VALID)) {
                    timeLineSegment = timeLineSegment2;
                    string = VALID;
                    continue;
                }
                if (string3.equals(DEPRECATED)) {
                    if (timeLineSegment != null && VALID.equals(string)) continue;
                    timeLineSegment = timeLineSegment2;
                    string = DEPRECATED;
                    continue;
                }
                if (!string3.equals(REMOVED) || timeLineSegment != null) continue;
                timeLineSegment = timeLineSegment2;
                string = REMOVED;
                continue;
            }
            string2 = string5;
            if (string3.equals(VALID)) {
                if (timeLineSegment != null) continue;
                timeLineSegment = timeLineSegment2;
                string = REMOVED;
                continue;
            }
            if (string3.equals(DEPRECATED)) {
                if (timeLineSegment != null && VALID.equals(string)) continue;
                timeLineSegment = timeLineSegment2;
                string = VALID;
                continue;
            }
            if (!string3.equals(REMOVED) || timeLineSegment != null && VALID.equals(string)) continue;
            timeLineSegment = timeLineSegment2;
            string = VALID;
        }
        if (timeLineSegment == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "determineValidity", new Object[]{timeLineSegment, new Boolean(true)});
            }
            return true;
        }
        if (VALID.equals(string)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "determineValidity", new Object[]{timeLineSegment, new Boolean(true)});
            }
            return true;
        }
        if (DEPRECATED.equals(string)) {
            Tr.warning(tc, "ADMG0301W", new Object[]{configChangeId, string2});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "determineValidity", new Object[]{timeLineSegment, new Boolean(true)});
            }
            return true;
        }
        if (REMOVED.equals(string)) {
            Tr.error(tc, "ADMG0302E", new Object[]{configChangeId, string2});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "determineValidity deprecated", new Boolean(false));
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "determineValidity", new Object[]{timeLineSegment, new Boolean(false)});
        }
        return false;
    }
}

