/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice.configdiff;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.configservice.schemadiff.ProductCapability;
import com.ibm.ws.management.configservice.schemadiff.ProductProperty;
import com.ibm.ws.management.configservice.schemadiff.Property;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.emf.common.util.EList;

public class SPXId {
    private static TraceComponent tc = Tr.register(SPXId.class, "management", "com.ibm.ws.management.resources.configservice");
    private String id;
    private Properties props = new Properties();
    private String versionKey;

    public SPXId(ProductCapability productCapability) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SPXId", new Object[]{productCapability});
        }
        this.versionKey = productCapability.getVersionKey();
        this.versionKey = productCapability.getVersionKey();
        EList eList = productCapability.getProductProperty();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            ProductProperty productProperty = (ProductProperty)iterator.next();
            this.props.put(productProperty.getName(), productProperty);
        }
        this.sort(this.props);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "SPXId");
        }
    }

    private void sort(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sort", properties);
        }
        this.id = "%";
        if (properties == null || properties.size() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "sort - no properties", this.id);
            }
            return;
        }
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>(properties);
        Set<Map.Entry<Object, Object>> set = treeMap.entrySet();
        Iterator<Map.Entry<Object, Object>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            if (entry.getValue() instanceof ProductProperty) {
                ProductProperty productProperty = (ProductProperty)entry.getValue();
                this.id = this.id + productProperty.getName() + "=" + productProperty.getValue() + "%";
                continue;
            }
            this.id = this.id + entry.getKey() + "=" + entry.getValue() + "%";
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sort", this.id);
        }
    }

    public String toString() {
        return this.id;
    }

    public Properties getSPXProperties() {
        return this.props;
    }

    public boolean match(Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "match", new Object[]{this.props, properties});
        }
        if (properties == null) {
            return false;
        }
        if (properties.get(this.versionKey) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "match", new Object[]{"node does not contain versionKey", this.versionKey});
            }
            return false;
        }
        Iterator<Map.Entry<Object, Object>> iterator = this.props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            Property property = (Property)entry.getValue();
            String string = property.getName();
            String string2 = property.getValue();
            String string3 = (String)properties.get(string);
            if (string.equals(this.versionKey)) continue;
            if (string2 != null) {
                if (string2.equals(string3)) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "match", new Object[]{"mismatch", string, string2, string3});
                }
                return false;
            }
            if (string3 == null) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "match", new Object[]{"mismatch", string, string2, string3});
            }
            return false;
        }
        return true;
    }
}

