/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice.configdiff;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.configservice.configdiff.ConfigChangeId;
import com.ibm.ws.management.configservice.configdiff.SPXId;
import com.ibm.ws.management.configservice.configdiff.TimeLine;
import com.ibm.ws.management.configservice.configdiff.TimeLineImpl;
import com.ibm.ws.management.configservice.configdiff.TimeLineSegment;
import com.ibm.ws.management.configservice.configdiff.TimeLineSegmentImpl;
import com.ibm.ws.management.configservice.configdiff.Version;
import com.ibm.ws.management.configservice.schemadiff.ConfigChange;
import com.ibm.ws.management.configservice.schemadiff.ProductCapability;
import com.ibm.ws.management.configservice.schemadiff.ProductDiff;
import com.ibm.ws.management.configservice.schemadiff.ProductProperty;
import com.ibm.ws.management.configservice.schemadiff.SchemaDiff;
import com.ibm.ws.management.configservice.schemadiff.SchemadiffFactory;
import com.ibm.ws.management.configservice.schemadiff.SchemadiffPackage;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLMapImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.osgi.framework.Bundle;

public abstract class TimeLineDataBase {
    protected static Map timeLineCache = Collections.synchronizedMap(new HashMap());
    private static TraceComponent tc = Tr.register(TimeLineDataBase.class, "management", "com.ibm.ws.management.resources.configservice");
    private static SchemadiffFactory dfac = null;

    protected void createTimeLine(String string, ProductCapability productCapability, ConfigChange configChange) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTimeLine", new Object[]{productCapability, configChange});
        }
        ConfigChangeId configChangeId = new ConfigChangeId(string, configChange.getChangedObject());
        SPXId sPXId = new SPXId(productCapability);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Searching with ConfigId: ", configChangeId);
        }
        LinkedList<TimeLineImpl> linkedList = (LinkedList<TimeLineImpl>)timeLineCache.get(configChangeId);
        TimeLineImpl timeLineImpl = null;
        if (linkedList == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not find SPX List");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found a SPX List");
            }
            ListIterator listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                TimeLineImpl timeLineImpl2 = (TimeLineImpl)listIterator.next();
                if (!timeLineImpl2.sameProductCapability(string, productCapability)) continue;
                timeLineImpl = timeLineImpl2;
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Found an existing TimeLineImpl SPX List with matching product capabilities: " + timeLineImpl);
                break;
            }
            if (timeLineImpl == null && tc.isDebugEnabled()) {
                Tr.debug(tc, "Did not find an existing TimeLineImpl SPX List with matching product capabilities: " + productCapability);
            }
        }
        boolean bl = false;
        if (linkedList == null) {
            linkedList = new LinkedList<TimeLineImpl>();
            bl = true;
        }
        boolean bl2 = false;
        if (timeLineImpl == null) {
            timeLineImpl = new TimeLineImpl(string, productCapability, configChange);
            bl2 = true;
        }
        EList eList = productCapability.getProductProperty();
        String string2 = null;
        String string3 = productCapability.getVersionKey();
        Object object = eList.iterator();
        while (object.hasNext()) {
            ProductProperty productProperty = (ProductProperty)object.next();
            if (!productProperty.getName().equals(string3)) continue;
            string2 = productProperty.getValue();
            break;
        }
        object = new TimeLineSegmentImpl(string2, configChange.getChangedData(), timeLineImpl);
        timeLineImpl.addTimeLineSegment((TimeLineSegment)object);
        if (bl2) {
            linkedList.add(timeLineImpl);
        }
        if (bl) {
            timeLineCache.put(configChangeId, linkedList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTimeLine", timeLineImpl);
        }
    }

    public List getTimeLine(ConfigChangeId configChangeId) {
        LinkedList linkedList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimeLine", new Object[]{configChangeId});
        }
        if ((linkedList = (LinkedList)timeLineCache.get(configChangeId)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getTimeLine", "spx is null");
            }
            linkedList = new LinkedList();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimeLine", new Object[]{linkedList});
        }
        return linkedList;
    }

    public List getTimeLineSegments(ConfigChangeId configChangeId, Properties properties) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimeLineSegments", new Object[]{configChangeId, properties});
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        List list = (List)timeLineCache.get(configChangeId);
        if (list != null) {
            object5 = list.iterator();
            while (object5.hasNext()) {
                object4 = (TimeLine)object5.next();
                if (!object4.match(properties)) continue;
                object3 = object4.getVersionKey();
                object2 = (String)properties.get(object3);
                object = object4.getClosestSegment((String)object2);
                linkedList.add(object);
            }
        }
        if (linkedList.size() <= 1) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTimeLineSegments", new Object[]{linkedList});
            }
            return linkedList;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getTimeLineSegments", "Finding bestmatch for each product");
        }
        object5 = new Hashtable();
        object4 = linkedList.iterator();
        while (object4.hasNext()) {
            object3 = (TimeLineSegment)object4.next();
            object2 = object3.getTimeLine().getVersionKey();
            object = (List)((Hashtable)object5).get(object2);
            if (object == null) {
                object = new LinkedList<Object>();
                ((Hashtable)object5).put(object2, object);
            }
            object.add(object3);
        }
        linkedList = new LinkedList();
        object4 = ((Hashtable)object5).values().iterator();
        while (object4.hasNext()) {
            object3 = (List)object4.next();
            object2 = (TimeLineSegment)object3.remove(0);
            object = new Version(object2.getVersion());
            String string = object2.getTimeLine().getVersionKey();
            Version version = new Version((String)properties.get(string));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getTimeLineSegments", new Object[]{"finding preferred segment", string, object2});
            }
            while (object3.size() > 0) {
                int n;
                Object object6;
                Object object7 = (TimeLineSegment)object3.remove(0);
                Object object8 = new Version(object7.getVersion());
                int n2 = ((Version)object).compareTo(object8);
                if (n2 == 0) {
                    object6 = object2.getTimeLine().getProductCapabilities();
                    Properties properties2 = object7.getTimeLine().getProductCapabilities();
                    if (properties2.size() > ((Properties)object6).size()) {
                        object2 = object7;
                        object = object8;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "getTimeLineSegments", new Object[]{"same segment version; preferred segment", object2});
                    continue;
                }
                if (n2 > 0) {
                    object6 = object2;
                    object2 = object7;
                    object7 = object6;
                    Object object9 = object;
                    object = object8;
                    object8 = object9;
                    n2 = -1;
                }
                if ((n = version.compareTo(object)) <= 0) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "getTimeLineSegments", new Object[]{"nodeVersion <= seg1Version < seg2Version; preferred segment", object2});
                    continue;
                }
                int n3 = version.compareTo(object8);
                if (n3 < 0) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "getTimeLineSegments", new Object[]{"seg1Version < nodeVersion < seg2Version; preferred segment", object2});
                    continue;
                }
                object2 = object7;
                object = object8;
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "getTimeLineSegments", new Object[]{"seg1Version < seg2Version <= nodeVersion; preferred segment", object2});
            }
            linkedList.add(object2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimeLineSegments", new Object[]{linkedList});
        }
        return linkedList;
    }

    protected void init(String string) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init", string);
        }
        SchemadiffPackage schemadiffPackage = SchemadiffPackage.eINSTANCE;
        List list = this.loadResources(string);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (SchemaDiff)iterator.next();
            this.buildTimeLines((SchemaDiff)object);
        }
        object = timeLineCache.entrySet();
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator2.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "timeLineCache key", entry.getKey());
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "timeLineCache value", entry.getValue());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    protected void buildTimeLines(SchemaDiff schemaDiff) {
        try {
            EList eList = schemaDiff.getProductDiff();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                ProductDiff productDiff = (ProductDiff)iterator.next();
                String string = productDiff.getSchemaType();
                ProductCapability productCapability = productDiff.getProductCapability();
                EList eList2 = productDiff.getConfigChange();
                Iterator iterator2 = eList2.iterator();
                while (iterator2.hasNext()) {
                    ConfigChange configChange = (ConfigChange)iterator2.next();
                    this.createTimeLine(string, productCapability, configChange);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected List loadResources(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadResources", string);
        }
        ArrayList<SchemaDiff> arrayList = new ArrayList<SchemaDiff>();
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        XMIResourceImpl xMIResourceImpl = new XMIResourceImpl();
        xMIResourceImpl.setURI(URI.createURI((String)"SchemaDiff"));
        IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (iExtensionRegistry == null) {
            Tr.error(tc, "Unable to get eclipse extension registry");
            return null;
        }
        String string2 = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".config-schemadiff";
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string2);
        if (iExtensionPoint == null) {
            Tr.error(tc, "Unable to get extension point - " + string2);
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Processing extension point " + string2);
        }
        HashSet<Long> hashSet = new HashSet<Long>();
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        for (int i = 0; i < iExtensionArray.length; ++i) {
            Bundle bundle;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing extension " + iExtensionArray[i].getUniqueIdentifier());
            }
            if ((bundle = Platform.getBundle((String)iExtensionArray[i].getNamespace())) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Bundle is null; returning empty list");
                }
                return arrayList;
            }
            long l = bundle.getBundleId();
            Long l2 = new Long(l);
            if (hashSet.contains(l2)) continue;
            hashSet.add(l2);
            Enumeration enumeration = null;
            try {
                enumeration = bundle.getResources(string);
            }
            catch (IOException iOException) {
                Tr.error(tc, "unable to get resources for bundle " + l, iOException);
            }
            while (enumeration.hasMoreElements()) {
                URL uRL = (URL)enumeration.nextElement();
                SchemaDiff schemaDiff = this.loadSchemadiff(uRL);
                arrayList.add(schemaDiff);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadResources", arrayList);
        }
        return arrayList;
    }

    private SchemaDiff loadSchemadiff(URL uRL) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadSchemadiff", uRL);
        }
        SchemaDiff schemaDiff = null;
        try {
            XMLResourceImpl xMLResourceImpl = new XMLResourceImpl();
            XMLMapImpl xMLMapImpl = new XMLMapImpl();
            HashMap<String, XMLMapImpl> hashMap = new HashMap<String, XMLMapImpl>(1);
            hashMap.put("XML_MAP", xMLMapImpl);
            xMLResourceImpl.setURI(URI.createURI((String)"META-INF/ws-config-schemadiff.xml"));
            InputStream inputStream = uRL.openStream();
            xMLResourceImpl.load(inputStream, hashMap);
            EList eList = xMLResourceImpl.getContents();
            if (eList.size() > 0) {
                schemaDiff = (SchemaDiff)xMLResourceImpl.getContents().get(0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Tr.warning(tc, "unable to load META-INF/ws-config-schemadiff in " + uRL.getFile(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadSchemadiff", schemaDiff);
        }
        return schemaDiff;
    }

    static {
        SchemadiffPackage schemadiffPackage = SchemadiffPackage.eINSTANCE;
        dfac = schemadiffPackage.getSchemadiffFactory();
    }
}

