/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.configservice.configdiff;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.configservice.configdiff.SPXId;
import com.ibm.ws.management.configservice.configdiff.TimeLine;
import com.ibm.ws.management.configservice.configdiff.TimeLineSegment;
import com.ibm.ws.management.configservice.configdiff.TimeLineSegmentImpl;
import com.ibm.ws.management.configservice.schemadiff.ChangedObject;
import com.ibm.ws.management.configservice.schemadiff.ConfigChange;
import com.ibm.ws.management.configservice.schemadiff.ProductCapability;
import com.ibm.ws.management.configservice.schemadiff.ProductProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;
import org.eclipse.emf.common.util.EList;

public class TimeLineImpl
implements TimeLine {
    private static TraceComponent tc = Tr.register(TimeLineImpl.class, "management", "com.ibm.ws.management.resources.configservice");
    private String schemaType = null;
    private String versionKey = null;
    private SPXId id = null;
    private Properties prodCap = new Properties();
    private TreeSet segments = new TreeSet();
    private ChangedObject changedObject = null;

    protected TimeLineImpl(String string, ProductCapability productCapability, ConfigChange configChange) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TimeLineImpl", new Object[]{string, productCapability, configChange});
        }
        this.schemaType = string;
        this.versionKey = productCapability.getVersionKey();
        this.changedObject = configChange.getChangedObject();
        EList eList = productCapability.getProductProperty();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            ProductProperty productProperty = (ProductProperty)iterator.next();
            this.prodCap.put(productProperty.getName(), productProperty);
        }
        this.id = new SPXId(productCapability);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Product capabilities", new Object[]{this.prodCap});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TimeLineImpl");
        }
    }

    public boolean sameProductCapability(String string, ProductCapability productCapability) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sameProductCapability", new Object[]{string, productCapability});
        }
        if (!string.equals(this.schemaType)) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "sameProductCapability", new Object[]{new Boolean(false), "schemaType mismatch", this.schemaType, string});
            }
            return false;
        }
        if (!this.versionKey.equals(productCapability.getVersionKey())) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "sameProductCapability", new Object[]{new Boolean(false), "versionKey mismatch", this.versionKey, productCapability.getVersionKey()});
            }
            return false;
        }
        EList eList = productCapability.getProductProperty();
        Properties properties = this.getProductCapabilities();
        if (eList.size() != properties.size()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "sameProductCapability", new Object[]{new Boolean(false), "property size mismatch", new Integer(properties.size()), new Integer(eList.size())});
            }
            return false;
        }
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            ProductProperty productProperty = (ProductProperty)iterator.next();
            String string2 = productProperty.getName();
            if (string2.equals(this.versionKey)) {
                if (!tc.isEntryEnabled()) continue;
                Tr.exit(tc, "sameProductCapability", "skipping versionKey: " + this.versionKey);
                continue;
            }
            ProductProperty productProperty2 = (ProductProperty)properties.get(string2);
            if (productProperty2 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "sameProductCapability", new Object[]{new Boolean(false), "property " + string2 + " does not exist"});
                }
                return false;
            }
            if (!productProperty2.getValue().equals(productProperty.getValue())) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "sameProductCapability", new Object[]{new Boolean(false), "property value mismatch for " + string2, productProperty2.getValue(), productProperty.getValue()});
                }
                return false;
            }
            String string3 = productProperty2.getOperator();
            String string4 = productProperty.getOperator();
            if ((string3 == null || string3.equals(string4)) && (string4 == null || string4.equals(string3))) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "sameProductCapability", new Object[]{new Boolean(false), "operator mismatch for " + string2, string3, string4});
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sameProductCapability", new Object[]{new Boolean(true)});
        }
        return true;
    }

    public String getSchemaType() {
        return this.schemaType;
    }

    public Properties getProductCapabilities() {
        return this.prodCap;
    }

    public String getVersionKey() {
        return this.versionKey;
    }

    public ChangedObject getChangedObject() {
        return this.changedObject;
    }

    public Iterator getTimeLineSegments() {
        return this.segments.iterator();
    }

    public TimeLineSegment getFirst() {
        return (TimeLineSegment)this.segments.first();
    }

    public TimeLineSegment getLast() {
        return (TimeLineSegment)this.segments.last();
    }

    public TimeLineSegment getClosestSegment(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClosestSegment", string);
        }
        TimeLineSegmentImpl timeLineSegmentImpl = new TimeLineSegmentImpl(string, null, null);
        ArrayList arrayList = new ArrayList(this.segments);
        int n = Collections.binarySearch(arrayList, timeLineSegmentImpl);
        TimeLineSegment timeLineSegment = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getClosestSegment list size is " + arrayList.size() + " index is " + n);
        }
        if (n >= 0) {
            timeLineSegment = (TimeLineSegment)arrayList.get(n);
        } else {
            if ((n = (n + 1) * -1 - 1) < 0) {
                n = 0;
            }
            timeLineSegment = (TimeLineSegment)arrayList.get(n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClosestSegment", timeLineSegment);
        }
        return timeLineSegment;
    }

    protected void setSchemaType(String string) {
        this.schemaType = string;
    }

    protected void addProductCapabilities(ProductProperty productProperty) {
        this.prodCap.put(productProperty.getName(), productProperty);
    }

    protected void setVersionKey(String string) {
        this.versionKey = string;
    }

    protected void setConfigChange(ConfigChange configChange) {
        this.changedObject = configChange.getChangedObject();
    }

    protected void addTimeLineSegment(TimeLineSegment timeLineSegment) {
        this.segments.add(timeLineSegment);
    }

    protected boolean containsTimeLineSegment(TimeLineSegment timeLineSegment) {
        return this.segments.contains(timeLineSegment);
    }

    public boolean equals(Object object) {
        if (object instanceof TimeLineImpl) {
            TimeLineImpl timeLineImpl = (TimeLineImpl)object;
            if (this.getChangedObject().equals(timeLineImpl.getChangedObject()) && this.getProductCapabilities().equals(timeLineImpl.getProductCapabilities())) {
                return true;
            }
        }
        return false;
    }

    protected SPXId getSPXId() {
        return this.id;
    }

    public String toString() {
        String string = "TimeLine: " + this.id + " changedObject: " + this.changedObject + "  segments: ";
        Iterator iterator = this.getTimeLineSegments();
        while (iterator.hasNext()) {
            TimeLineSegment timeLineSegment = (TimeLineSegment)iterator.next();
            String string2 = timeLineSegment.getVersion();
            Properties properties = timeLineSegment.getChangedData();
            string = string + "[" + string2 + "," + properties + "]";
        }
        return string;
    }

    public boolean match(Properties properties) {
        return this.id.match(properties);
    }
}

