/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.rmi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.connector.JMXConnector;
import com.ibm.ws.management.connector.rmi.RMIConnectorService;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class RMIConnectorController
implements JMXConnector {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register(RMIConnectorController.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.connector");
    private RMIConnectorService connector;
    private Properties connectorProps;
    private boolean started = false;
    private static final String JNDI_NAME = "RMIConnector";

    public void initialize(Properties properties) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", properties);
        }
        this.connectorProps = properties;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public void start() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        if (this.started) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "start - Connector already started");
            }
            return;
        }
        InitialContext initialContext = null;
        try {
            Properties properties = new Properties();
            properties.put("java.naming.provider.url", "corbaloc:rir:/WsnAdminNameService");
            initialContext = new InitialContext(properties);
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.management.connector.rmi.RMIConnectorController.start", "77", this);
            Tr.warning(tc, "ADMC0021W", namingException);
            throw new ConnectorNotAvailableException("", namingException);
        }
        try {
            this.connector = RMIConnectorService.getInstance();
            initialContext.rebind(JNDI_NAME, (Object)this.connector);
        }
        catch (RemoteException remoteException) {
            FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws.management.connector.rmi.RMIConnectorController.start", "90", this);
            Tr.warning(tc, "ADMC0022W", remoteException);
            throw new ConnectorNotAvailableException("", remoteException);
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.management.connector.rmi.RMIConnectorController.start", "98", this);
            Tr.warning(tc, "ADMC0021W", namingException);
            throw new ConnectorNotAvailableException("", namingException);
        }
        this.connector.start();
        this.started = true;
        Tr.audit(tc, "ADMC0026I", this.connectorProps.getProperty("port"));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start - RMI Connector started successfully");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        if (!this.started) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "stop - RMI Connector already stopped");
            }
            return;
        }
        this.connector.stop();
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            initialContext.unbind(JNDI_NAME);
            this.started = false;
        }
        catch (NamingException namingException) {
            FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.management.connector.rmi.RMIConnectorController.stop", "132", this);
            Tr.warning(tc, "ADMC0023W", namingException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public String getType() {
        return "RMI";
    }

    public Properties getProperties() {
        return this.connectorProps;
    }

    public String getName() {
        return "type=RMI;host=" + this.connectorProps.getProperty("host") + ";" + "port" + "=" + this.connectorProps.getProperty("port");
    }
}

