/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.rmi;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import com.ibm.ws.management.connector.AdminServiceDelegator;
import com.ibm.ws.management.connector.interop.JMXVersionValidation;
import com.ibm.ws.management.connector.rmi.RMIConnector;
import com.ibm.ws.management.connector.rmi.RMINotificationListener;
import com.ibm.ws.management.connector.rmi.RMINotificationListenerAdapter;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.exception.ReceiverNotFoundException;
import com.ibm.ws.management.util.Utils;
import java.rmi.RemoteException;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.rmi.PortableRemoteObject;

public class RMIConnectorService
extends PortableRemoteObject
implements RMIConnector {
    private static RMIConnectorService instance;
    private AdminServiceDelegator adminService;
    private boolean isStopped = true;
    private static TraceComponent tc;

    private RMIConnectorService() throws RemoteException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Creating RMIConnectorService");
        }
        this.adminService = new AdminServiceDelegator();
    }

    public static RMIConnectorService getInstance() throws RemoteException {
        if (instance == null) {
            instance = new RMIConnectorService();
        }
        JMXVersionValidation.setClientVersion(Utils.getProductVersion());
        return instance;
    }

    public Session isAlive() throws ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking isAlive");
        }
        JMXVersionValidation.setClientVersion(Utils.getProductVersion());
        return this.adminService.isAlive();
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) throws ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking queryNames");
        }
        JMXVersionValidation.setClientVersion(Utils.getProductVersion());
        return this.adminService.queryNames(objectName, queryExp);
    }

    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getAttribute");
        }
        JMXVersionValidation.setClientVersion(Utils.getProductVersion());
        return this.adminService.getAttribute(objectName, string);
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException, ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getAttributes");
        }
        JMXVersionValidation.setClientVersion(Utils.getProductVersion());
        return this.adminService.getAttributes(objectName, stringArray);
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking setAttribute");
        }
        JMXVersionValidation.setClientVersion(Utils.getProductVersion());
        this.adminService.setAttribute(objectName, attribute);
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException, ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking setAttributes");
        }
        JMXVersionValidation.setClientVersion(Utils.getProductVersion());
        return this.adminService.setAttributes(objectName, attributeList);
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException, ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking invoke");
        }
        JMXVersionValidation.setClientVersion(Utils.getProductVersion());
        return this.adminService.invoke(objectName, string, objectArray, stringArray);
    }

    public String getDefaultDomain() throws ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getDefaultDomain");
        }
        JMXVersionValidation.setClientVersion(Utils.getProductVersion());
        return this.adminService.getDefaultDomain();
    }

    public String getDomainName() throws ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getDomainName");
        }
        JMXVersionValidation.setClientVersion(Utils.getProductVersion());
        return this.adminService.getDomainName();
    }

    public Integer getMBeanCount() throws ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getMBeanCount");
        }
        JMXVersionValidation.setClientVersion(Utils.getProductVersion());
        return this.adminService.getMBeanCount();
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException, ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getMBeanInfo");
        }
        JMXVersionValidation.setClientVersion(Utils.getProductVersion());
        return this.adminService.getMBeanInfo(objectName);
    }

    public ObjectName getServerMBean() throws ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getServerMBean");
        }
        JMXVersionValidation.setClientVersion(Utils.getProductVersion());
        return this.adminService.getServerMBean();
    }

    public boolean isRegistered(ObjectName objectName) throws ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking isRegistered");
        }
        JMXVersionValidation.setClientVersion(Utils.getProductVersion());
        return this.adminService.isRegistered(objectName);
    }

    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException, ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking isInstanceOf");
        }
        JMXVersionValidation.setClientVersion(Utils.getProductVersion());
        return this.adminService.isInstanceOf(objectName, string);
    }

    public ListenerIdentifier addRMINotificationListener(ConsolidatedFilter consolidatedFilter, RMINotificationListener rMINotificationListener) throws ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRMINotificationListener");
        }
        RMINotificationListenerAdapter rMINotificationListenerAdapter = new RMINotificationListenerAdapter(rMINotificationListener);
        ListenerIdentifier listenerIdentifier = this.adminService.addNotificationListener(consolidatedFilter, rMINotificationListenerAdapter);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRMINotificationListener", listenerIdentifier);
        }
        return listenerIdentifier;
    }

    public void removeNotificationListener(ListenerIdentifier listenerIdentifier) throws ConnectorException, ReceiverNotFoundException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking removeNotificationListener");
        }
        this.adminService.removeNotificationListener(listenerIdentifier);
    }

    public void resetFilter(ListenerIdentifier listenerIdentifier, ConsolidatedFilter consolidatedFilter) throws ConnectorException, ReceiverNotFoundException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking resetFilter");
        }
        this.adminService.resetFilter(listenerIdentifier, consolidatedFilter);
    }

    public Notification[] pullNotifications(ListenerIdentifier listenerIdentifier, Integer n) throws ConnectorException, ReceiverNotFoundException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking pullNotifications");
        }
        return this.adminService.pullNotifications(listenerIdentifier, n);
    }

    void stop() {
        this.isStopped = true;
    }

    void start() {
        this.isStopped = false;
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws ConnectorException, InstanceNotFoundException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getObjectInstance");
        }
        JMXVersionValidation.setClientVersion(Utils.getProductVersion());
        return this.adminService.getObjectInstance(objectName);
    }

    public ClassLoader getClassLoaderFor(ObjectName objectName) throws ConnectorException, InstanceNotFoundException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getClassLoaderFor");
        }
        JMXVersionValidation.setClientVersion(Utils.getProductVersion());
        return this.adminService.getClassLoaderFor(objectName);
    }

    public ClassLoader getClassLoader(ObjectName objectName) throws ConnectorException, InstanceNotFoundException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking getClassLoader");
        }
        JMXVersionValidation.setClientVersion(Utils.getProductVersion());
        return this.adminService.getClassLoader(objectName);
    }

    public Set queryMBeans(ObjectName objectName, QueryExp queryExp) throws ConnectorException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Invoking queryMBeans");
        }
        JMXVersionValidation.setClientVersion(Utils.getProductVersion());
        return this.adminService.queryMBeans(objectName, queryExp);
    }

    public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws ConnectorException, InstanceNotFoundException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addNotificationListener", new Object[]{objectName, objectName2, notificationFilter, object});
        }
        this.adminService.addNotificationListener(objectName, objectName2, notificationFilter, object);
    }

    public void removeNotificationListener_2(ObjectName objectName, ObjectName objectName2) throws ConnectorException, InstanceNotFoundException, ListenerNotFoundException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeNotificationListener_2", new Object[]{objectName, objectName2});
        }
        this.adminService.removeNotificationListener(objectName, objectName2);
    }

    public void removeNotificationListener_4(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws ConnectorException, InstanceNotFoundException, ListenerNotFoundException {
        if (this.isStopped) {
            throw new ConnectorNotAvailableException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "removeNotificationListener_4", new Object[]{objectName, objectName2, notificationFilter, object});
        }
        this.adminService.removeNotificationListener(objectName, objectName2, notificationFilter, object);
    }

    static {
        tc = Tr.register(RMIConnectorService.class, "Admin", "com.ibm.ws.management.resources.connector");
    }
}

