/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.soap;

import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.websphere.security.auth.WSSecurityContextResult;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.HttpException;
import com.ibm.ws.management.component.JMXConnectors;
import com.ibm.ws.management.connector.AdminServiceDelegator;
import com.ibm.ws.management.connector.interop.JMXVersionValidation;
import com.ibm.ws.management.connector.soap.AdminServiceSMR;
import com.ibm.ws.management.connector.soap.SOAPConnection;
import com.ibm.ws.management.connector.soap.SOAPRequest;
import com.ibm.ws.management.connector.soap.SOAPResponse;
import com.ibm.ws.management.connector.soap.SOAPUtils;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Vector;
import javax.security.auth.Subject;
import org.apache.soap.Constants;
import org.apache.soap.Fault;
import org.apache.soap.Header;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.encoding.soapenc.Base64;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.RPCConstants;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.Bean;
import org.apache.soap.util.MethodUtils;
import org.apache.soap.util.xml.QName;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SOAPConnector {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register(SOAPConnector.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.connector");
    private static AdminServiceDelegator targetObject = new AdminServiceDelegator();
    private static SOAPMappingRegistry smr = AdminServiceSMR.getInstance();
    private boolean securityEnabled = SecurityHelper.getHelper().isSecurityEnabled();

    public void service(SOAPConnection sOAPConnection) throws HttpException, IOException {
        String string;
        String string2;
        String string3;
        Object object;
        String string4;
        Throwable throwable;
        boolean bl;
        Response response;
        Call call;
        int n;
        SOAPContext sOAPContext;
        SOAPResponse sOAPResponse;
        SOAPRequest sOAPRequest;
        block38: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "service");
            }
            sOAPRequest = sOAPConnection.getSOAPRequest();
            sOAPResponse = sOAPConnection.getSOAPResponse();
            SOAPContext sOAPContext2 = new SOAPContext();
            sOAPContext = new SOAPContext();
            n = SOAPResponse.SC_OK;
            call = null;
            response = null;
            Header header2 = null;
            bl = false;
            throwable = null;
            Subject subject = null;
            string4 = "1.0.0";
            try {
                call = SOAPUtils.extractSoapCall(sOAPRequest.getInputStream(), sOAPRequest.getContentLength(), sOAPRequest.getContentType(), sOAPContext2, smr);
                header2 = call.getHeader();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Header: " + header2);
                }
                if (header2 != null) {
                    JMXVersionValidation.setClientVersion(header2.getAttribute(new QName("admin", "WASRemoteRuntimeVersion")));
                } else {
                    JMXVersionValidation.setClientVersion("5");
                }
                if (this.securityEnabled) {
                    object = SecurityHelper.getHelper();
                    if (((SecurityHelper)object).isSecurityServiceStarted() && ((SecurityHelper)object).isSecurityServiceStopped()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "service", "SOAPConnector service is not given, because Security Server was running and then stopped.");
                        }
                        return;
                    }
                    string3 = null;
                    if (header2 != null) {
                        string3 = header2.getAttribute(SOAPUtils.securityEnabled);
                    }
                    if (string3 != null) {
                        string2 = null;
                        string = null;
                        String string5 = null;
                        String string6 = null;
                        String string7 = null;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Security Enabled: " + new Boolean(string3));
                        }
                        Vector vector = header2.getHeaderEntries();
                        Enumeration enumeration = vector.elements();
                        while (enumeration.hasMoreElements()) {
                            Element element = (Element)enumeration.nextElement();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "nodeName", element.getNodeName());
                            }
                            NodeList nodeList = element.getChildNodes();
                            int n2 = nodeList.getLength();
                            string7 = null;
                            for (int i = 0; i < n2; ++i) {
                                if (element.getNodeName().equals("password")) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "node value", "*******");
                                    }
                                } else if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "node value", nodeList.item(i).getNodeValue());
                                }
                                string7 = nodeList.item(i).getNodeValue();
                            }
                            if (element.getNodeName().equals("username")) {
                                string2 = string7;
                                continue;
                            }
                            if (element.getNodeName().equals("password")) {
                                string = string7;
                                continue;
                            }
                            if (element.getNodeName().equals("LoginMethod")) {
                                string5 = string7;
                                continue;
                            }
                            if (!element.getNodeName().equals("token")) continue;
                            string6 = string7;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "username: " + string2);
                        }
                        if (string5.equals("BasicAuth")) {
                            if (string2 != null && string != null && string2.length() > 0 && string.length() > 0) {
                                subject = this.basicAuth(string2, string);
                            }
                        } else if (string5.equals("TokenBased") && string6 != null && string6.length() > 0) {
                            subject = this.tokenBasedAuth(string6);
                        }
                    }
                }
                this.checkURI(call);
                string4 = JMXVersionValidation.getRemoteVersion(call);
                sOAPContext.setProperty("JMXRemoteVersion", string4);
                if (this.securityEnabled) {
                    SecurityHelper.resetContext();
                    if (subject != null) {
                        SecurityHelper.setReceivedSubject(subject);
                        SecurityHelper.pushInvocationSubject(subject);
                    }
                    response = this.invoke(call, sOAPContext);
                } else {
                    response = this.invoke(call, sOAPContext);
                }
                response.setHeader(JMXVersionValidation.getJmxVersionHeader(response.getHeader(), string4));
            }
            catch (Throwable throwable2) {
                FFDCFilter.processException(throwable2, "com.ibm.ws.management.connector.soap.SOAPConnector.service", "212", this);
                bl = true;
                throwable = throwable2;
                if (!tc.isDebugEnabled()) break block38;
                Tr.debug(tc, "Caught exception", throwable2);
            }
        }
        if (bl) {
            object = new Fault(new SOAPException(Constants.FAULT_CODE_SERVER, throwable.getMessage()));
            try {
                ((Fault)object).setFaultString(SOAPUtils.convertObjectToString(throwable, string4));
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.connector.soap.SOAPConnector.service", "228", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "error occurs when serializing the exception", exception);
                }
                throw new HttpException(SOAPResponse.SC_INTERNAL_SERVER_ERROR);
            }
            string3 = sOAPRequest.getURI();
            string2 = null;
            string2 = string3 != null && (string3.indexOf("<SCRIPT>") != -1 || string3.indexOf("<script>") != -1) ? "some_script" : SOAPUtils.encodeDataString(sOAPRequest.getURI());
            ((Fault)object).setFaultActorURI(string2);
            n = SOAPResponse.SC_INTERNAL_SERVER_ERROR;
            string = null;
            if (call != null) {
                string = call.getEncodingStyleURI();
            }
            if (string == null) {
                string = "http://schemas.xmlsoap.org/soap/encoding/";
            }
            sOAPContext = new SOAPContext();
            response = new Response(null, null, (Fault)object, null, null, string, sOAPContext);
            response.setHeader(JMXVersionValidation.getJmxVersionHeader(response.getHeader(), string4));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "the response object = " + response);
        }
        sOAPResponse.writeSOAPResponse(response, sOAPContext, smr, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "service");
        }
    }

    private void checkURI(Call call) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkURI", call);
        }
        String string = call.getTargetObjectURI();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Soap Call URI: " + string);
        }
        if (string == null || !string.equalsIgnoreCase("urn:AdminService")) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkURI", call);
            }
            throw new AdminException(nls.getString("ADMC0005E", "SOAP URI Violation"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkURI", call);
        }
    }

    private Response invoke(Call call, SOAPContext sOAPContext) throws AdminException, Throwable {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke", call);
        }
        String string = call.getEncodingStyleURI();
        Vector vector = call.getParams();
        Object[] objectArray = null;
        Class[] classArray = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Method Name: " + call.getMethodName());
        }
        if (vector != null) {
            int n = vector.size();
            objectArray = new Object[n];
            classArray = new Class[n];
            for (int i = 0; i < n; ++i) {
                object2 = (Parameter)vector.elementAt(i);
                objectArray[i] = ((Parameter)object2).getValue();
                classArray[i] = ((Parameter)object2).getType();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Parameter: " + objectArray[i] + "(type: " + classArray[i] + ")");
                }
                if (string != null) continue;
                string = ((Parameter)object2).getEncodingStyleURI();
            }
        }
        if (string == null) {
            string = "http://schemas.xmlsoap.org/soap/encoding/";
        }
        Bean bean = null;
        try {
            object = null;
            targetObject = new AdminServiceDelegator();
            object = MethodUtils.getMethod(targetObject, call.getMethodName(), classArray);
            bean = new Bean(((Method)object).getReturnType(), ((Method)object).invoke((Object)targetObject, objectArray));
        }
        catch (InvocationTargetException invocationTargetException) {
            FFDCFilter.processException((Throwable)invocationTargetException, "com.ibm.ws.management.connector.soap.SOAPConnector.invoke", "351", this);
            object2 = invocationTargetException.getTargetException();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invoke");
            }
            throw object2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            FFDCFilter.processException((Throwable)noSuchMethodException, "com.ibm.ws.management.connector.soap.SOAPConnector.invoke", "358", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invoke");
            }
            throw new AdminException(noSuchMethodException, nls.getString("ADMC0007E"));
        }
        catch (IllegalAccessException illegalAccessException) {
            FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.ws.management.connector.soap.SOAPConnector.invoke", "365", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "invoke");
            }
            throw new AdminException(illegalAccessException, nls.getString("ADMC0007E"));
        }
        object = null;
        if (bean.type != Void.TYPE) {
            if (bean.value != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "return object type = " + bean.value.getClass() + "; value = " + bean.value);
                }
                object = new Parameter(RPCConstants.ELEM_RETURN, bean.value.getClass(), bean.value, null);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "return object type = " + bean.type + "; value = " + bean.value);
                }
                object = new Parameter(RPCConstants.ELEM_RETURN, bean.type, bean.value, null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke");
        }
        return new Response(call.getTargetObjectURI(), call.getMethodName(), (Parameter)object, null, null, string, sOAPContext);
    }

    private Subject basicAuth(String string, String string2) {
        Subject subject;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "basicAuth");
            }
            subject = null;
            try {
                if (string.startsWith(ContextManagerFactory.getInstance().getDefaultRealm())) {
                    string = RealmSecurityName.getSecurityName(string);
                }
                subject = SecurityHelper.authenticate(string, string2);
            }
            catch (Exception exception) {
                if (JMXConnectors.loginQuickFail) {
                    throw new RuntimeException(exception);
                }
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.connector.soap.SOAPConnector.invoke", "406", this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "unable to authenticate incoming request", exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "basicAuth");
        }
        return subject;
    }

    private Subject tokenBasedAuth(String string) {
        Subject subject;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "tokenBasedAuth");
            }
            byte[] byArray = Base64.decode(string);
            WSSecurityContext wSSecurityContext = SecurityHelper.getHelper().getWSSecurityContext();
            subject = null;
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attemping to extract subject from a V6+ token.");
                }
                WSSecurityContextResult wSSecurityContextResult = wSSecurityContext.acceptSecContext(byArray);
                subject = wSSecurityContextResult.getSubject();
            }
            catch (Exception exception) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failed to extract subject from V6+ token, attempting to extract using the pre-V6 format.");
                    }
                    subject = SecurityHelper.validate(byArray);
                }
                catch (Exception exception2) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Failed to extract subject using the pre-V6 format.");
                    }
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.connector.soap.SOAPConnector.tokenBasedAuth", "415", this);
                    if (!tc.isDebugEnabled()) break block9;
                    Tr.debug(tc, "unable to authenticate incoming request", exception);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "tokenBasedAuth");
        }
        return subject;
    }
}

