/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.connector.soap;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.models.config.applicationserver.webcontainer.HTTPTransport;
import com.ibm.websphere.models.config.applicationserver.webcontainer.impl.WebcontainerFactoryImpl;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLConfigChangeEvent;
import com.ibm.websphere.ssl.SSLConfigChangeListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.HttpConnection;
import com.ibm.ws.http.HttpServer;
import com.ibm.ws.http.HttpTransport;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.connector.soap.SOAPConnection;
import com.ibm.ws.ssl.config.ManagementScopeManager;
import com.ibm.ws.util.ThreadPool;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SOAPServer
extends HttpServer
implements SSLConfigChangeListener {
    private static final String bundleName = "com.ibm.ws.management.resources.connector";
    private static TraceComponent tc = Tr.register(SOAPServer.class, "Admin", "com.ibm.ws.management.resources.connector");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.connector");
    private HttpTransport transport = null;
    private HTTPTransport http = null;
    private String soapSslAlias = null;
    Map connectionInfo = new HashMap();
    private String port;
    private String host;
    private static SOAPServer _instance = null;

    private SOAPServer(ThreadPool threadPool) {
        super(threadPool);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SoapServer");
        }
    }

    public static SOAPServer getInstance(ThreadPool threadPool) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance");
        }
        if (_instance == null) {
            _instance = new SOAPServer(threadPool);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance");
        }
        return _instance;
    }

    public void stateChanged(SSLConfigChangeEvent sSLConfigChangeEvent) {
        block3: {
            try {
                if (ManagementScopeManager.getInstance().getServerType().equals("DEPLOYMENT_MANAGER")) {
                    Thread.sleep(10000L);
                }
                Properties properties = JSSEHelper.getInstance().getProperties(this.soapSslAlias, this.connectionInfo, this);
                this.transport.reinitialize(properties);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.connector.soap.SoapServer.reinitialize", "84", this);
                Tr.error(tc, exception.toString());
                if (!tc.isEntryEnabled()) break block3;
                Tr.exit(tc, "reinitialize - failed");
            }
        }
    }

    public void initialize(Properties properties, boolean bl, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{string, properties});
        }
        if (this.transport == null) {
            this.transport = new HttpTransport();
        }
        String string2 = properties.getProperty("com.ibm.websphere.network.useMultiHomeHostName");
        Boolean bl2 = null;
        bl2 = string2 == null ? AdminHelper.getInstance().useMultiHome() : Boolean.valueOf(string2);
        if (bl2 != null) {
            if (bl2.booleanValue()) {
                this.transport.setHost(null);
            } else {
                this.host = properties.getProperty("host");
                if (this.host == null) {
                    try {
                        this.host = AdminHelper.getInstance().getHostName();
                    }
                    catch (UnknownHostException unknownHostException) {
                        Tr.error(tc, unknownHostException.toString());
                        throw unknownHostException;
                    }
                }
                this.transport.setHost(this.host);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "useMultiHomeHost == false: Host name = " + this.host);
                }
            }
        }
        this.port = properties.getProperty("port");
        if (this.port == null || this.port.trim().length() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize - no port");
            }
            throw new IllegalArgumentException(nls.getString("ADMC0006E", "no port number specified for SOAP connector"));
        }
        this.transport.setPort(this.port);
        try {
            if (bl) {
                this.http = new WebcontainerFactoryImpl().createHTTPTransport();
                this.http.setSslEnabled(true);
                this.soapSslAlias = string;
                this.connectionInfo.put("com.ibm.ssl.direction", "inbound");
                this.connectionInfo.put("com.ibm.ssl.endPointName", "SOAP_CONNECTOR_ADDRESS");
                Properties properties2 = JSSEHelper.getInstance().getProperties(this.soapSslAlias, this.connectionInfo, this);
                this.transport.initialize(_instance, (Transport)this.http, properties2);
            } else {
                this.transport.initialize(_instance, null);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SOAP connector transport initialized at port: " + this.port);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.connector.soap.SoapServer.initialize", "71", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize - failed");
            }
            throw exception;
        }
        this.addTransport(this.transport);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public String getConfiguredPort() {
        return this.port;
    }

    protected HttpConnection createHttpConnection() {
        SOAPConnection sOAPConnection = new SOAPConnection();
        return sOAPConnection;
    }
}

