/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.deployment.j2ee;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.deployment.core.DeployableObject;
import com.ibm.websphere.management.deployment.core.DeploymentContext;
import com.ibm.websphere.management.deployment.core.DeploymentStep;
import com.ibm.websphere.management.deployment.exception.DeploymentException;
import com.ibm.websphere.management.deployment.registry.ExtensionProvider;
import com.ibm.ws.management.deployment.j2ee.J2EEToCDFStepWrapper;
import com.ibm.ws.management.deployment.util.DeploymentExtensionHelper;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;

public class J2EEToCDFBridge {
    private static TraceComponent tc = Tr.register(J2EEToCDFBridge.class, "Admin", "com.ibm.ws.management.resources.DeploymentMessages");
    private static final String EAR_DO_PATH = "com.ibm.ws.management.deployment.j2ee.EARDeployableObject";
    private static final String ARCHIVE_DO_PATH = "com.ibm.ws.management.deployment.j2ee.ArchiveDeployableObject";

    public static void addCDFServerPluginToJ2EE(long l, Vector vector, Scheduler scheduler, Hashtable hashtable) throws DeploymentException {
        DeploymentContext deploymentContext;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addCDFServerPluginToJ2EE", new Object[]{new Long(l), vector, scheduler});
        }
        List list = J2EEToCDFBridge._convertJ2EEStepToCDFStepHelper(vector);
        String string = null;
        String string2 = "EAR";
        if ((l & 1L) != 0L) {
            string = "install";
        } else if ((l & 2L) != 0L) {
            string = "edit";
        } else if ((l & 4L) != 0L) {
            string = "update";
        } else if ((l & 8L) != 0L) {
            string = "uninstall";
        } else if ((l & 0x10L) != 0L) {
            string = "createEarWrapper";
            string2 = "";
        }
        Vector vector2 = new Vector();
        DeploymentExtensionHelper.getProviders(vector2);
        for (n = 0; n < vector2.size(); ++n) {
            ((ExtensionProvider)vector2.elementAt(n)).addSteps(string2, string, new String(), list);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "steps are " + list + " after calling extension provider " + (ExtensionProvider)vector2.elementAt(n));
        }
        if (scheduler != null) {
            deploymentContext = J2EEToCDFBridge._createCDFContext(scheduler, string);
            hashtable.put("appname", scheduler.getAppName());
        } else {
            deploymentContext = new DeploymentContext();
        }
        deploymentContext.getContextData().put(DeploymentContext.PREFS_Hashtable_key, hashtable);
        vector.clear();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Clearing up the existing j2eeStep vector");
        }
        for (n = 0; n < list.size(); ++n) {
            Object e2 = list.get(n);
            if (e2 instanceof J2EEToCDFStepWrapper) {
                vector.add(((J2EEToCDFStepWrapper)e2).getJ2EETask());
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding j2ee step to " + n + "th element: " + vector.elementAt(n));
                continue;
            }
            if (!(e2 instanceof DeploymentStep)) continue;
            ((DeploymentStep)e2).setContext(deploymentContext);
            vector.add(e2);
            System.out.println("adding cdf step " + e2.getClass().getName() + " to " + n + "th element: " + vector.elementAt(n));
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Adding cdf step " + e2.getClass().getName() + " to " + n + "th element: " + vector.elementAt(n));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addCDFServerPluginToJ2EE");
        }
    }

    public static DeployableObject createDO(Object object) throws DeploymentException {
        Class clazz;
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDO", new Object[]{object});
        }
        DeployableObject deployableObject = null;
        if (object instanceof Scheduler) {
            string = EAR_DO_PATH;
            clazz = Scheduler.class;
        } else if (object instanceof Archive) {
            string = ARCHIVE_DO_PATH;
            clazz = Archive.class;
        } else {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.ws.management.resources.DeploymentMessages", Locale.getDefault());
            throw new DeploymentException(resourceBundle.getString("AMDA2000E"), null);
        }
        try {
            Class<?> clazz2 = Class.forName(string);
            Constructor<?> constructor = clazz2.getDeclaredConstructor(clazz);
            deployableObject = (DeployableObject)constructor.newInstance(object);
        }
        catch (Exception exception) {
            throw new DeploymentException(exception.getMessage(), exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDO - " + deployableObject);
        }
        return deployableObject;
    }

    private static List _convertJ2EEStepToCDFStepHelper(Vector vector) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_convertJ2EEStepToCDFStepHelper", new Object[]{vector});
        }
        ArrayList<J2EEToCDFStepWrapper> arrayList = new ArrayList<J2EEToCDFStepWrapper>();
        for (int i = 0; i < vector.size(); ++i) {
            arrayList.add(new J2EEToCDFStepWrapper(vector.get(i).getClass().getName(), vector.get(i)));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_convertJ2EEStepToCDFStepHelper - " + arrayList);
        }
        return arrayList;
    }

    private static DeploymentContext _createCDFContext(Scheduler scheduler, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_createCDFContext", new Object[]{scheduler});
        }
        DeploymentContext deploymentContext = new DeploymentContext();
        deploymentContext.getContextData().put(DeploymentContext.SESSIONID_String_key, scheduler.getWorkSpace().getSessionId());
        deploymentContext.getContextData().put(DeploymentContext.TEMPDIR_String_key, scheduler.getTempDir());
        deploymentContext.getContextData().put(DeploymentContext.OPERATIONNAME_String_key, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_createCDFContext -" + deploymentContext);
        }
        return deploymentContext;
    }
}

