/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.deployment.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.deployment.registry.ExtensionProvider;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.util.Collections;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;

public class DeploymentExtensionHelper {
    private static TraceComponent tc = Tr.register(DeploymentExtensionHelper.class, "Admin", "com.ibm.ws.management.resources.DeploymentMessages");
    public static final String EXT_POINT = "common-deployment-framework-exensionprovider";
    private static Vector _extProviders = null;

    public static void getProviders(Vector vector, Vector vector2) {
        DeploymentExtensionHelper.getProviders(vector);
    }

    public static void getProviders(Vector vector) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getProviders");
        }
        if (_extProviders == null) {
            DeploymentExtensionHelper._getProviders(EXT_POINT);
        }
        vector.addAll(_extProviders);
        try {
            Collections.sort(vector);
        }
        catch (RuntimeException runtimeException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid provider type found.  Not a type of ExtensionProvider.");
            }
            FFDCFilter.processException(runtimeException, "com.ibm.ws.management.deployment.util.DeploymentExtensionHelper.getProviders", "82");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getProviders");
        }
    }

    private static void _getProviders(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getProviders: processing extpoint - " + string);
        }
        _extProviders = new Vector();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Getting extension registry ...");
        }
        IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Got extension registry ...");
        }
        if (iExtensionRegistry == null) {
            Tr.error(tc, "Unable to get eclipse extension registry");
            return;
        }
        String string2 = ExtensionRegistryFactory.instance().getDefaultPluginID() + "." + string;
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string2);
        if (iExtensionPoint == null) {
            Tr.error(tc, "Unable to get eclipse extension point " + string);
            return;
        }
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        for (int i = 0; i < iExtensionArray.length; ++i) {
            IConfigurationElement[] iConfigurationElementArray;
            IExtension iExtension = iExtensionArray[i];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing extension - " + iExtension.getUniqueIdentifier());
            }
            if ((iConfigurationElementArray = iExtension.getConfigurationElements()).length != 1) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Invalid number of taskProviders elements - " + iConfigurationElementArray.length);
                continue;
            }
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[0];
            if (!iConfigurationElement.getName().equals("action")) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Expecting taskProviders action element but got " + iConfigurationElement.getName() + " instead");
                continue;
            }
            try {
                Object object = iConfigurationElement.createExecutableExtension("class");
                if (object instanceof ExtensionProvider) {
                    _extProviders.addElement(object);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "action class is not an instance of ExtensionProvider for : " + iExtension.getUniqueIdentifier());
                continue;
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error getting CDF extension provider in " + iExtension.getUniqueIdentifier() + throwable);
                }
                FFDCFilter.processException(throwable, "com.ibm.ws.management.deployment.util.DeploymentExtensionHelper._getProviders", "161");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getProviders", new Object[]{_extProviders});
        }
    }
}

