/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.deploymentmanager;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.deploymentmanager.DeploymentManagerDiagnosticHelper;
import com.ibm.ws.management.deploymentmanager.MultiSyncEvent;
import com.ibm.ws.management.deploymentmanager.MultiSyncManager;
import com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorManager;
import com.ibm.ws.management.metadata.ManagedObjectMetadataCollectorManagerFactory;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.security.core.SecurityContext;
import com.ibm.wsspi.rasdiag.DiagnosticEvent;
import com.ibm.wsspi.rasdiag.DiagnosticEventFactory;
import com.ibm.wsspi.rasdiag.DiagnosticProvider;
import com.ibm.wsspi.rasdiag.DiagnosticProviderHelper;
import com.ibm.wsspi.rasdiag.DiagnosticTypedValue;
import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.DiagnosticProviderInfo;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.management.Descriptor;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanInfo;

public class DeploymentManager
extends RuntimeCollaborator
implements NotificationListener,
DiagnosticProvider {
    private static TraceComponent tc = Tr.register(DeploymentManager.class, "Admin", "com.ibm.ws.management.resources.adminservice");
    private static final Integer DISCOVERY_LISTENER = new Integer(0);
    private static final Integer NODEAGENT_LISTENER = new Integer(1);
    private static final String DIAGNOSTIC_BUNDLE = "com.ibm.ws.management.resources.DiagnosticProviderText";
    private static long ntfySeqNum = 0L;
    private MBeanFactory mbeanFactory;
    private String cellName;
    private String repositoryRootURI;
    private DiagnosticProviderInfo dpInfo = null;
    public static final String sDPName = "DeploymentManagerDP";
    private Set stoppingNodeAgents = Collections.synchronizedSet(new HashSet());
    private Set currentNodeAgents = Collections.synchronizedSet(new HashSet());
    private MultiSyncManager multiSync;

    public DeploymentManager(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructor", new Object[]{string, string2});
        }
        this.cellName = string2;
        this.repositoryRootURI = string;
        this.mbeanFactory = AdminServiceFactory.getMBeanFactory();
        try {
            Properties properties = new Properties();
            properties.setProperty("diagnosticProvider", "true");
            this.mbeanFactory.activateMBean("DeploymentManager", this, "DeploymentManager", null, properties);
        }
        catch (AdminException adminException) {
            FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.deploymentmanager.DeploymentManager.DeploymentManager", "77", this);
        }
        this.registerToDiscoveryMBean();
        this.listenForJ2EEStateStoppingNotifications();
        DiagnosticProviderHelper.registerMBeanWithDiagnosticService(sDPName, this.getObjectName());
        this.multiSync = new MultiSyncManager(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructor");
        }
    }

    public void bindMBean(ModelMBeanInfo modelMBeanInfo, ModelMBean modelMBean) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindMBean");
        }
        super.bindMBean(modelMBeanInfo, modelMBean);
        if (modelMBeanInfo != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "info:", modelMBeanInfo);
            }
            Descriptor descriptor = modelMBeanInfo.getMBeanDescriptor();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "mBeanDescriptor", descriptor);
            }
            String string = "DeploymentManager";
            descriptor.setField("displayName", string);
            String string2 = (String)descriptor.getFieldValue("type");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "type:" + string2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bindMBean");
        }
    }

    public Set restartActiveNodes(Boolean bl, Boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restartActiveNodes");
        }
        HashSet<String> hashSet = new HashSet<String>();
        AdminService adminService = AdminServiceFactory.getAdminService();
        ObjectName objectName = null;
        try {
            objectName = new ObjectName("WebSphere:*,type=NodeAgent");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            FFDCFilter.processException((Throwable)malformedObjectNameException, "com.ibm.ws.management.cellmanager.DeploymentManager.restartActiveNodes", "153", this);
        }
        Set set = adminService.queryNames(objectName, null);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            objectName = (ObjectName)iterator.next();
            String string = ObjectNameHelper.getNodeName(objectName);
            Tr.audit(tc, "ADMN0026I", new Object[]{string, bl});
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeagent object name", objectName);
            }
            Object[] objectArray = new Object[]{bl, bl2};
            String[] stringArray = new String[]{bl.getClass().getName(), bl2.getClass().getName()};
            boolean bl3 = true;
            try {
                adminService.invoke(objectName, "restart", objectArray, stringArray);
            }
            catch (Exception exception) {
                Exception exception2;
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.deploymentmanager.DeploymentManager.restartActiveNodes", "143", this);
                if (exception instanceof MBeanException) {
                    exception2 = ((MBeanException)exception).getTargetException();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "failed to invoke ripple on node", new Object[]{string, bl});
                }
                Tr.warning(tc, "ADMN0030W", new Object[]{string, exception2.getMessage()});
                bl3 = false;
            }
            if (!bl3) continue;
            hashSet.add(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restartActiveNodes");
        }
        return hashSet;
    }

    public void multiSync(Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "multiSync");
        }
        this.multiSync.begin(bl);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "multiSync");
        }
    }

    protected void sendMultiSyncNotification(MultiSyncEvent multiSyncEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendMultiSyncNotification", new Object[]{multiSyncEvent});
        }
        Tr.audit(tc, multiSyncEvent.toString());
        Notification notification = new Notification("websphere.multisync.event", this.getObjectName(), ntfySeqNum++);
        notification.setUserData(multiSyncEvent);
        try {
            this.sendNotification(notification);
        }
        catch (MBeanException mBeanException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception sening Notification", mBeanException);
            }
            FFDCFilter.processException((Throwable)mBeanException, "com.ibm.ws.management.deploymentmanager.DeploymentManager.handleNotification", "411", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendMultiSyncNotification");
        }
    }

    public Set syncActiveNodes(Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "syncActiveNodes");
        }
        HashSet<String> hashSet = new HashSet<String>();
        AdminService adminService = AdminServiceFactory.getAdminService();
        ObjectName objectName = null;
        try {
            objectName = new ObjectName("WebSphere:*,type=NodeSync,process=nodeagent");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            FFDCFilter.processException((Throwable)malformedObjectNameException, "com.ibm.ws.management.cellmanager.DeploymentManager.syncActiveNodes", "153", this);
        }
        Set set = adminService.queryNames(objectName, null);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            objectName = (ObjectName)iterator.next();
            String string = ObjectNameHelper.getNodeName(objectName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "nodeagent object name", objectName);
            }
            boolean bl2 = true;
            try {
                if (bl.booleanValue()) {
                    adminService.invoke(objectName, "sync", null, null);
                } else {
                    adminService.invoke(objectName, "requestSync", null, null);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.deploymentmanager.DeploymentManager.syncActiveNodes", "143", this);
                if (exception instanceof MBeanException) {
                    Exception exception2 = ((MBeanException)exception).getTargetException();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "failed to do file sync on node", new Object[]{string, bl});
                }
                bl2 = false;
            }
            if (!bl2) continue;
            hashSet.add(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "syncActiveNodes");
        }
        return hashSet;
    }

    public void stopNodeAgent(String string) throws Exception {
        AdminClient adminClient;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopNodeAgent");
        }
        if ((adminClient = RoutingTable.getInstance().getAdminClient(string)) == null) {
            throw new AdminException("no entry found in the routing table for node:" + string);
        }
        ObjectName objectName = adminClient.getServerMBean();
        adminClient.invoke(objectName, "stop", null, null);
        RoutingTable.getInstance().removeChild(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopNodeAgent");
        }
    }

    public void stopNode(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopNode");
        }
        ObjectName objectName = null;
        AdminClient adminClient = RoutingTable.getInstance().getAdminClient(string);
        if (adminClient == null) {
            throw new AdminException("no entry found in the routing table for node:" + string);
        }
        try {
            objectName = new ObjectName("WebSphere:*,type=NodeAgent");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            FFDCFilter.processException((Throwable)malformedObjectNameException, "com.ibm.ws.management.cellmanager.DeploymentManager.stopNode", "305", this);
        }
        Set set = adminClient.queryNames(objectName, null);
        ObjectName objectName2 = objectName = set.iterator().hasNext() ? (ObjectName)set.iterator().next() : null;
        if (objectName == null) {
            throw new AdminException("no NodeAgent mbean found at node: " + string);
        }
        adminClient.invoke(objectName, "stopNode", null, null);
        RoutingTable.getInstance().removeChild(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopNode");
        }
    }

    private void registerToDiscoveryMBean() {
        block2: {
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                String string = "WebSphere:type=Discovery,node=" + adminService.getNodeName() + ",process=" + adminService.getProcessName() + ",*";
                ObjectName objectName = new ObjectName(string);
                Set set = adminService.queryNames(objectName, null);
                Iterator iterator = set.iterator();
                objectName = (ObjectName)iterator.next();
                adminService.addNotificationListener(objectName, this, null, (Object)DISCOVERY_LISTENER);
            }
            catch (JMException jMException) {
                FFDCFilter.processException((Throwable)jMException, "com.ibm.ws.management.deploymentmanager.DeploymentManager.registerToDiscoveryMBean", "358", this);
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "can not register as a listener to DiscoveryMBean", jMException);
            }
        }
    }

    private void listenForJ2EEStateStoppingNotifications() {
        try {
            AdminService adminService = AdminServiceFactory.getAdminService();
            ObjectName objectName = new ObjectName("WebSphere:*,type=Server,processType=NodeAgent");
            NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
            notificationFilterSupport.enableType("j2ee.state.stopping");
            adminService.addNotificationListenerExtended(objectName, this, notificationFilterSupport, NODEAGENT_LISTENER);
        }
        catch (JMException jMException) {
            FFDCFilter.processException((Throwable)jMException, "com.ibm.ws.management.deploymentmanager.DeploymentManager.listenForJ2EEStateStoppingNotifications", "373", this);
        }
    }

    public void handleNotification(Notification notification, Object object) {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification");
        }
        Notification notification2 = null;
        String string = notification.getType();
        Thread thread = null;
        if (object.equals(DISCOVERY_LISTENER)) {
            if (string.equals("websphere.discovery.process.found")) {
                notification2 = new Notification("websphere.process.running", this.getObjectName(), ntfySeqNum++);
                notification2.setUserData(notification.getUserData());
                this.checkRemoteClock((Properties)notification.getUserData());
                try {
                    serializable = (Properties)notification.getUserData();
                    String string2 = ((Properties)serializable).getProperty("nodeName");
                    ManagedObjectMetadataHelper managedObjectMetadataHelper = new ManagedObjectMetadataHelper(ManagedObjectMetadataAccessorFactory.createAccessor(null));
                    if (managedObjectMetadataHelper.compareNodeVersion(string2, "5") == 0) {
                        Properties properties = new Properties();
                        properties.put("local.node", string2);
                        AdminClient adminClient = RoutingTable.getInstance().getAdminClient(string2);
                        ObjectName objectName = adminClient.getServerMBean();
                        thread = new Version5NodeMetadataCollector(properties, adminClient, objectName);
                    }
                    this.currentNodeAgents.add(string2);
                }
                catch (Throwable throwable) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Could not create collector thread:", throwable);
                    }
                }
            } else if (string.equals("websphere.discovery.process.lost")) {
                serializable = (Properties)notification.getUserData();
                NodeAgentInfo nodeAgentInfo = new NodeAgentInfo(((Properties)serializable).getProperty("nodeName"), ((Properties)serializable).getProperty("processName"));
                String string3 = "websphere.process.failed";
                if (this.stoppingNodeAgents.remove(nodeAgentInfo)) {
                    string3 = "websphere.process.stopped";
                }
                notification2 = new Notification(string3, this.getObjectName(), ntfySeqNum++);
                notification2.setUserData(serializable);
                this.currentNodeAgents.remove(nodeAgentInfo.getNodeName());
            }
        } else if (object.equals(NODEAGENT_LISTENER) && string.equals("j2ee.state.stopping")) {
            notification2 = new Notification("websphere.process.stopping", this.getObjectName(), ntfySeqNum++);
            serializable = (ObjectName)notification.getSource();
            NodeAgentInfo nodeAgentInfo = new NodeAgentInfo(((ObjectName)serializable).getKeyProperty("node"), ((ObjectName)serializable).getKeyProperty("name"));
            this.stoppingNodeAgents.add(nodeAgentInfo);
            Properties properties = new Properties();
            properties.setProperty("processName", nodeAgentInfo.getServerName());
            properties.setProperty("nodeName", nodeAgentInfo.getNodeName());
            notification2.setUserData(properties);
        }
        if (notification2 != null) {
            try {
                this.sendNotification(notification2);
            }
            catch (MBeanException mBeanException) {
                FFDCFilter.processException((Throwable)mBeanException, "com.ibm.ws.management.deploymentmanager.DeploymentManager.handleNotification", "411", this);
            }
            if (thread != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Starting v5 metadata collector thread.");
                }
                thread.start();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    private void checkRemoteClock(Properties properties) {
        try {
            String string = properties.getProperty("nodeName");
            String string2 = properties.getProperty("processName");
            ObjectName objectName = null;
            AdminService adminService = AdminServiceFactory.getAdminService();
            Set set = adminService.queryNames(new ObjectName("WebSphere:*,type=JVM,node=" + string + ",process=" + string2), null);
            if (!set.isEmpty()) {
                objectName = (ObjectName)set.iterator().next();
                if (!objectName.getKeyProperty("version").equals("5.0") && !Utils.isClockInSync(null, objectName)) {
                    Tr.warning(tc, "ADMN0035W", string);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "JVM MBean not found for nodeagent on " + string);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.deploymentmanager.DeploymentManager.checkRemoteClock", "465", this);
        }
    }

    public String getDiagnosticProviderName() {
        return sDPName;
    }

    public String getDiagnosticProviderId() {
        return this.getObjectName().toString();
    }

    public DiagnosticProviderInfo getRegisteredDiagnostics() {
        if (this.dpInfo == null) {
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("com/ibm/ws/management/deploymentmanager/DeploymentManagerDiagnosticProvider.xml");
            this.dpInfo = DiagnosticProviderHelper.loadRegistry(inputStream, null);
        }
        return this.dpInfo;
    }

    public DiagnosticEvent[] configDump(String string, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configDump", new Object[]{string, new Boolean(bl)});
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        DiagnosticTypedValue diagnosticTypedValue = new DiagnosticTypedValue(System.getProperty("os.name"), "os.name.key");
        hashMap.put(DeploymentManagerDiagnosticHelper.DEPLOYMENT_MANAGER_PLATFORM, diagnosticTypedValue);
        hashMap = new HashMap(2);
        try {
            DiagnosticTypedValue.addCollectionToHashMap(hashMap, DeploymentManagerDiagnosticHelper.DEPLOYMENT_MANAGER_CHILDREN, this.getNodes(), "DeploymentManager.nodes.key");
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "exception getting nodes", exception);
            }
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.nodeagent.configDump", "2019", this);
            hashMap.put(DeploymentManagerDiagnosticHelper.DEPLOYMENT_MANAGER_CHILDREN, exception.getMessage());
        }
        DiagnosticEvent diagnosticEvent = DiagnosticEventFactory.createConfigDump(this.getObjectName().toString(), DeploymentManager.class.getName(), "configDump", hashMap);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "configDump", diagnosticEvent);
        }
        return new DiagnosticEvent[]{diagnosticEvent};
    }

    public DiagnosticEvent[] stateDump(String string, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "configDump", new Object[]{string, new Boolean(bl)});
        }
        HashMap hashMap = new HashMap(2);
        DiagnosticTypedValue.addCollectionToHashMap(hashMap, DeploymentManagerDiagnosticHelper.DEPLOYMENT_MANAGER_DISCOVERED_NODEAGENTS, this.currentNodeAgents, "DeploymentManager.discovered.nodes.key");
        DiagnosticEvent diagnosticEvent = DiagnosticEventFactory.createStateDump(this.getObjectName().toString(), DeploymentManager.class.getName(), "stateDump", hashMap);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stateDump", diagnosticEvent);
        }
        return new DiagnosticEvent[]{diagnosticEvent};
    }

    public DiagnosticEvent[] selfDiagnostic(String string, boolean bl) {
        HashSet<Object> hashSet;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "selfDiagnostic", new Object[]{string});
        }
        HashMap<String, Object> hashMap = null;
        if (string != null && string.startsWith(DeploymentManagerDiagnosticHelper.DEPLOYMENT_MANAGER_PING_NODEAGENTS)) {
            Object object;
            hashMap = new HashMap<String, Object>();
            hashSet = null;
            int n = string.lastIndexOf(46);
            if (n > -1) {
                object = string.substring(n + 1);
                if ("*".equals(object)) {
                    hashSet = new HashSet(this.currentNodeAgents);
                } else {
                    hashSet = new HashSet<Object>(1);
                    hashSet.add(object);
                }
            }
            object = hashSet.iterator();
            String string2 = null;
            String string3 = "j2ee.state.stopped";
            while (object.hasNext()) {
                Object object2;
                string2 = (String)object.next();
                string3 = "j2ee.state.stopped";
                try {
                    object2 = RoutingTable.getInstance().getAdminClient(string2);
                    if (object2 != null && object2.isAlive() != null) {
                        string3 = "j2ee.state.running";
                    }
                }
                catch (ConnectorException connectorException) {
                    Tr.debug(tc, "ConnectorException checking AdminClient.isAlive", connectorException);
                }
                object2 = new DiagnosticTypedValue(string3, "DeploymentManager.node.state");
                hashMap.put(DeploymentManagerDiagnosticHelper.DEPLOYMENT_MANAGER_PING_NODEAGENTS + "." + string2, object2);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "invalid local id", string);
        }
        hashSet = DiagnosticEventFactory.createDiagnosticEvent(this.getObjectName().toString(), "selfDiagnostic", 10, DeploymentManager.class.getName(), "selfDiagnostic", null, null, null, hashMap);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "selfDiagnostic", hashSet);
        }
        return new DiagnosticEvent[]{hashSet};
    }

    public String[] localize(String[] stringArray, Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(DIAGNOSTIC_BUNDLE, locale);
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = resourceBundle.getString(stringArray[i]);
        }
        return stringArray2;
    }

    private Vector getNodes() throws Exception {
        Vector<String> vector = new Vector<String>();
        String string = this.repositoryRootURI + "/cells/" + this.cellName + "/nodes";
        File file = new File(string);
        File[] fileArray = file.listFiles();
        String string2 = null;
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            string2 = fileArray[i].getName();
            vector.add(string2);
        }
        return vector;
    }

    class Version5NodeMetadataCollector
    extends Thread {
        private Properties _collectorMgrProps;
        private AdminClient _adminClient;
        private ObjectName _svrMBeanName;

        public Version5NodeMetadataCollector(Properties properties, AdminClient adminClient, ObjectName objectName) {
            this._collectorMgrProps = properties;
            this._adminClient = adminClient;
            this._svrMBeanName = objectName;
        }

        public void run() {
            block4: {
                try {
                    PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            ManagedObjectMetadataCollectorManager managedObjectMetadataCollectorManager = ManagedObjectMetadataCollectorManagerFactory.createCollectorManager(Version5NodeMetadataCollector.this._collectorMgrProps, Version5NodeMetadataCollector.this._adminClient);
                            Properties properties = managedObjectMetadataCollectorManager.updateVersion5Metadata(Version5NodeMetadataCollector.this._svrMBeanName);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "New v5 metadata props:", properties);
                            }
                            return properties;
                        }
                    };
                    try {
                        SecurityContext.runAsSystem(privilegedExceptionAction);
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw privilegedActionException.getException();
                    }
                }
                catch (Throwable throwable) {
                    if (!tc.isEventEnabled()) break block4;
                    Tr.event(tc, "Could not collect v5 data:", throwable);
                }
            }
        }
    }

    private final class NodeAgentInfo {
        private String nodeName;
        private String serverName;

        NodeAgentInfo(String string, String string2) {
            this.nodeName = string;
            this.serverName = string2;
        }

        String getNodeName() {
            return this.nodeName;
        }

        String getServerName() {
            return this.serverName;
        }

        public boolean equals(Object object) {
            if (object != null && object.getClass().equals(this.getClass())) {
                NodeAgentInfo nodeAgentInfo = (NodeAgentInfo)object;
                return this.nodeName.equals(nodeAgentInfo.getNodeName()) && this.serverName.equals(nodeAgentInfo.getServerName());
            }
            return false;
        }

        public int hashCode() {
            return this.nodeName.hashCode() + this.serverName.hashCode();
        }
    }
}

