/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.deploymentmanager;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.ObjectNameHelper;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessor;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataAccessorFactory;
import com.ibm.websphere.management.metadata.ManagedObjectMetadataHelper;
import com.ibm.websphere.management.sync.SyncResult;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.deploymentmanager.DeploymentManager;
import com.ibm.ws.management.deploymentmanager.MultiSyncEvent;
import com.ibm.ws.management.util.SecurityHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.management.Attribute;
import javax.management.ListenerNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class MultiSyncManager {
    private static TraceComponent tc = Tr.register(MultiSyncManager.class, "Admin", "com.ibm.ws.management.resources.sync");
    private static String BUNDLE_NAME = "com.ibm.ws.management.resources.sync";
    private ResourceBundle bundle = ResourceBundle.getBundle(BUNDLE_NAME, Locale.getDefault());
    private int maxNodes = 5;
    private long SLEEP_TIMEOUT = 30000L;
    private boolean isRunning;
    private DeploymentManager dmgr;
    private HashMap autoSyncStates = new HashMap();
    private static ManagedObjectMetadataHelper metaObjectHelper = null;

    public MultiSyncManager(DeploymentManager deploymentManager) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "MultiSyncManager", new Object[]{deploymentManager});
        }
        this.dmgr = deploymentManager;
        this.maxNodes = Integer.getInteger("com.ibm.websphere.multisync.maxnodes", 5);
        this.SLEEP_TIMEOUT = Long.getLong("com.ibm.websphere.multisync.timeout", 30L);
        this.SLEEP_TIMEOUT *= 1000L;
        if (metaObjectHelper == null) {
            try {
                ManagedObjectMetadataAccessor managedObjectMetadataAccessor = ManagedObjectMetadataAccessorFactory.createAccessor(null);
                metaObjectHelper = new ManagedObjectMetadataHelper(managedObjectMetadataAccessor);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.cellmanager.DeploymentManager.<init>", "103", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "generate Exception", exception);
                }
                metaObjectHelper = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "MultiSyncManager", new Object[]{new Integer(this.maxNodes), new Long(this.SLEEP_TIMEOUT)});
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void begin(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "begin");
        }
        if (!bl) {
            Subject subject = SecurityHelper.getInvocationSubject();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invocation subject", subject);
            }
            if (subject == null) {
                subject = SecurityHelper.getReceivedSubject();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Recieved subject", subject);
                }
            }
            MultiSyncManagerThread multiSyncManagerThread = new MultiSyncManagerThread(subject);
            multiSyncManagerThread.setDaemon(true);
            multiSyncManagerThread.start();
        } else {
            MultiSyncManagerThread multiSyncManagerThread = new MultiSyncManagerThread(null);
            multiSyncManagerThread.run();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "begin");
        }
    }

    public String getFormattedMessage(String string, Object[] objectArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFormattedMessage", new Object[]{string, objectArray});
        }
        String string2 = TraceNLS.getStringFromBundle(BUNDLE_NAME, string, (String)null);
        if (objectArray != null) {
            string2 = TraceNLS.getFormattedMessageFromLocalizedMessage(string2, objectArray, true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFormattedMessage", new Object[]{string2});
        }
        return string2;
    }

    private Boolean getAutoSyncEnabled(ObjectName objectName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAutoSyncEnabled", new Object[]{objectName});
        }
        Boolean bl = null;
        if (objectName != null) {
            try {
                bl = (Boolean)AdminServiceFactory.getAdminService().getAttribute(objectName, "autoSyncEnabled");
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.cellmanager.DeploymentManager.multiSync.getAutoSyncEnabled", "365", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAutoSyncEnabled", bl);
        }
        return bl;
    }

    private Boolean setAutoSyncEnabled(ObjectName objectName, Boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAutoSyncEnabled", new Object[]{objectName, bl});
        }
        Boolean bl2 = null;
        if (objectName != null) {
            try {
                Attribute attribute = new Attribute("autoSyncEnabled", bl);
                AdminServiceFactory.getAdminService().setAttribute(objectName, attribute);
                bl2 = Boolean.TRUE;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.cellmanager.DeploymentManager.multiSync.setAutoSyncEnabled", "390", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "error setting AutoSyncEnabled", exception);
                }
                bl2 = Boolean.FALSE;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAutoSyncEnabled", new Object[]{bl});
        }
        return bl2;
    }

    private boolean isV5Node(String string) {
        boolean bl;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isV5Node", string);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "metadatahelper", metaObjectHelper);
            }
            bl = true;
            if (metaObjectHelper != null) {
                try {
                    String string2 = metaObjectHelper.getNodeMajorVersion(string);
                    int n = Integer.parseInt(string2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "version " + n);
                    }
                    bl = n == 5;
                }
                catch (AdminException adminException) {
                    FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.cellmanager.DeploymentManager.multiSync.isV5Node", "218", this);
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "error getting Node Version", adminException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isV5Node", new Boolean(bl));
        }
        return bl;
    }

    private class MultiSyncManagerThread
    extends Thread
    implements NotificationListener {
        Subject subject = null;
        Set togo = new HashSet();
        Set inProgress = new HashSet();
        Set complete = new HashSet();
        Set failed = new HashSet();
        Set doubtful = new HashSet();

        public MultiSyncManagerThread(Subject subject) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "MultiSyncManagerThread", new Object[]{subject});
            }
            this.subject = subject;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "MultiSyncManagerThread");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "run");
            }
            Subject subject = null;
            if (this.subject != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "pushing subject");
                }
                subject = SecurityHelper.pushInvocationSubject(this.subject);
            }
            try {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "run");
                }
                MultiSyncManager.this.isRunning = true;
                String string = MultiSyncManager.this.getFormattedMessage("ADMS0200I", null);
                MultiSyncEvent multiSyncEvent = new MultiSyncEvent("ADMS0200I", string, 2);
                MultiSyncManager.this.dmgr.sendMultiSyncNotification(multiSyncEvent);
                HashSet hashSet = new HashSet();
                AdminService adminService = AdminServiceFactory.getAdminService();
                ObjectName objectName = null;
                try {
                    objectName = new ObjectName("WebSphere:*,type=NodeSync,process=nodeagent");
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                    FFDCFilter.processException((Throwable)malformedObjectNameException, "com.ibm.ws.management.cellmanager.DeploymentManager.multiSync", "153", this);
                }
                Set set = adminService.queryNames(objectName, null);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    object5 = (ObjectName)iterator.next();
                    object4 = ObjectNameHelper.getNodeName((ObjectName)object5);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Checking AutoSync for Node:", object4);
                    }
                    if ((object3 = MultiSyncManager.this.getAutoSyncEnabled((ObjectName)object5)) == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Cannot get autosync enabled removing this node", object5);
                        }
                        object2 = "Cannot get autosync enabled for this node: " + (String)object4 + "  Make sure user logged is granted atleast operator role. If the user has operator role, make sure the nodeagent has been restarted after mapping user to the role.";
                        object = new MultiSyncEvent("ADMS0206I", (String)object2, 0);
                        MultiSyncManager.this.dmgr.sendMultiSyncNotification((MultiSyncEvent)object);
                        iterator.remove();
                        this.failed.add(object5);
                        continue;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "AutoSync for Node is currently:", object3);
                    }
                    MultiSyncManager.this.autoSyncStates.put(object5, object3);
                    if (!((Boolean)object3).booleanValue()) continue;
                    MultiSyncManager.this.setAutoSyncEnabled((ObjectName)object5, new Boolean(false));
                    object2 = MultiSyncManager.this.getFormattedMessage("ADMS0202I", new Object[]{object4});
                    object = new MultiSyncEvent("ADMS0202I", (String)object2, 2);
                    MultiSyncManager.this.dmgr.sendMultiSyncNotification((MultiSyncEvent)object);
                }
                this.togo.addAll(set);
                while (this.togo.size() > 0) {
                    Object object6;
                    block52: {
                        object5 = (ObjectName)this.togo.iterator().next();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "NodeSync", object5);
                        }
                        object4 = ObjectNameHelper.getNodeName((ObjectName)object5);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Node", object4);
                        }
                        object3 = new NotificationFilterSupport();
                        adminService.addNotificationListenerExtended((ObjectName)object5, this, null, object5);
                        object2 = null;
                        try {
                            object2 = (Boolean)adminService.invoke((ObjectName)object5, "requestSync", null, null);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Sync requested", object2);
                            }
                            if (!((Boolean)object2).booleanValue()) {
                                this.inProgress.add(object5);
                                this.doubtful.add(object5);
                            }
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.cellmanager.DeploymentManager.multiSync.run", "178", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception invoking requestSync", exception);
                            }
                            object2 = new Boolean(false);
                            try {
                                adminService.removeNotificationListenerExtended((ObjectName)object5, this);
                            }
                            catch (ListenerNotFoundException listenerNotFoundException) {
                                FFDCFilter.processException((Throwable)listenerNotFoundException, "com.ibm.ws.management.deploymentmanager.MultiSyncManager.run", "293", this);
                                if (!tc.isDebugEnabled()) break block52;
                                Tr.debug(tc, "Listener not found exception", listenerNotFoundException);
                            }
                        }
                    }
                    this.togo.remove(object5);
                    if (((Boolean)object2).booleanValue()) {
                        this.inProgress.add(object5);
                    } else {
                        this.failed.add(object5);
                        object = MultiSyncManager.this.getFormattedMessage("ADMS0204E", new Object[]{object4});
                        object6 = new MultiSyncEvent("ADMS0204E", (String)object, 0);
                        MultiSyncManager.this.dmgr.sendMultiSyncNotification((MultiSyncEvent)object6);
                    }
                    if (this.inProgress.size() < MultiSyncManager.this.maxNodes) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "In Progress", this.inProgress);
                    }
                    try {
                        object = this;
                        synchronized (object) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Checking doubtful set", this.doubtful);
                            }
                            object6 = this.checkCurrentSyncs(this.doubtful);
                            this.sendSyncStatus((Map)object6);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Waiting 1...");
                            }
                            this.wait(MultiSyncManager.this.SLEEP_TIMEOUT);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Check the status of the inProgress...");
                            }
                            Map map = this.checkCurrentSyncs(this.inProgress);
                            this.sendSyncStatus(map);
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.cellmanager.DeploymentManager.multiSync.run", "206", this);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Exception waiting", exception);
                    }
                }
                while (this.inProgress.size() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "In Progress", this.inProgress);
                    }
                    try {
                        object5 = this;
                        synchronized (object5) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Checking doubtful set", this.doubtful);
                            }
                            object4 = this.checkCurrentSyncs(this.doubtful);
                            this.sendSyncStatus((Map)object4);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Waiting 2...");
                            }
                            this.wait(MultiSyncManager.this.SLEEP_TIMEOUT);
                            object3 = this.checkCurrentSyncs(this.inProgress);
                            this.sendSyncStatus((Map)object3);
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.cellmanager.DeploymentManager.multiSync.run", "223", this);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Exception waiting -2", exception);
                    }
                }
                if (this.failed.size() > 0) {
                    object5 = MultiSyncManager.this.getFormattedMessage("ADMS0209W", null);
                    object4 = new MultiSyncEvent("ADMS0209W", (String)object5, 1);
                    ((MultiSyncEvent)object4).setComplete(true);
                    MultiSyncManager.this.dmgr.sendMultiSyncNotification((MultiSyncEvent)object4);
                } else {
                    object5 = MultiSyncManager.this.getFormattedMessage("ADMS0208I", null);
                    object4 = new MultiSyncEvent("ADMS0208I", (String)object5, 2);
                    ((MultiSyncEvent)object4).setComplete(true);
                    MultiSyncManager.this.dmgr.sendMultiSyncNotification((MultiSyncEvent)object4);
                }
                MultiSyncManager.this.isRunning = false;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "run");
                }
            }
            catch (Exception exception) {
                MultiSyncEvent multiSyncEvent = new MultiSyncEvent("ADMS0206I", exception.toString(), 0);
                multiSyncEvent.setComplete(true);
                MultiSyncManager.this.dmgr.sendMultiSyncNotification(multiSyncEvent);
            }
            finally {
                if (this.subject != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "poping subject");
                    }
                    SecurityHelper.popInvocationSubject(subject);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "run");
            }
        }

        /*
         * Unable to fully structure code
         */
        private void sendSyncStatus(Map var1_1) {
            if (MultiSyncManager.access$000().isEntryEnabled()) {
                Tr.entry(MultiSyncManager.access$000(), "sendSyncStatus", var1_1);
            }
            var2_2 = var1_1.entrySet();
            var3_3 = var2_2.iterator();
            while (var3_3.hasNext()) {
                block14: {
                    var4_4 = var3_3.next();
                    var5_5 = (ObjectName)var4_4.getKey();
                    var6_6 = ObjectNameHelper.getNodeName(var5_5);
                    var7_7 = var4_4.getValue();
                    var8_8 = null;
                    var9_9 = null;
                    if (MultiSyncManager.access$000().isDebugEnabled()) {
                        Tr.debug(MultiSyncManager.access$000(), "SyncResult", var7_7);
                    }
                    if (var7_7 == null) break block14;
                    var10_10 = AdminServiceFactory.getAdminService();
                    var11_11 = -1;
                    var11_11 = var7_7 instanceof SyncResult != false ? ((SyncResult)var7_7).getResult() : ((com.ibm.ws.management.sync.SyncResult)var7_7).getResult();
                    var8_8 = MultiSyncManager.this.getFormattedMessage("ADMS0207I", new Object[]{var6_6, var4_4.getValue()});
                    var12_12 = new MultiSyncEvent("ADMS0207I", var8_8, 2);
                    MultiSyncManager.access$200(MultiSyncManager.this).sendMultiSyncNotification(var12_12);
                    switch (var11_11) {
                        case 0: {
                            if (!MultiSyncManager.access$000().isDebugEnabled()) break;
                            Tr.debug(MultiSyncManager.access$000(), "Still in Progress");
                            break;
                        }
                        case 1: 
                        case 2: {
                            if (MultiSyncManager.access$000().isDebugEnabled()) {
                                Tr.debug(MultiSyncManager.access$000(), "Shouldn't I be declared done?");
                            }
                            this.inProgress.remove(var5_5);
                            this.doubtful.remove(var5_5);
                            this.complete.add(var5_5);
                            var13_13 = MultiSyncManager.this.getFormattedMessage("ADMS0205I", new Object[]{var6_6});
                            var14_14 = new MultiSyncEvent("ADMS0205I", var13_13, 2);
                            MultiSyncManager.access$200(MultiSyncManager.this).sendMultiSyncNotification(var14_14);
                            try {
                                var10_10.removeNotificationListenerExtended(var5_5, this);
                            }
                            catch (ListenerNotFoundException var15_16) {
                                if (!MultiSyncManager.access$000().isDebugEnabled()) ** GOTO lbl44
                                Tr.debug(MultiSyncManager.access$000(), "Listener not found exception", var15_16);
                            }
lbl44:
                            // 3 sources

                            var9_9 = (Boolean)MultiSyncManager.access$400(MultiSyncManager.this).get(var5_5);
                            if (!var9_9.booleanValue()) break;
                            MultiSyncManager.access$500(MultiSyncManager.this, var5_5, new Boolean(true));
                            break;
                        }
                        case 3: 
                        case 4: {
                            var15_15 = MultiSyncManager.this.getFormattedMessage("ADMS0206I", new Object[]{var6_6});
                            var16_17 = new MultiSyncEvent("ADMS0206I", var15_15, 0);
                            MultiSyncManager.access$200(MultiSyncManager.this).sendMultiSyncNotification(var16_17);
                            this.inProgress.remove(var5_5);
                            this.doubtful.remove(var5_5);
                            this.failed.add((ObjectName)var4_4.getKey());
                            try {
                                var10_10.removeNotificationListenerExtended(var5_5, this);
                            }
                            catch (ListenerNotFoundException var17_18) {
                                if (!MultiSyncManager.access$000().isDebugEnabled()) ** GOTO lbl65
                                Tr.debug(MultiSyncManager.access$000(), "Listener not found exception", var17_18);
                            }
lbl65:
                            // 3 sources

                            var9_9 = (Boolean)MultiSyncManager.access$400(MultiSyncManager.this).get(var5_5);
                            if (!var9_9.booleanValue()) break;
                            MultiSyncManager.access$500(MultiSyncManager.this, var5_5, new Boolean(true));
                        }
                    }
                    continue;
                }
                var8_8 = MultiSyncManager.this.getFormattedMessage("ADMS0210E", new Object[]{var6_6});
                this.failed.add((ObjectName)var4_4.getKey());
                this.inProgress.remove(var5_5);
                this.doubtful.remove(var5_5);
                var10_10 = new MultiSyncEvent("ADMS0210E", var8_8, 0);
                MultiSyncManager.access$200(MultiSyncManager.this).sendMultiSyncNotification((MultiSyncEvent)var10_10);
            }
            if (MultiSyncManager.access$000().isEntryEnabled()) {
                Tr.exit(MultiSyncManager.access$000(), "sendSyncStatus");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map checkCurrentSyncs(Set set) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkCurrentSyncs", null);
            }
            AdminService adminService = AdminServiceFactory.getAdminService();
            HashMap<ObjectName, Object> hashMap = new HashMap<ObjectName, Object>();
            Set set2 = this.inProgress;
            synchronized (set2) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    ObjectName objectName = (ObjectName)iterator.next();
                    String string = ObjectNameHelper.getNodeName(objectName);
                    Object object = null;
                    String string2 = "getSyncResult";
                    if (!MultiSyncManager.this.isV5Node(string)) {
                        string2 = "getResult";
                    }
                    try {
                        object = adminService.invoke(objectName, string2, null, null);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.deploymentmanager.MultiSyncManager.checkCurrentSyncs", "483", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "error getting syncResult", exception);
                        }
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.cellmanager.DeploymentManager.multiSync.checkCurrentSyncs", "297", this);
                        object = null;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Result", object);
                    }
                    hashMap.put(objectName, object);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkCurrentSyncs", new Object[]{hashMap});
            }
            return hashMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleNotification(Notification notification, Object object) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handleNotification", new Object[]{notification, object});
            }
            Object var3_3 = null;
            String string = notification.getType();
            if (string.equals("websphere.nodesync.initiated")) {
                String string2 = ObjectNameHelper.getNodeName((ObjectName)object);
                String string3 = MultiSyncManager.this.getFormattedMessage("ADMS0201I", new Object[]{string2});
                MultiSyncEvent multiSyncEvent = new MultiSyncEvent("ADMS0201I", string3, 2);
                MultiSyncManager.this.dmgr.sendMultiSyncNotification(multiSyncEvent);
            } else if (string.equals("websphere.nodesync.complete")) {
                Object object2;
                block14: {
                    this.inProgress.remove(object);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "In Progress", this.inProgress);
                    }
                    this.complete.add(object);
                    AdminService adminService = AdminServiceFactory.getAdminService();
                    try {
                        adminService.removeNotificationListenerExtended((ObjectName)object, this);
                    }
                    catch (ListenerNotFoundException listenerNotFoundException) {
                        if (!tc.isDebugEnabled()) break block14;
                        Tr.debug(tc, "Listener not found exception", listenerNotFoundException);
                    }
                }
                String string4 = ObjectNameHelper.getNodeName((ObjectName)object);
                Boolean bl = (Boolean)notification.getUserData();
                MultiSyncEvent multiSyncEvent = null;
                String string5 = null;
                if (bl.booleanValue()) {
                    string5 = MultiSyncManager.this.getFormattedMessage("ADMS0205I", new Object[]{string4});
                    multiSyncEvent = new MultiSyncEvent("ADMS0205I", string5, 2);
                } else {
                    string5 = MultiSyncManager.this.getFormattedMessage("ADMS0206I", new Object[]{string4});
                    multiSyncEvent = new MultiSyncEvent("ADMS0206I", string5, 0);
                }
                MultiSyncManager.this.dmgr.sendMultiSyncNotification(multiSyncEvent);
                Boolean bl2 = (Boolean)MultiSyncManager.this.autoSyncStates.get((ObjectName)object);
                if (bl2.booleanValue()) {
                    MultiSyncManager.this.setAutoSyncEnabled((ObjectName)object, new Boolean(true));
                    object2 = MultiSyncManager.this.getFormattedMessage("ADMS0203I", new Object[]{string4});
                    MultiSyncEvent multiSyncEvent2 = new MultiSyncEvent("ADMS0203I", (String)object2, 2);
                    MultiSyncManager.this.dmgr.sendMultiSyncNotification(multiSyncEvent2);
                }
                object2 = this;
                synchronized (object2) {
                    this.notify();
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "handleNotification");
            }
        }
    }
}

