/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.descriptor;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.DescriptorParseException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.MBeanFactoryImpl;
import com.ibm.ws.management.descriptor.DescriptorExtensions;
import com.ibm.ws.management.descriptor.MBeanDescriptorManager;
import com.ibm.ws.management.descriptor.StandardDescriptorFieldName;
import com.ibm.ws.management.descriptor.WsDescriptorSupport;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.xml.ParserFactory;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class MBeanDescriptorLoader2
extends DefaultHandler
implements StandardDescriptorFieldName,
DescriptorExtensions {
    public static final String VALIDATE_DESCRIPTOR_PROPERTY = "com.ibm.websphere.management.descriptor.validateDescriptors";
    private static TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resource.adminservice");
    private static TraceComponent tc = Tr.register(MBeanDescriptorLoader2.class, "MBeanFactory", "com.ibm.ws.management.resources.adminservice");
    private static final String SERVANT_NOTIFICATION_HANDLER = "com.ibm.ws.management.ServantNotificationHandler";
    private static final String HANDLE_SERVANT_NOTIFICATION = "handleServantNotification";
    private static final String MBEAN_STATE_PROVIDER = "com.ibm.ws.management.MBeanStateProvider";
    private static final String GET_MBEAN_STATE = "getMBeanState";
    private ModelMBeanInfo info = null;
    private String description = null;
    private Descriptor mbeanDescriptor = null;
    private List parentTypes = new ArrayList();
    private List attributes = new ArrayList();
    private List operations = new ArrayList();
    private List notifications = new ArrayList();
    private List constructors = new ArrayList();
    private List aggregationHandlers = new ArrayList();
    private Stack contextStack = new Stack();
    private Stack currentElement = new Stack();
    private StringBuffer characters = new StringBuffer();
    private Locator locator = null;
    private String type = null;
    private PlatformHelper platformHelper = null;

    public void load(InputStream inputStream, String string) throws DescriptorParseException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "load", string);
        }
        this.platformHelper = AdminHelper.getPlatformHelper();
        try {
            XMLReader xMLReader = ParserFactory.createXMLReader();
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this);
            InputSource inputSource = new InputSource(inputStream);
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ADMN0001W", string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "load", string);
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "error", sAXParseException);
        }
        throw new SAXException(sAXParseException);
    }

    public void startDocument() throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startDocument");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startDocument");
        }
    }

    public void endDocument() throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "endDocument");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "endDocument", this.mbeanDescriptor);
        }
    }

    private void endMbean() {
        this.loadParentTypes();
        WsDescriptorSupport wsDescriptorSupport = new WsDescriptorSupport();
        wsDescriptorSupport.setField("name", "jmx.attribute.changed");
        wsDescriptorSupport.setField("messageID", "notification.attribute.changed");
        wsDescriptorSupport.setField("visibility", new Integer(3));
        wsDescriptorSupport.setField("severity", "5");
        wsDescriptorSupport.setField("descriptortype", "notification");
        ModelMBeanNotificationInfo modelMBeanNotificationInfo = new ModelMBeanNotificationInfo(new String[]{"jmx.attribute.changed"}, "jmx.attribute.changed", "", wsDescriptorSupport);
        this.addFeatureInfo(this.notifications, modelMBeanNotificationInfo, true);
        ModelMBeanAttributeInfo[] modelMBeanAttributeInfoArray = new ModelMBeanAttributeInfo[this.attributes.size()];
        this.attributes.toArray(modelMBeanAttributeInfoArray);
        ModelMBeanConstructorInfo[] modelMBeanConstructorInfoArray = new ModelMBeanConstructorInfo[this.constructors.size()];
        this.constructors.toArray(modelMBeanConstructorInfoArray);
        ModelMBeanOperationInfo[] modelMBeanOperationInfoArray = new ModelMBeanOperationInfo[this.operations.size()];
        this.operations.toArray(modelMBeanOperationInfoArray);
        ModelMBeanNotificationInfo[] modelMBeanNotificationInfoArray = new ModelMBeanNotificationInfo[this.notifications.size()];
        this.notifications.toArray(modelMBeanNotificationInfoArray);
        this.info = new ModelMBeanInfoSupport("javax.management.modelmbean.RequiredModelMBean", this.description, modelMBeanAttributeInfoArray, modelMBeanConstructorInfoArray, modelMBeanOperationInfoArray, modelMBeanNotificationInfoArray, this.mbeanDescriptor);
        MBeanDescriptorManager.getInstance().populateCache(this.type, this.info);
        this.attributes.clear();
        this.constructors.clear();
        this.operations.clear();
        this.notifications.clear();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes2) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startElement", string2);
        }
        this.currentElement.push(string2);
        if (string2.equals("MBean")) {
            this.parseMBeanInfo(attributes2);
        } else if (string2.equals("attribute")) {
            this.addFeatureInfo(this.attributes, this.parseAttributeInfo(attributes2), true);
        } else if (string2.equals("operation")) {
            this.parseOperationInfo(attributes2);
        } else if (string2.equals("notification")) {
            this.parseNotificationInfo(attributes2);
        } else if (string2.equals("parameter")) {
            this.pushContext(this.parseParameterInfo(attributes2));
        } else if (string2.equals("parentType")) {
            this.pushContext(this.parseParentType(attributes2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startElement");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "endElement", string2);
        }
        try {
            if (string2.equals("operation")) {
                MBeanParameterInfo[] mBeanParameterInfoArray = (MBeanParameterInfo[])this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "signature", mBeanParameterInfoArray);
                }
                Descriptor descriptor = (Descriptor)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "opDescriptor", descriptor);
                }
                int n = (Integer)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "impact," + n);
                }
                String string4 = (String)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "type", string4);
                }
                String string5 = (String)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "description", string5);
                }
                String string6 = (String)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "name", string6);
                }
                ModelMBeanOperationInfo modelMBeanOperationInfo = new ModelMBeanOperationInfo(string6, string5, mBeanParameterInfoArray, string4, n, descriptor);
                this.addFeatureInfo(this.operations, modelMBeanOperationInfo, true);
            } else if (string2.equals("constructor")) {
                MBeanParameterInfo[] mBeanParameterInfoArray = (MBeanParameterInfo[])this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "signature", mBeanParameterInfoArray);
                }
                Descriptor descriptor = (Descriptor)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "descriptor", descriptor);
                }
                String string7 = (String)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "description", string7);
                }
                String string8 = (String)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "name", string8);
                }
                ModelMBeanConstructorInfo modelMBeanConstructorInfo = new ModelMBeanConstructorInfo(string8, string7, mBeanParameterInfoArray, descriptor);
                this.addFeatureInfo(this.constructors, modelMBeanConstructorInfo, true);
            } else if (string2.equals("notification")) {
                int n = this.findSameType("notificationType");
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = (String)this.popupContext().value;
                }
                Descriptor descriptor = (Descriptor)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "descriptor", descriptor);
                }
                String string9 = (String)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "description", string9);
                }
                String string10 = (String)this.popupContext().value;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "name", string10);
                }
                ModelMBeanNotificationInfo modelMBeanNotificationInfo = new ModelMBeanNotificationInfo(stringArray, string10, string9, descriptor);
                this.addFeatureInfo(this.notifications, modelMBeanNotificationInfo, true);
            } else if (string2.equals("signature")) {
                int n = this.findSameType("parameter");
                MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[n];
                for (int i = mBeanParameterInfoArray.length - 1; i >= 0; --i) {
                    mBeanParameterInfoArray[i] = (MBeanParameterInfo)this.popupContext().value;
                }
                this.pushContext(mBeanParameterInfoArray);
            } else if (string2.equals("MBean")) {
                this.endMbean();
            }
        }
        finally {
            if (this.characters.length() > 0) {
                String string11 = this.characters.toString();
                if ((string11 = string11.trim()).length() > 0) {
                    this.pushContext(string11);
                }
                this.characters.setLength(0);
            }
            this.currentElement.pop();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "endElement");
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.characters.append(cArray, n, n2);
    }

    private void loadParentTypes() {
        int n = this.findSameType("parentType");
        for (int i = 0; i < n; ++i) {
            ModelMBeanInfo modelMBeanInfo = (ModelMBeanInfo)this.popupContext().value;
            this.addFeatures(this.attributes, modelMBeanInfo.getAttributes());
            this.addFeatures(this.operations, modelMBeanInfo.getOperations());
            this.addFeatures(this.notifications, modelMBeanInfo.getNotifications());
            try {
                this.setJSR77OptionalInterfaceFromParent(modelMBeanInfo);
                this.collectAggregationHandlersFromParent(modelMBeanInfo);
                continue;
            }
            catch (MBeanException mBeanException) {
                // empty catch block
            }
        }
    }

    private void addFeatures(List list, MBeanFeatureInfo[] mBeanFeatureInfoArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addFeatures", new Object[]{list, mBeanFeatureInfoArray});
        }
        for (int i = 0; i < mBeanFeatureInfoArray.length; ++i) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!e2.equals(mBeanFeatureInfoArray[i])) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removing duplicate feature " + e2);
                }
                iterator.remove();
                break;
            }
            list.add(mBeanFeatureInfoArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addFeatures");
        }
    }

    private void collectAggregationHandlersFromParent(ModelMBeanInfo modelMBeanInfo) throws MBeanException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "collectAggregationHandlersFromParent", modelMBeanInfo);
        }
        Descriptor descriptor = modelMBeanInfo.getMBeanDescriptor();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Descriptor", descriptor);
        }
        String[] stringArray = descriptor.getFieldNames();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Fields", stringArray);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Field:", stringArray[i]);
            }
            if (!stringArray[i].equalsIgnoreCase("aggregationHandlerClass")) continue;
            this.aggregationHandlers.add(descriptor.getFieldValue(stringArray[i]));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "collectAggregationHandlersFromParent");
        }
    }

    private void setJSR77OptionalInterfaceFromParent(ModelMBeanInfo modelMBeanInfo) throws MBeanException {
        Descriptor descriptor = modelMBeanInfo.getMBeanDescriptor();
        String[] stringArray = descriptor.getFieldNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("eventProvider") && !stringArray[i].equalsIgnoreCase("stateManageable") && !stringArray[i].equalsIgnoreCase("statisticsProvider")) continue;
            this.mbeanDescriptor.setField(stringArray[i], descriptor.getFieldValue(stringArray[i]));
        }
    }

    private void setJSR77OptionalInterfaceIntoDescriptor(String string) {
        if (string.equals("EventProvider")) {
            this.mbeanDescriptor.setField("eventProvider", Boolean.TRUE);
        } else if (string.equals("StateManageable")) {
            this.mbeanDescriptor.setField("stateManageable", Boolean.TRUE);
        } else if (string.equals("StatisticsProvider")) {
            this.mbeanDescriptor.setField("statisticsProvider", Boolean.TRUE);
        }
    }

    private ModelMBeanInfo getModelMBeanInfo() {
        return this.info;
    }

    private void parseMBeanInfo(Attributes attributes2) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseMBeanInfo", attributes2);
        }
        this.mbeanDescriptor = new WsDescriptorSupport();
        this.mbeanDescriptor.setField("name", "Dummy_Name");
        this.mbeanDescriptor.setField("descriptorType", "MBean");
        this.mbeanDescriptor.setField("spec", "1.0");
        for (int i = 0; i < attributes2.getLength(); ++i) {
            String string = attributes2.getLocalName(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attrName:", string);
            }
            String string2 = attributes2.getValue(i);
            if (string.equals("description")) {
                this.description = string2;
                continue;
            }
            this.setDescriptorFields(string, string2, this.mbeanDescriptor);
        }
        this.type = attributes2.getValue("type");
        if (this.type == null) {
            this.type = attributes2.getValue("j2eeType");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseMBeanInfo", this.mbeanDescriptor);
        }
    }

    private ModelMBeanAttributeInfo parseAttributeInfo(Attributes attributes2) throws SAXException {
        Cloneable cloneable;
        Object object;
        String string;
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseAttributeInfo", attributes2);
        }
        String string3 = null;
        String string4 = null;
        String string5 = null;
        WsDescriptorSupport wsDescriptorSupport = new WsDescriptorSupport();
        wsDescriptorSupport.setField("descriptorType", "attribute");
        wsDescriptorSupport.setField("value", "");
        for (int i = 0; i < attributes2.getLength(); ++i) {
            String string6 = attributes2.getLocalName(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attrName:", string6);
            }
            string2 = attributes2.getValue(i);
            if (string6.equals("name")) {
                string4 = string2;
                continue;
            }
            if (string6.equals("type")) {
                string5 = string2;
                continue;
            }
            if (string6.equals("description")) {
                string3 = string2;
                continue;
            }
            this.setDescriptorFields(string6, string2, wsDescriptorSupport);
        }
        wsDescriptorSupport.setField("name", string4);
        String string7 = (String)wsDescriptorSupport.getFieldValue("getMethod");
        boolean bl = string7 != null && string7.length() > 0;
        string2 = null;
        String string8 = (String)wsDescriptorSupport.getFieldValue("setMethod");
        boolean bl2 = string8 != null && string8.length() > 0;
        String string9 = null;
        if (this.platformHelper.isZOS()) {
            string2 = (String)wsDescriptorSupport.getFieldValue("proxyInvokeType");
            string9 = (String)wsDescriptorSupport.getFieldValue("proxySetterInvokeType");
        }
        boolean bl3 = false;
        if (bl) {
            int n = string7.lastIndexOf(46) + 1;
            int n2 = string7.indexOf(40);
            if (n2 == -1) {
                n2 = string7.length();
            }
            string = string7.substring(n, n2);
            if (string5.equals("java.lang.Boolean") && string.startsWith("is")) {
                bl3 = true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "attrDescriptor", wsDescriptorSupport);
        }
        ModelMBeanAttributeInfo modelMBeanAttributeInfo = new ModelMBeanAttributeInfo(string4, string5, string3, bl, bl2, bl3, wsDescriptorSupport);
        String string10 = (String)wsDescriptorSupport.getFieldValue("since");
        if (string10 == null && (string10 = (String)this.mbeanDescriptor.getFieldValue("since")) == null) {
            string10 = "5.0";
        }
        if (bl) {
            string = "getter for attribute " + string4;
            if (this.platformHelper.isZOS()) {
                object = new WsDescriptorSupport();
                object.setField("name", string7);
                object.setField("descriptorType", "operation");
                if (this.isVersionEarlier(string10, "6.0")) {
                    object.setField("role", "operation");
                } else {
                    object.setField("role", "getter");
                }
                object.setField("targetObjectType", "objectReference");
                object.setField("proxyInvokeType", string2);
                cloneable = new ModelMBeanOperationInfo(string7, string, new MBeanParameterInfo[0], string5, 0, (Descriptor)object);
                this.addFeatureInfo(this.operations, (MBeanFeatureInfo)((Object)cloneable), true);
            } else {
                object = new WsDescriptorSupport();
                object.setField("name", string7);
                object.setField("displayName", string7);
                object.setField("descriptorType", "operation");
                if (this.isVersionEarlier(string10, "6.0")) {
                    object.setField("role", "operation");
                } else {
                    object.setField("role", "getter");
                }
                object.setField("targetObjectType", "ObjectReference");
                cloneable = new ModelMBeanOperationInfo(string7, string, new MBeanParameterInfo[0], string5, 0, (Descriptor)object);
                this.addFeatureInfo(this.operations, (MBeanFeatureInfo)((Object)cloneable), true);
            }
        }
        if (bl2) {
            string = "setter for attribute " + string4;
            object = new MBeanParameterInfo[]{new MBeanParameterInfo(string4, string5, "setter for attribute")};
            cloneable = new WsDescriptorSupport();
            cloneable.setField("name", string8);
            if (this.platformHelper.isZOS()) {
                cloneable.setField("descriptorType", "operation");
                if (this.isVersionEarlier(string10, "6.0")) {
                    cloneable.setField("role", "operation");
                } else {
                    cloneable.setField("role", "setter");
                }
                cloneable.setField("targetObjectType", "objectReference");
                cloneable.setField("proxyInvokeType", string9);
                ModelMBeanOperationInfo modelMBeanOperationInfo = new ModelMBeanOperationInfo(string8, string, (MBeanParameterInfo[])object, "void", 1, (Descriptor)cloneable);
                this.addFeatureInfo(this.operations, modelMBeanOperationInfo, true);
            } else {
                cloneable.setField("displayName", string8);
                cloneable.setField("descriptorType", "operation");
                if (this.isVersionEarlier(string10, "6.0")) {
                    cloneable.setField("role", "operation");
                } else {
                    cloneable.setField("role", "setter");
                }
                cloneable.setField("targetObjectType", "ObjectReference");
                ModelMBeanOperationInfo modelMBeanOperationInfo = new ModelMBeanOperationInfo(string8, string, (MBeanParameterInfo[])object, "void", 1, (Descriptor)cloneable);
                this.addFeatureInfo(this.operations, modelMBeanOperationInfo, true);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseAttributeInfo", modelMBeanAttributeInfo);
        }
        return modelMBeanAttributeInfo;
    }

    private boolean isVersionEarlier(String string, String string2) {
        return Utils.compareVersions(string, string2) < 0;
    }

    private void parseConstructorInfo(Attributes attributes2) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseConstructorInfo", attributes2);
        }
        String string = null;
        String string2 = null;
        WsDescriptorSupport wsDescriptorSupport = new WsDescriptorSupport();
        wsDescriptorSupport.setField("descriptorType", "operation");
        wsDescriptorSupport.setField("role", "constructor");
        for (int i = 0; i < attributes2.getLength(); ++i) {
            String string3 = attributes2.getLocalName(i);
            String string4 = attributes2.getValue(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attrName", string3);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "value", string4);
            }
            if (string3.equals("name")) {
                string = string4;
                continue;
            }
            if (string3.equals("description")) {
                string2 = string4;
                continue;
            }
            this.setDescriptorFields(string3, string4, wsDescriptorSupport);
        }
        wsDescriptorSupport.setField("name", string);
        this.pushContext(string);
        this.pushContext(string2);
        this.pushContext(wsDescriptorSupport);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseConstructorInfo", wsDescriptorSupport);
        }
    }

    private void parseOperationInfo(Attributes attributes2) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseOperationInfo");
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 3;
        WsDescriptorSupport wsDescriptorSupport = new WsDescriptorSupport();
        wsDescriptorSupport.setField("descriptorType", "operation");
        wsDescriptorSupport.setField("role", "operation");
        for (int i = 0; i < attributes2.getLength(); ++i) {
            String string4 = attributes2.getLocalName(i);
            String string5 = attributes2.getValue(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attrName", string4);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "value", string5);
            }
            if (string4.equals("name")) {
                string = string5;
                wsDescriptorSupport.setField("displayName", string);
                continue;
            }
            if (string4.equals("description")) {
                string2 = string5;
                continue;
            }
            if (string4.equals("type")) {
                string3 = string5;
                continue;
            }
            if (string4.equals("impact")) {
                if (string5.compareToIgnoreCase("INFO") == 0) {
                    n = 0;
                    continue;
                }
                if (string5.compareToIgnoreCase("ACTION") == 0) {
                    n = 1;
                    continue;
                }
                if (string5.compareToIgnoreCase("ACTION_INFO") != 0) continue;
                n = 2;
                continue;
            }
            this.setDescriptorFields(string4, string5, wsDescriptorSupport);
        }
        wsDescriptorSupport.setField("name", string);
        this.pushContext(string);
        this.pushContext(string2);
        this.pushContext(string3);
        this.pushContext(new Integer(n));
        this.pushContext(wsDescriptorSupport);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseOperationInfo");
        }
    }

    private void parseNotificationInfo(Attributes attributes2) throws SAXException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseNotificationInfo", attributes2);
        }
        String string = null;
        String string2 = null;
        WsDescriptorSupport wsDescriptorSupport = new WsDescriptorSupport();
        wsDescriptorSupport.setField("descriptorType", "notification");
        for (int i = 0; i < attributes2.getLength(); ++i) {
            String string3 = attributes2.getLocalName(i);
            String string4 = attributes2.getValue(i);
            if (string3.equals("name")) {
                string2 = string4;
                continue;
            }
            if (string3.equals("description")) {
                string = string4;
                continue;
            }
            this.setDescriptorFields(string3, string4, wsDescriptorSupport);
        }
        wsDescriptorSupport.setField("name", string2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "notifDescriptor", wsDescriptorSupport);
        }
        this.pushContext(string2);
        this.pushContext(string);
        this.pushContext(wsDescriptorSupport);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseNotificationInfo");
        }
    }

    private MBeanParameterInfo parseParameterInfo(Attributes attributes2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseParameterInfo", attributes2);
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = attributes2.getLength();
        for (int i = 0; i < n; ++i) {
            String string4 = attributes2.getLocalName(i);
            String string5 = attributes2.getValue(i);
            if (string4.equals("name")) {
                string2 = string5;
                continue;
            }
            if (string4.equals("type")) {
                string = string5;
                continue;
            }
            if (!string4.equals("description")) continue;
            string3 = string5;
        }
        MBeanParameterInfo mBeanParameterInfo = new MBeanParameterInfo(string2, string, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseParameterInfo", mBeanParameterInfo);
        }
        return mBeanParameterInfo;
    }

    private ModelMBeanInfo parseParentType(Attributes attributes2) throws SAXException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parseParentType", attributes2);
        }
        String string = null;
        String string2 = null;
        int n = attributes2.getLength();
        for (int i = 0; i < n; ++i) {
            object = attributes2.getLocalName(i);
            String string3 = attributes2.getValue(i);
            if (((String)object).equals("type")) {
                string = string3;
                continue;
            }
            if (!((String)object).equals("descriptorFile")) continue;
            string2 = string3;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "type", string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "descriptorFile", string2);
        }
        MBeanFactoryImpl mBeanFactoryImpl = (MBeanFactoryImpl)AdminServiceFactory.getMBeanFactory();
        try {
            object = this.platformHelper.isZOS() ? (mBeanFactoryImpl == null || mBeanFactoryImpl.getDescriptorManager() == null ? MBeanDescriptorManager.getInstance().getDescriptor(string, string2) : mBeanFactoryImpl.getDescriptorManager().getDescriptor(string, string2)) : MBeanDescriptorManager.getInstance().getDescriptor(string, string2);
        }
        catch (DescriptorParseException descriptorParseException) {
            FFDCFilter.processException((Throwable)descriptorParseException, "com.ibm.ws.management.descriptor.MBeanDescriptorLoader.parseParentType", "608", this);
            throw new SAXException(nls.getFormattedMessage("ADMN0004E", new Object[]{string}, null), descriptorParseException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parseParentType", object);
        }
        return object;
    }

    private void setDescriptorFields(String string, String string2, Descriptor descriptor) throws SAXException {
        if (string.equals("collaboratorClass")) {
            descriptor.setField("collaboratorClass", string2);
            if (this.platformHelper.isControlJvm()) {
                this.setProxyOperationInfo(string2);
            }
        } else if (string.equals("allowDynamicProxyStaticRegistrationInControlRegion")) {
            descriptor.setField("allowDynamicProxyStaticRegistrationInControlRegion", string2);
        } else if (string.equals("dynamicProxyInterface")) {
            descriptor.setField("dynamicProxyInterface", string2);
        } else if (string.equals("proxyInvokeType")) {
            descriptor.setField("proxyInvokeType", string2);
        } else if (string.equals("proxySetterInvokeType")) {
            descriptor.setField("proxySetterInvokeType", string2);
        } else if (string.equals("aggregationHandlerClass")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "aggregationHandlerClass changes");
            }
            if (this.aggregationHandlers.size() > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                Iterator iterator = this.aggregationHandlers.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(iterator.next());
                    stringBuffer.append(':');
                }
                stringBuffer.append(string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "aggregationHandlerClasses", stringBuffer.toString());
                }
                descriptor.setField("aggregationHandlerClass", stringBuffer.toString());
            } else {
                descriptor.setField("aggregationHandlerClass", string2);
            }
        } else if (string.equals("eventHandlerClass")) {
            descriptor.setField("eventHandlerClass", string2);
        } else if (string.equals("invocationHandlerClass")) {
            descriptor.setField("invocationHandlerClass", string2);
        } else if (string.equals("stateObjectClass")) {
            descriptor.setField("stateObjectClass", string2);
            if (this.platformHelper.isControlJvm()) {
                this.setProxyOperationInfo("stateObjectClass");
            }
        } else if (string.equals("type")) {
            descriptor.setField("type", string2);
            this.setJSR77OptionalInterfaceIntoDescriptor(string2);
        } else if (string.equals("class")) {
            descriptor.setField("class", string2);
        } else if (string.equals("targetObjectType")) {
            descriptor.setField("targetObjectType", this.fixTargetObjectType(string2));
        } else if (string.equals("default")) {
            descriptor.setField("default", string2);
        } else if (string.equals("displayName")) {
            descriptor.setField("displayName", string2);
        } else if (string.equals("getMethod")) {
            descriptor.setField("getMethod", string2);
        } else if (string.equals("setMethod")) {
            descriptor.setField("setMethod", string2);
        } else if (string.equals("role")) {
            if (!string2.equalsIgnoreCase("setter") && !string2.equalsIgnoreCase("getter")) {
                string2 = "operation";
            }
            descriptor.setField("role", string2);
        } else if (string.equals("protocolMap")) {
            descriptor.setField("protocolMap", string2);
        } else if (string.equals("persistPolicy")) {
            descriptor.setField("persistPolicy", string2);
        } else if (string.equals("persistPeriod")) {
            descriptor.setField("persistPeriod", string2);
        } else if (string.equals("currencyTimeLimit")) {
            descriptor.setField("currencyTimeLimit", string2);
        } else if (string.equals("iterable")) {
            descriptor.setField("iterable", Boolean.valueOf(string2));
        } else if (string.equals("visibility")) {
            Integer n = null;
            try {
                n = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, "com.ibm.ws.management.descriptor.MBeanDescriptorLoader.setDescriptorFields", "673", this);
            }
            if (n == null || n < 1 || n > 4) {
                throw new SAXParseException(nls.getFormattedMessage("ADMN0002E", new Object[]{string2}, null), this.locator.getPublicId(), this.locator.getSystemId(), this.locator.getLineNumber(), this.locator.getColumnNumber());
            }
        } else if (string.equals("presentationString")) {
            descriptor.setField("presentationString", string2);
        } else if (string.equals("severity")) {
            descriptor.setField("severity", string2);
        } else if (string.equals("messageId")) {
            descriptor.setField("messageId", string2);
        } else if (string.equals("useLog")) {
            descriptor.setField("log", string2);
        } else if (string.equals("platform")) {
            descriptor.setField("platform", string2);
        } else if (string.equals("logFile")) {
            descriptor.setField("logFile", string2);
        } else if (string.equals("configureMBean")) {
            descriptor.setField("configureMBean", Boolean.valueOf(string2));
        } else if (string.equals("j2eeType")) {
            descriptor.setField("j2eeType", string2);
        } else if (string.equals("deprecated")) {
            descriptor.setField("deprecated", string2);
        } else if (string.equals("since")) {
            descriptor.setField("since", string2);
        } else if (string.equals("spec")) {
            descriptor.setField("spec", string2);
        }
    }

    private String fixTargetObjectType(String string) {
        String string2 = string;
        if (string.equals("objectReference")) {
            string2 = "ObjectReference";
        }
        return string2;
    }

    private void setProxyOperationInfo(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProxyOperationInfo", string);
        }
        try {
            Object object;
            MBeanParameterInfo[] mBeanParameterInfoArray;
            boolean bl = false;
            boolean bl2 = false;
            if (string.equals("dynamicproxy")) {
                Tr.debug(tc, "setProxyOperationInfo", "dynamicproxy path");
                bl = true;
            } else if (string.equals("stateObjectClass")) {
                Tr.debug(tc, "setProxyOperationInfo", "dynamicproxy state provider path");
                bl2 = true;
            } else {
                mBeanParameterInfoArray = MBeanDescriptorManager.getInstance().loadCollaboratorClass(string);
                object = mBeanParameterInfoArray.getInterfaces();
                String string2 = null;
                for (int i = 0; i < ((Class<?>[])object).length; ++i) {
                    string2 = object[i].getName();
                    if (string2.equals(SERVANT_NOTIFICATION_HANDLER)) {
                        bl = true;
                        continue;
                    }
                    if (!string2.equals(MBEAN_STATE_PROVIDER)) continue;
                    bl2 = true;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "servantNotificationHandler", new Boolean(bl));
                Tr.debug(tc, "mbeanStateProvider", new Boolean(bl2));
            }
            if (bl) {
                mBeanParameterInfoArray = new MBeanParameterInfo[]{new MBeanParameterInfo("notification", "javax.management.Notification", "Notifications emitted from servant MBeans")};
                object = new ModelMBeanOperationInfo(HANDLE_SERVANT_NOTIFICATION, "For Internal WebSphere Use Only!!", mBeanParameterInfoArray, "void", 3);
                this.addFeatureInfo(this.operations, (MBeanFeatureInfo)object, true);
            }
            if (bl2) {
                mBeanParameterInfoArray = new MBeanParameterInfo[]{};
                object = new ModelMBeanOperationInfo(GET_MBEAN_STATE, "For Internal WebSphere Use Only!!", mBeanParameterInfoArray, "java.io.Serializable", 3);
                this.addFeatureInfo(this.operations, (MBeanFeatureInfo)object, true);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProxyOperationInfo");
        }
    }

    private int findSameType(String string) {
        int n = this.contextStack.size() - 1;
        int n2 = 0;
        while (n >= 0) {
            ContextElement contextElement = (ContextElement)this.contextStack.get(n);
            if (!string.equals(contextElement.elementName)) break;
            --n;
            ++n2;
        }
        return n2;
    }

    private void pushContext(Object object) {
        ContextElement contextElement = new ContextElement((String)this.currentElement.peek(), object);
        this.contextStack.push(contextElement);
    }

    private ContextElement popupContext() {
        ContextElement contextElement = (ContextElement)this.contextStack.pop();
        return contextElement;
    }

    private boolean addFeatureInfo(List list, MBeanFeatureInfo mBeanFeatureInfo, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addFeatureInfo", mBeanFeatureInfo);
        }
        boolean bl2 = false;
        String string = mBeanFeatureInfo.getName();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            MBeanFeatureInfo mBeanFeatureInfo2 = (MBeanFeatureInfo)list.get(i);
            bl2 = mBeanFeatureInfo2.getName().equals(string);
            if (bl2 && mBeanFeatureInfo instanceof MBeanOperationInfo) {
                MBeanParameterInfo[] mBeanParameterInfoArray;
                MBeanParameterInfo[] mBeanParameterInfoArray2 = ((MBeanOperationInfo)mBeanFeatureInfo2).getSignature();
                bl2 = mBeanParameterInfoArray2.length == (mBeanParameterInfoArray = ((MBeanOperationInfo)mBeanFeatureInfo).getSignature()).length;
                for (int j = 0; bl2 && j < mBeanParameterInfoArray.length; ++j) {
                    if (mBeanParameterInfoArray2[j].getType().equals(mBeanParameterInfoArray[j].getType())) continue;
                    bl2 = false;
                    break;
                }
            }
            if (!bl2) continue;
            if (!bl) break;
            list.set(i, mBeanFeatureInfo);
            break;
        }
        if (!bl2) {
            list.add(mBeanFeatureInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addFeatureInfo," + bl2);
        }
        return bl2;
    }

    private class ContextElement {
        public String elementName;
        public Object value;

        public ContextElement(String string, Object object) {
            this.elementName = string;
            this.value = object;
        }

        public String toString() {
            return "elementName:" + this.elementName + ",value:" + this.value;
        }
    }
}

