/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.descriptor;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.exception.DescriptorParseException;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminInitializer;
import com.ibm.ws.management.MBeanExtensions;
import com.ibm.ws.management.descriptor.MBeanDescriptorLoader;
import com.ibm.ws.management.descriptor.MBeanDescriptorLoader2;
import com.ibm.ws.management.descriptor.WsDescriptorSupport;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.xml.sax.InputSource;

public class MBeanDescriptorManager {
    private static MBeanDescriptorManager instance = null;
    private static String resourceBundleName = "com.ibm.ws.management.resources.adminservice";
    private static TraceNLS nls = TraceNLS.getTraceNLS(resourceBundleName);
    private static TraceComponent tc = Tr.register(MBeanDescriptorManager.class, "MBeanFactory", resourceBundleName);
    private DescriptorClassLoader descriptorClassLoader;
    private List mbeanDescriptorBundles = new ArrayList();
    private HashMap infoCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MBeanDescriptorManager getInstance() {
        if (instance == null) {
            Class clazz = MBeanDescriptorManager.class;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new MBeanDescriptorManager();
                }
                try {
                    instance.loadMasterDescriptorFile("com/ibm/ws/management/descriptor/xml/mbeans.xml");
                }
                catch (DescriptorParseException descriptorParseException) {
                    descriptorParseException.printStackTrace(System.out);
                }
            }
        }
        return instance;
    }

    private MBeanDescriptorManager() {
        this.descriptorClassLoader = new DescriptorClassLoader();
        this.obtainMBeanProviders();
    }

    private void obtainMBeanProviders() {
        IExtensionRegistry iExtensionRegistry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        if (iExtensionRegistry == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Extension registry is null");
            }
            return;
        }
        String string = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".mbean-provider";
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(string);
        if (iExtensionPoint == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Extension point, " + string + ", not found");
            }
            return;
        }
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        for (int i = 0; i < iExtensionArray.length; ++i) {
            this.mbeanDescriptorBundles.add(Platform.getBundle((String)iExtensionArray[i].getNamespace()));
        }
    }

    public synchronized ModelMBeanInfo getDescriptor(String string, String string2) throws DescriptorParseException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDescriptor", string);
        }
        ModelMBeanInfo modelMBeanInfo = null;
        Object v = this.infoCache.get(string);
        if (v == null) {
            modelMBeanInfo = this.loadDescriptorFile(string, string2);
            this.infoCache.put(string, modelMBeanInfo);
        } else {
            modelMBeanInfo = (ModelMBeanInfo)this.deepClone((ModelMBeanInfo)v);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDescriptor", modelMBeanInfo);
        }
        return modelMBeanInfo;
    }

    public synchronized void removeDescriptor(String string) {
        if (string != null && string.length() > 0) {
            Object v = this.infoCache.remove(string);
            if (tc.isDebugEnabled()) {
                if (v != null) {
                    Tr.debug(tc, "Descriptor of mbean type " + string + " removed from the cache");
                } else {
                    Tr.debug(tc, "Descriptor of mbean type " + string + " not in the cache");
                }
            }
        }
    }

    public synchronized ModelMBeanInfo getDescriptor(String string, String string2, byte[] byArray) throws DescriptorParseException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDescriptor", new Object[]{string, string2, byArray});
        }
        ModelMBeanInfo modelMBeanInfo = null;
        Object v = this.infoCache.get(string);
        if (v == null) {
            MBeanDescriptorLoader mBeanDescriptorLoader = new MBeanDescriptorLoader();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            modelMBeanInfo = mBeanDescriptorLoader.loadDescriptor(byteArrayInputStream, string2);
            this.infoCache.put(string, modelMBeanInfo);
        } else {
            modelMBeanInfo = (ModelMBeanInfo)v;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDescriptor", modelMBeanInfo);
        }
        return new ModelMBeanInfoSupport(modelMBeanInfo);
    }

    private InputStream getResourceAsStream(final String string) {
        Iterator iterator = this.mbeanDescriptorBundles.iterator();
        InputStream inputStream = null;
        while (iterator.hasNext() && inputStream == null) {
            final Bundle bundle = (Bundle)iterator.next();
            URL uRL = (URL)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return bundle.getResource(string);
                }
            });
            if (uRL == null) continue;
            try {
                inputStream = uRL.openStream();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.descriptor.MBeanDescriptorManager.getResourceAsStream", "221", this);
            }
        }
        if (inputStream == null) {
            return Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        }
        return inputStream;
    }

    public InputSource loadMBeanDescriptorFile(String string, String string2) {
        Object object;
        InputStream inputStream;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadMBeanDescriptorFile", new Object[]{string, string2});
        }
        String string3 = string2;
        if (string2 == null) {
            string3 = "com/ibm/ws/management/descriptor/xml/" + string + ".xml";
        }
        if ((inputStream = this.getResourceAsStream(string3)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "can not find the system descriptor file", string3);
            }
            if (string2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "consult the MBeanExtension for descriptor file");
                }
                object = AdminInitializer.getInstance().getMBeanExtensions();
                string3 = ((MBeanExtensions)object).getDescriptorUri(string);
                List list = ((MBeanExtensions)object).getClasspath(string);
                if (string3 != null) {
                    String[] stringArray = list.toArray(new String[0]);
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.descriptorClassLoader.addPath(stringArray[i]);
                    }
                    inputStream = this.descriptorClassLoader.getResourceAsStream(string3);
                }
            }
        }
        object = new InputSource(inputStream);
        ((InputSource)object).setSystemId(string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadMBeanDescriptorFile", object);
        }
        return object;
    }

    public InputSource loadSecurityDescriptorFile(String string, String string2) {
        Object object;
        InputStream inputStream;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadSecurityDescriptorFile", new Object[]{string, string2});
        }
        String string3 = string2;
        if (string2 == null) {
            string3 = "com/ibm/ws/management/descriptor/xml/" + string + "Security.xml";
        }
        if ((inputStream = this.getResourceAsStream(string3)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "can not find the system descriptor file", string3);
            }
            if (string2 == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "consult the MBeanExtension for descriptor file");
                }
                object = AdminInitializer.getInstance().getMBeanExtensions();
                string3 = ((MBeanExtensions)object).getDescriptorUri(string);
                List list = ((MBeanExtensions)object).getClasspath(string);
                if (string3 != null) {
                    string3 = this.toSecurityMBeanDescriptor(string3);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Trying MBeanExtension security descriptor file:" + string3);
                    }
                    String[] stringArray = list.toArray(new String[0]);
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.descriptorClassLoader.addPath(stringArray[i]);
                    }
                    inputStream = this.descriptorClassLoader.getResourceAsStream(string3);
                }
            }
        }
        object = new InputSource(inputStream);
        ((InputSource)object).setSystemId(string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadSecurityDescriptorFile", object);
        }
        return object;
    }

    private String toSecurityMBeanDescriptor(String string) {
        int n = string.lastIndexOf(".xml");
        string = n == -1 ? string + "Security" : string.substring(0, n) + "Security.xml";
        return string;
    }

    public ModelMBeanInfo loadDescriptorFile(String string, String string2) throws DescriptorParseException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadDescriptorFile", string2);
        }
        InputSource inputSource = this.loadMBeanDescriptorFile(string, string2);
        InputStream inputStream = inputSource.getByteStream();
        String string3 = inputSource.getSystemId();
        if (inputStream == null) {
            throw new DescriptorParseException(new FileNotFoundException(string3), string3);
        }
        MBeanDescriptorLoader mBeanDescriptorLoader = new MBeanDescriptorLoader();
        ModelMBeanInfo modelMBeanInfo = mBeanDescriptorLoader.loadDescriptor(inputStream, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadDescriptorFile", string3);
        }
        return modelMBeanInfo;
    }

    public synchronized void loadMasterDescriptorFile(String string) throws DescriptorParseException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadMasterDescriptorFile", string);
        }
        MBeanDescriptorLoader2 mBeanDescriptorLoader2 = new MBeanDescriptorLoader2();
        InputStream inputStream = this.getResourceAsStream(string);
        mBeanDescriptorLoader2.load(inputStream, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadMasterDescriptorFile", string);
        }
    }

    void populateCache(String string, ModelMBeanInfo modelMBeanInfo) {
        this.infoCache.put(string, modelMBeanInfo);
    }

    protected Object deepClone(ModelMBeanInfo modelMBeanInfo) {
        Object object;
        int n;
        Object object2;
        ModelMBeanAttributeInfo[] modelMBeanAttributeInfoArray = null;
        ModelMBeanConstructorInfo[] modelMBeanConstructorInfoArray = null;
        ModelMBeanNotificationInfo[] modelMBeanNotificationInfoArray = null;
        ModelMBeanOperationInfo[] modelMBeanOperationInfoArray = null;
        Descriptor descriptor = null;
        if (modelMBeanInfo.getAttributes() != null) {
            object2 = modelMBeanInfo.getAttributes();
            modelMBeanAttributeInfoArray = new ModelMBeanAttributeInfo[((MBeanAttributeInfo[])object2).length];
            for (n = 0; n < ((MBeanFeatureInfo[])object2).length; ++n) {
                object = object2[n];
                modelMBeanAttributeInfoArray[n] = object instanceof ModelMBeanAttributeInfo ? new ModelMBeanAttributeInfo((ModelMBeanAttributeInfo)object) : new ModelMBeanAttributeInfo(((MBeanFeatureInfo)object).getName(), ((MBeanAttributeInfo)object).getType(), ((MBeanFeatureInfo)object).getDescription(), ((MBeanAttributeInfo)object).isReadable(), ((MBeanAttributeInfo)object).isWritable(), ((MBeanAttributeInfo)object).isIs());
            }
        }
        if (modelMBeanInfo.getConstructors() != null) {
            object2 = modelMBeanInfo.getConstructors();
            modelMBeanConstructorInfoArray = new ModelMBeanConstructorInfo[((MBeanFeatureInfo[])object2).length];
            for (n = 0; n < ((MBeanFeatureInfo[])object2).length; ++n) {
                object = object2[n];
                modelMBeanConstructorInfoArray[n] = new ModelMBeanConstructorInfo(((MBeanFeatureInfo)object).getName(), ((MBeanFeatureInfo)object).getDescription(), ((MBeanConstructorInfo)object).getSignature());
            }
        }
        if (modelMBeanInfo.getOperations() != null) {
            object2 = modelMBeanInfo.getOperations();
            modelMBeanOperationInfoArray = new ModelMBeanOperationInfo[((MBeanFeatureInfo[])object2).length];
            for (n = 0; n < ((Object)object2).length; ++n) {
                object = object2[n];
                modelMBeanOperationInfoArray[n] = object instanceof ModelMBeanOperationInfo ? new ModelMBeanOperationInfo((ModelMBeanOperationInfo)object) : new ModelMBeanOperationInfo(((MBeanFeatureInfo)object).getName(), ((MBeanFeatureInfo)object).getDescription(), ((MBeanOperationInfo)object).getSignature(), ((MBeanOperationInfo)object).getReturnType(), ((MBeanOperationInfo)object).getImpact());
            }
        }
        if (modelMBeanInfo.getNotifications() != null) {
            object2 = modelMBeanInfo.getNotifications();
            modelMBeanNotificationInfoArray = new ModelMBeanNotificationInfo[((MBeanFeatureInfo[])object2).length];
            for (n = 0; n < ((Object)object2).length; ++n) {
                object = object2[n];
                modelMBeanNotificationInfoArray[n] = object instanceof ModelMBeanNotificationInfo ? new ModelMBeanNotificationInfo((ModelMBeanNotificationInfo)object) : new ModelMBeanNotificationInfo(((MBeanNotificationInfo)object).getNotifTypes(), ((MBeanFeatureInfo)object).getName(), ((MBeanFeatureInfo)object).getDescription());
            }
        }
        try {
            object2 = modelMBeanInfo.getMBeanDescriptor();
            if (object2 == null) {
                this.createDefaultDescriptor(modelMBeanInfo);
            } else {
                descriptor = (Descriptor)object2.clone();
            }
        }
        catch (MBeanException mBeanException) {
            this.createDefaultDescriptor(modelMBeanInfo);
        }
        return new ModelMBeanInfoSupport(modelMBeanInfo.getClassName(), modelMBeanInfo.getDescription(), modelMBeanAttributeInfoArray, modelMBeanConstructorInfoArray, modelMBeanOperationInfoArray, modelMBeanNotificationInfoArray, descriptor);
    }

    private Descriptor createDefaultDescriptor(ModelMBeanInfo modelMBeanInfo) {
        WsDescriptorSupport wsDescriptorSupport = null;
        wsDescriptorSupport = new WsDescriptorSupport(new String[]{"name=" + modelMBeanInfo.getClassName(), "descriptorType=mbean", "displayName=" + modelMBeanInfo.getClassName(), "persistPolicy=never", "log=F", "visibility=1"});
        return wsDescriptorSupport;
    }

    public Class loadCollaboratorClass(String string) {
        Class clazz = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadCollaboratorClass " + string);
        }
        try {
            clazz = Class.forName(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "collaborator " + string + " loaded");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = Class.forName(string, true, (ClassLoader)ExtClassLoader.getInstance());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "collaborator " + string + " loaded by external class loader");
                }
            }
            catch (ClassNotFoundException classNotFoundException2) {
                clazz = this.loadCollaboratorClassFromBundle(string);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.descriptor.MBeanDescriptorManager.loadCollaboratorClass", "600", this);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.descriptor.MBeanDescriptorManager.loadCollaboratorClass", "620", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadCollaboratorClass loaded? " + Boolean.toString(clazz != null));
        }
        if (clazz == null) {
            throw new RuntimeException("manager unable to load proxy collaborator class " + string);
        }
        return clazz;
    }

    private Class loadCollaboratorClassFromBundle(final String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadCollaboratorClassFromBundle " + string);
        }
        Iterator iterator = this.mbeanDescriptorBundles.iterator();
        Class clazz = null;
        while (iterator.hasNext() && clazz == null) {
            final Bundle bundle = (Bundle)iterator.next();
            clazz = (Class)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    Object var1_1 = null;
                    try {
                        bundle.loadClass(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    return var1_1;
                }
            });
            if (clazz == null || !tc.isDebugEnabled()) continue;
            Tr.debug(tc, "collaborator " + string + " loaded from bundle " + bundle.getBundleId());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadCollaboratorClassFromBundle loaded? " + Boolean.toString(clazz != null));
        }
        return clazz;
    }

    class DescriptorClassLoader
    extends URLClassLoader {
        private ArrayList descriptorPath;

        DescriptorClassLoader() {
            super(new URL[0]);
            this.descriptorPath = new ArrayList();
        }

        public void addPath(String string) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "addPath", string);
            }
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    File file = new File(stringTokenizer.nextToken());
                    try {
                        file = file.getCanonicalFile();
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.descriptor.MBeanDescriptorManager.DescriptorClassLoader.addPath", "210", this);
                    }
                    try {
                        URL uRL = file.toURL();
                        if (this.descriptorPath.contains(uRL)) continue;
                        this.descriptorPath.add(uRL);
                        super.addURL(uRL);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.descriptor.MBeanDescriptorManager.DescriptorClassLoader.addPath", "221", this);
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addPath", string);
            }
        }
    }
}

