/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.management.discovery.DiscoveryEvent;
import com.ibm.ws.management.discovery.DiscoveryListener;
import com.ibm.ws.management.discovery.DiscoveryService;
import com.ibm.ws.management.discovery.Endpoint;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.discovery.protocol.EndpointAdv;
import com.ibm.ws.management.discovery.protocol.FeaturePackAdv;
import com.ibm.ws.management.discovery.protocol.MUdpAdv;
import com.ibm.ws.management.discovery.protocol.PeerAdv;
import com.ibm.ws.management.discovery.protocol.ServiceAdv;
import com.ibm.ws.management.discovery.protocol.TcpAdv;
import com.ibm.ws.management.discovery.protocol.TransportAdvertisement;
import com.ibm.ws.management.discovery.protocol.UdpAdv;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class DiscoveryAdapter
implements DiscoveryListener {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register(DiscoveryAdapter.class, "Admin", "com.ibm.ws.management.resources.discovery");
    private TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.discovery");
    private DiscoveryService discoveryService;
    protected PeerAdv peerAdv;
    protected ServerInfo serverInfo;
    private Endpoint endpoint;
    private HashSet queryIds = new HashSet();
    private boolean initialized = false;

    public DiscoveryAdapter(ServerInfo serverInfo, String string, int n) {
        this(serverInfo, string, n, null);
    }

    public DiscoveryAdapter(ServerInfo serverInfo, String string, int n, String string2) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "DiscoveryAdapter");
        }
        this.serverInfo = serverInfo;
        String string3 = null;
        String string4 = null;
        Object var7_7 = null;
        List list = this.serverInfo.getEndPoints();
        if (list.size() > 0) {
            object = (Properties)list.get(0);
            string3 = ((Properties)object).getProperty("host");
            if (string3.indexOf(58) > -1 && string3.indexOf(91) < 0) {
                string3 = "[" + string3 + "]";
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "can not get the local hostname - no endpoints in server info");
            }
            string3 = "localhost";
        }
        if (string2 != null && string2.length() > 0) {
            if (string2.indexOf(58) > -1 && string2.indexOf(91) < 0) {
                string2 = "[" + string2 + "]";
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Warning: multicast address is not provided");
        }
        object = null;
        String string5 = null;
        if (n == 1) {
            string5 = "tcp";
            object = new TcpAdv(string, string5, string3, string3);
            string4 = string5 + "://" + string3 + ":" + string;
        } else if (n == 0) {
            string5 = "udp";
            object = new UdpAdv(string, string5, string3, string3);
            string4 = string5 + "://" + string3 + ":" + string;
        } else if (n == 2) {
            string5 = "mudp";
            object = new MUdpAdv(string5, string2, string);
            string4 = string5 + "://" + string2 + ":" + string;
        }
        EndpointAdv endpointAdv = new EndpointAdv(string5, string4, (TransportAdvertisement)object);
        ServiceAdv serviceAdv = new ServiceAdv("AdminService", this.serverInfo.getServices());
        FeaturePackAdv featurePackAdv = new FeaturePackAdv();
        this.peerAdv = new PeerAdv(this.serverInfo, serviceAdv, endpointAdv, featurePackAdv);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DiscoveryAdapter");
        }
    }

    public boolean initialize(ThreadPoolMgr threadPoolMgr) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        if (this.initialized) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize - already done");
            }
            return false;
        }
        boolean bl = this.initializeEndpoint(threadPoolMgr);
        this.initializeDiscoveryService();
        this.initialized = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
        return bl;
    }

    private boolean initializeEndpoint(ThreadPoolMgr threadPoolMgr) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeEndpoint");
        }
        EndpointAdv endpointAdv = this.peerAdv.getEndpointAdv();
        this.endpoint = new Endpoint(endpointAdv);
        boolean bl = this.endpoint.initialize(threadPoolMgr);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeEndpoint");
        }
        return bl;
    }

    private void initializeDiscoveryService() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeDiscoveryService");
        }
        this.discoveryService = new DiscoveryService(this.serverInfo, this.endpoint, this.peerAdv);
        this.discoveryService.addDiscoveryListener(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeDiscoveryService");
        }
    }

    protected abstract void updateRoutingTable(ServerInfo var1);

    protected boolean qualifyQueryId(long l, String string) {
        if (string.equals("ManagedProcess")) {
            return this.containQueryId(l);
        }
        return this.removeQueryId(l);
    }

    protected boolean unqualifyQueryId(long l, String string) {
        if (string.equals("ManagedProcess")) {
            return false;
        }
        return this.removeQueryId(l);
    }

    public void event(DiscoveryEvent discoveryEvent) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "event");
        }
        if ((n = discoveryEvent.getState()) == DiscoveryEvent.SENDING) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "sending event...");
            }
            this.saveQueryId(discoveryEvent.getQueryId());
        } else if (n == DiscoveryEvent.ROLLBACK) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "rollback discovery...");
            }
            this.removeQueryId(discoveryEvent.getQueryId());
        } else if (n == DiscoveryEvent.RECEIVED) {
            boolean bl = discoveryEvent.isQuery();
            long l = discoveryEvent.getQueryId();
            PeerAdv peerAdv = discoveryEvent.getRemotePeerAdv();
            String string = peerAdv.getRole();
            PeerAdv peerAdv2 = discoveryEvent.getRemotePeerAdv();
            ServerInfo serverInfo = new ServerInfo(peerAdv2.getPid(), peerAdv2.getCell(), peerAdv2.getNode(), peerAdv2.getName(), peerAdv2.getRole(), peerAdv2.getVersion(), peerAdv2.getServiceAdv().getAccessMethods());
            if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "it's a query event");
                }
                this.updateRoutingTable(serverInfo);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "it's a response event");
                }
                if (this.qualifyQueryId(l, string)) {
                    this.updateRoutingTable(serverInfo);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "event - unrecognized response");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "event");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveQueryId(long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveQueryId: " + l);
        }
        HashSet hashSet = this.queryIds;
        synchronized (hashSet) {
            this.queryIds.add(new Long(l));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveQueryId");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeQueryId(long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeQueryId: " + l);
        }
        boolean bl = false;
        HashSet hashSet = this.queryIds;
        synchronized (hashSet) {
            bl = this.queryIds.remove(new Long(l));
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeQueryId: " + bl);
        }
        return bl;
    }

    protected boolean containQueryId(long l) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "containQueryId: " + l);
            Iterator iterator = this.queryIds.iterator();
            while (iterator.hasNext()) {
                Tr.debug(tc, "id:  " + (Long)iterator.next());
            }
        }
        return this.queryIds.contains(new Long(l));
    }

    public void discovery(String string, String string2, int n, ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "discovery", new Object[]{string, string2, serverInfo});
        }
        EndpointAddress endpointAddress = new EndpointAddress(n, string, string2, "DiscoveryService");
        DiscoveryTask discoveryTask = new DiscoveryTask(endpointAddress, serverInfo, 0L);
        AlarmManager.createNonDeferrable(50L, new DiscoveryAlarm(discoveryTask), this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "discovery");
        }
    }

    protected Properties convertConnectorNameToProperties(String string) {
        Properties properties = new Properties();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";=");
        while (stringTokenizer.hasMoreTokens()) {
            properties.setProperty(stringTokenizer.nextToken(), stringTokenizer.nextToken());
        }
        return properties;
    }

    class DiscoveryTask {
        EndpointAddress destination;
        ServerInfo target;
        long sequence;
        long queryId;
        boolean isSet;

        DiscoveryTask(EndpointAddress endpointAddress, ServerInfo serverInfo, long l) {
            this.destination = endpointAddress;
            this.target = serverInfo;
            this.sequence = l;
            this.isSet = false;
        }

        EndpointAddress getDestination() {
            return this.destination;
        }

        ServerInfo getTarget() {
            return this.target;
        }

        long getSequence() {
            return this.sequence;
        }

        void setSequence(long l) {
            this.sequence = l;
        }

        long getQueryId() {
            return this.queryId;
        }

        void setQueryId(long l) {
            this.queryId = l;
            this.isSet = true;
        }

        boolean isSet() {
            return this.isSet;
        }
    }

    class DiscoveryAlarm
    implements AlarmListener {
        DiscoveryTask task;

        DiscoveryAlarm(DiscoveryTask discoveryTask) {
            this.task = discoveryTask;
        }

        public void alarm(Object object) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "DiscoveryAlarm.alarm");
            }
            DiscoveryAdapter discoveryAdapter = (DiscoveryAdapter)object;
            if (this.task.isSet()) {
                long l = this.task.getQueryId();
                if (discoveryAdapter.unqualifyQueryId(l, this.task.getTarget().getRole())) {
                    this.runIt();
                }
            } else {
                this.runIt();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "DiscoveryAlarm.alarm");
            }
        }

        void runIt() {
            long l;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "runIt");
            }
            if ((l = DiscoveryAdapter.this.discoveryService.sendQuery(this.task.getDestination(), this.task.getTarget())) != -1L) {
                this.task.setQueryId(l);
                DiscoveryAdapter.this.saveQueryId(l);
            }
            long l2 = 2L * this.task.getSequence() + 1L;
            this.task.setSequence(l2);
            AlarmManager.createNonDeferrable(l2 * 60L * 1000L, new DiscoveryAlarm(this.task), DiscoveryAdapter.this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "runIt");
            }
        }
    }
}

