/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.RoutingListener;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.discovery.ServerInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;

public class DiscoveryMBean
extends RuntimeCollaborator
implements RoutingListener {
    private static TraceComponent tc = Tr.register(DiscoveryMBean.class, "Admin", "com.ibm.ws.management.resources.discovery");
    private static long ntfySeqNum = 0L;
    private String childType;
    private String parentType;
    private String myType;
    private ServerInfo parent;
    private ArrayList children = new ArrayList();

    public DiscoveryMBean() {
        this.myType = AdminServiceFactory.getAdminService().getProcessType();
        if (this.myType.equals("DeploymentManager")) {
            this.childType = "NodeAgent";
        } else if (this.myType.equals("NodeAgent")) {
            this.childType = "ManagedProcess";
            this.parentType = "DeploymentManager";
        } else if (this.myType.equals("ManagedProcess")) {
            this.parentType = "NodeAgent";
        }
    }

    public ServerInfo getParent() {
        return this.parent;
    }

    public List getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void childAdded(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "childAdded");
        }
        String string = serverInfo.getName();
        String string2 = serverInfo.getPid();
        String string3 = serverInfo.getVersion();
        Notification notification = new Notification("websphere.discovery.process.found", this.getObjectName(), ntfySeqNum++);
        Properties properties = new Properties();
        properties.setProperty("processName", string);
        properties.setProperty("nodeName", serverInfo.getNode());
        properties.setProperty("processId", string2);
        properties.setProperty("version", string3);
        notification.setUserData(properties);
        if (this.childType.equals("NodeAgent")) {
            string = serverInfo.getNode();
        }
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            if (!this.children.contains(string)) {
                this.children.add(string);
            }
        }
        Tr.info(tc, "ADMD0023I", new Object[]{string, this.childType, string2});
        try {
            this.sendNotification(notification);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, "com.ibm.ws.management.discovery.DiscoveryMBean.childAdded", "86", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "childAdded");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void childRemoved(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "childRemoved");
        }
        String string = serverInfo.getName();
        Notification notification = new Notification("websphere.discovery.process.lost", this.getObjectName(), ntfySeqNum++);
        Properties properties = new Properties();
        properties.setProperty("processName", string);
        properties.setProperty("nodeName", serverInfo.getNode());
        notification.setUserData(properties);
        if (this.childType.equals("NodeAgent")) {
            string = serverInfo.getNode();
        }
        ArrayList arrayList = this.children;
        synchronized (arrayList) {
            this.children.remove(string);
        }
        try {
            this.sendNotification(notification);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, "com.ibm.ws.management.discovery.DiscoveryMBean.childRemoved", "115", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "childRemoved");
        }
    }

    public void parentAdded(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parentAdded");
        }
        this.parent = serverInfo;
        String string = serverInfo.getName();
        String string2 = RoutingTable.getInstance().getPid(string);
        Notification notification = new Notification("websphere.discovery.agent.found", this.getObjectName(), ntfySeqNum++);
        notification.setUserData(serverInfo);
        Tr.info(tc, "ADMD0023I", new Object[]{string, this.parentType, string2});
        try {
            this.sendNotification(notification);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, "com.ibm.ws.management.discovery.DiscoveryMBean.parentAdded", "109", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parentAdded");
        }
    }

    public void parentRemoved(ServerInfo serverInfo) {
    }

    public void query(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "query", serverInfo);
        }
        String string = serverInfo.getRole();
        if (this.myType.equals("ManagedProcess") && string.equals("NodeAgent")) {
            RoutingTable.getInstance().addParent(serverInfo);
            this.answerDiscovery(serverInfo);
        } else if (this.myType.equals("NodeAgent") && string.equals("ManagedProcess")) {
            RoutingTable.getInstance().addChild(serverInfo);
            this.answerDiscovery(serverInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "query");
        }
    }

    public void respond(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "respond", serverInfo);
        }
        String string = serverInfo.getRole();
        if (this.myType.equals("NodeAgent")) {
            if (string.equals("ManagedProcess")) {
                RoutingTable.getInstance().addChild(serverInfo);
            }
        } else if (this.myType.equals("ManagedProcess") && string.equals("NodeAgent")) {
            RoutingTable.getInstance().addParent(serverInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "responsd");
        }
    }

    private void answerDiscovery(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "answerDiscovery");
        }
        AdminClient adminClient = null;
        try {
            adminClient = serverInfo.getAdminClient();
        }
        catch (ConnectorException connectorException) {
            FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.discovery.DiscoveryMBean.answerDiscovery", "227", this);
            Tr.warning(tc, "ADMD0024W", serverInfo.getName());
        }
        if (adminClient != null) {
            Object object;
            ObjectName objectName = null;
            ObjectName objectName2 = null;
            try {
                object = serverInfo.getName();
                objectName2 = new ObjectName("*:*,type=Discovery,process=" + (String)object);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                // empty catch block
            }
            try {
                object = adminClient.queryNames(objectName2, null);
                if (object.iterator().hasNext()) {
                    objectName = (ObjectName)object.iterator().next();
                    adminClient.invoke(objectName, "respond", new Object[]{RoutingTable.getInstance().getOwnInfo()}, new String[]{ServerInfo.class.getName()});
                } else {
                    Tr.warning(tc, "ADMD0024W", serverInfo.getName());
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.discovery.DiscoveryMBean.answerDiscovery", "259", this);
                Tr.warning(tc, "ADMD0024W", serverInfo.getName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "answerDiscovery");
        }
    }
}

