/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminInitializer;
import com.ibm.ws.management.discovery.DiscoveryEvent;
import com.ibm.ws.management.discovery.DiscoveryListener;
import com.ibm.ws.management.discovery.Endpoint;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.EndpointMessenger;
import com.ibm.ws.management.discovery.Message;
import com.ibm.ws.management.discovery.QueryHandler;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.discovery.exception.DiscardQueryException;
import com.ibm.ws.management.discovery.exception.InvalidEndpointAddressException;
import com.ibm.ws.management.discovery.protocol.DiscoveryQueryMsg;
import com.ibm.ws.management.discovery.protocol.DiscoveryResponseMsg;
import com.ibm.ws.management.discovery.protocol.PeerAdv;
import com.ibm.ws.management.discovery.protocol.XMLDocument;
import com.ibm.ws.management.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;

public class DiscoveryService
implements QueryHandler {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register(DiscoveryService.class, "Admin", "com.ibm.ws.management.resources.discovery");
    private TraceNLS nls;
    private static long querySerialNumber = 1L;
    private static HashSet unresolvableHosts = new HashSet();
    private Endpoint endpoint;
    private PeerAdv advertisement;
    private EndpointAddress serviceAddress;
    private ServerInfo serverInfo;
    private String adminType;
    private String cellName;
    private String nodeName;
    Vector discoveryListeners;

    public DiscoveryService(ServerInfo serverInfo, Endpoint endpoint, PeerAdv peerAdv) {
        block4: {
            this.nls = TraceNLS.getTraceNLS(bundleName);
            this.discoveryListeners = new Vector();
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "DiscoveryService");
            }
            this.serverInfo = serverInfo;
            this.endpoint = endpoint;
            this.advertisement = peerAdv;
            Properties properties = AdminInitializer.getInstance().getProperties();
            this.adminType = (String)properties.get("adminTypeProperty");
            this.cellName = (String)properties.get("cellNameConfigProperty");
            this.nodeName = (String)properties.get("nodeNameConfigProperty");
            try {
                this.serviceAddress = new EndpointAddress(endpoint.getEndpointAddress().getURI() + "DiscoveryService");
            }
            catch (InvalidEndpointAddressException invalidEndpointAddressException) {
                FFDCFilter.processException((Throwable)invalidEndpointAddressException, "com.ibm.ws.management.discovery.DiscoveryService.DiscoveryService", "61", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "invalide endpoint address", invalidEndpointAddressException);
            }
        }
        endpoint.registerHandler("DiscoveryService", this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "DiscoveryService");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiscoveryListener(DiscoveryListener discoveryListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addDiscoveryListener");
        }
        Vector vector = this.discoveryListeners;
        synchronized (vector) {
            this.discoveryListeners.addElement(discoveryListener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addDiscoveryListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDiscoveryListener(DiscoveryListener discoveryListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeDiscoveryListener");
        }
        Vector vector = this.discoveryListeners;
        synchronized (vector) {
            this.discoveryListeners.removeElement(discoveryListener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeDiscoveryListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sendQuery(EndpointAddress endpointAddress, ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "sendQuery");
        }
        long l = 0L;
        DiscoveryService discoveryService = this;
        synchronized (discoveryService) {
            l = querySerialNumber++;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Query Id Number: " + l + " Query Serial Number: " + querySerialNumber);
        }
        boolean bl = true;
        if (endpointAddress != null) {
            Object object;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "End-2-end messaging: queryId: " + l);
            }
            Message message = null;
            try {
                object = new DiscoveryQueryMsg(0, l, serverInfo, this.advertisement);
                message = new Message(((DiscoveryQueryMsg)object).getXMLDocument().getInputStream(), this.serviceAddress, endpointAddress);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "message[src, dest]", new Object[]{this.serviceAddress, endpointAddress});
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.discovery.DiscoveryService.sendQuery", "116", this);
                Tr.warning(tc, "ADMD0007W", exception.getMessage());
                l = -1L;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "sendQuery: " + l);
                }
                return l;
            }
            object = null;
            try {
                object = this.endpoint.getMessenger(endpointAddress);
                if (object != null) {
                    Object object2 = this.copyListener();
                    DiscoveryEvent discoveryEvent = new DiscoveryEvent(this, DiscoveryEvent.SENDING, l);
                    for (int i = 0; i < ((DiscoveryListener[])object2).length; ++i) {
                        object2[i].event(discoveryEvent);
                    }
                    object.sendMessage(message);
                }
            }
            catch (UnknownHostException unknownHostException) {
                FFDCFilter.processException((Throwable)unknownHostException, "com.ibm.ws.management.discovery.DiscoveryService.sendQuery", "151", this);
                l = -1L;
                bl = false;
                String string = endpointAddress.getProtocolHost();
                if (!unresolvableHosts.contains(string)) {
                    unresolvableHosts.add(string);
                    Tr.warning(tc, "ADMD0022W", new Object[]{string});
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.discovery.DiscoveryService.sendQuery", "165", this);
                l = -1L;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "IOExceiption occurs while sending messages", iOException);
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.discovery.DiscoveryService.sendQuery", "174", this);
                DiscoveryListener[] discoveryListenerArray = this.copyListener();
                DiscoveryEvent discoveryEvent = new DiscoveryEvent(this, DiscoveryEvent.ROLLBACK, l);
                for (int i = 0; i < discoveryListenerArray.length; ++i) {
                    discoveryListenerArray[i].event(discoveryEvent);
                }
                l = -1L;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unable to send out the discovery query message", throwable);
                }
            }
            finally {
                String string;
                if (bl && unresolvableHosts.contains(string = endpointAddress.getProtocolHost())) {
                    unresolvableHosts.remove(string);
                }
                if (object != null) {
                    object.close();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "sendQuery: " + l);
        }
        return l;
    }

    public DiscoveryResponseMsg processQuery(XMLDocument xMLDocument) throws DiscardQueryException, IOException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processQuery");
        }
        DiscoveryQueryMsg discoveryQueryMsg = null;
        DiscoveryResponseMsg discoveryResponseMsg = null;
        try {
            discoveryQueryMsg = new DiscoveryQueryMsg(xMLDocument);
            object2 = discoveryQueryMsg.getPeerAdv();
            String string = Utils.getProductVersion();
            String string2 = ((PeerAdv)object2).getVersion();
            String string3 = ((PeerAdv)object2).getNode();
            object = ((PeerAdv)object2).getRole();
            int n = Utils.compareVersions(string, string2);
            if (this.adminType.equals("DeploymentManager") && n < 0) {
                Tr.error(tc, "ADMD0026W", new Object[]{string, string3 + ", " + string2});
                throw new DiscardQueryException("The version of the Deployment Manager (" + string + ") is earlier than that of the nodeagent (" + string2 + ")");
            }
            if (!((String)object).equals("ManagedProcess") && this.adminType.equals("NodeAgent") && n > 0) {
                Tr.error(tc, "ADMD0026W", new Object[]{string2, this.nodeName + ", " + string});
                throw new DiscardQueryException("The version of the Deployment Manager (" + string2 + ") is earlier than that of the nodeagent (" + string + ")");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.discovery.DiscoveryService.processQuery", "156", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processQuery - can not rebuild the query", exception);
            }
            throw new DiscardQueryException("can not read the query document");
        }
        object2 = discoveryQueryMsg.getServerInfo();
        if (((ServerInfo)object2).match(this.serverInfo)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "role matched", new Object[]{object2, this.serverInfo});
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processQuery - role not matched", new Object[]{object2, this.serverInfo});
            }
            throw new DiscardQueryException("role not matched");
        }
        int n = discoveryQueryMsg.getDiscoveryType();
        long l = discoveryQueryMsg.getQueryId();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "query Id = " + l);
        }
        if (l <= 0L) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "processQuery: discardQuery");
            }
            throw new DiscardQueryException("No queryId included with the query message");
        }
        object = discoveryQueryMsg.getPeerAdv();
        DiscoveryListener[] discoveryListenerArray = this.copyListener();
        DiscoveryEvent discoveryEvent = new DiscoveryEvent(this, (PeerAdv)object, l, true);
        for (int i = 0; i < discoveryListenerArray.length; ++i) {
            discoveryListenerArray[i].event(discoveryEvent);
        }
        ServerInfo serverInfo = new ServerInfo(((PeerAdv)object).getCell(), ((PeerAdv)object).getNode(), ((PeerAdv)object).getRole());
        discoveryResponseMsg = new DiscoveryResponseMsg(0, l, serverInfo, this.advertisement);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processQuery");
        }
        return discoveryResponseMsg;
    }

    public void pushResponse(XMLDocument xMLDocument) {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pushResponse");
        }
        DiscoveryResponseMsg discoveryResponseMsg = null;
        try {
            discoveryResponseMsg = new DiscoveryResponseMsg(xMLDocument);
            object2 = discoveryResponseMsg.getResponse();
            String string = Utils.getProductVersion();
            String string2 = ((PeerAdv)object2).getVersion();
            String string3 = ((PeerAdv)object2).getNode();
            object = ((PeerAdv)object2).getRole();
            int n = Utils.compareVersions(string, string2);
            if (this.adminType.equals("DeploymentManager") && n < 0) {
                Tr.error(tc, "ADMD0026W", new Object[]{string, string3 + ", " + string2});
                throw new DiscardQueryException("The version of the Deployment Manager (" + string + ") is earlier than that of the nodeagent (" + string2 + ")");
            }
            if (!((String)object).equals("ManagedProcess") && this.adminType.equals("NodeAgent") && n > 0) {
                Tr.error(tc, "ADMD0026W", new Object[]{string2, this.nodeName + ", " + string});
                throw new DiscardQueryException("The version of the Deployment Manager (" + string2 + ") is earlier than that of the nodeagent (" + string + ")");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.discovery.DiscoveryService.pushResponse", "263", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "pushResponse - failed");
            }
            return;
        }
        object2 = discoveryResponseMsg.getServerInfo();
        if (((ServerInfo)object2).match(this.serverInfo)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "role matched", new Object[]{object2, this.serverInfo});
            }
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "role not matched", new Object[]{object2, this.serverInfo});
            }
            return;
        }
        int n = discoveryResponseMsg.getDiscoveryType();
        long l = discoveryResponseMsg.getQueryId();
        object = discoveryResponseMsg.getResponse();
        DiscoveryListener[] discoveryListenerArray = this.copyListener();
        DiscoveryEvent discoveryEvent = new DiscoveryEvent(this, (PeerAdv)object, l, false);
        for (int i = 0; i < discoveryListenerArray.length; ++i) {
            discoveryListenerArray[i].event(discoveryEvent);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pushResponse");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void respond(EndpointAddress endpointAddress, DiscoveryResponseMsg discoveryResponseMsg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "respond");
        }
        Message message = null;
        try {
            message = new Message(discoveryResponseMsg.getXMLDocument().getInputStream(), this.serviceAddress, endpointAddress);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "message[src, dest]", new Object[]{this.serviceAddress, endpointAddress});
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.discovery.DiscoveryService.respond", "256", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to send out the discovery response message", exception);
            }
            Tr.warning(tc, "ADMD0008W", exception.getMessage());
        }
        EndpointMessenger endpointMessenger = null;
        try {
            endpointMessenger = this.endpoint.getMessenger(endpointAddress);
            endpointMessenger.sendMessage(message);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.discovery.DiscoveryService.respond", "266", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to send out the discovery response message", iOException);
            }
        }
        finally {
            if (endpointMessenger != null) {
                endpointMessenger.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "respond");
        }
    }

    public void demux(Message message) {
        block21: {
            Object object;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "demux");
            }
            XMLDocument xMLDocument = null;
            EndpointAddress endpointAddress = message.getSourceAddress();
            try {
                object = message.getDataInputStream();
                xMLDocument = new XMLDocument((InputStream)object);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.discovery.DiscoveryService.demux", "315", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to create an XML document from the message", exception);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "demux");
                }
                return;
            }
            if (xMLDocument == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The discovery document is null");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "demux");
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "the incoming discovery message is: ", xMLDocument);
            }
            object = xMLDocument.getDocumentElement();
            String string = object.getTagName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "the opening tag is " + string);
            }
            if (string.equalsIgnoreCase("jxta:DiscoveryQuery")) {
                try {
                    DiscoveryResponseMsg discoveryResponseMsg = this.processQuery(xMLDocument);
                    if (discoveryResponseMsg != null) {
                        this.respond(endpointAddress, discoveryResponseMsg);
                    }
                    break block21;
                }
                catch (DiscardQueryException discardQueryException) {
                    FFDCFilter.processException((Throwable)discardQueryException, "com.ibm.ws.management.discovery.DiscoveryService.demux", "344", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "the query discarded");
                    }
                    break block21;
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.discovery.DiscoveryService.demux", "347", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "IO error occurs while processing the query", iOException);
                    }
                    break block21;
                }
            }
            if (string.equalsIgnoreCase("jxta:DiscoveryResponse")) {
                this.pushResponse(xMLDocument);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unsupported discovery message", string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "demux");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiscoveryListener[] copyListener() {
        Vector vector = this.discoveryListeners;
        synchronized (vector) {
            return this.discoveryListeners.toArray(new DiscoveryListener[0]);
        }
    }
}

