/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.EndpointMessenger;
import com.ibm.ws.management.discovery.Message;
import com.ibm.ws.management.discovery.QueryHandler;
import com.ibm.ws.management.discovery.exception.InvalidEndpointAddressException;
import com.ibm.ws.management.discovery.protocol.EndpointAdv;
import com.ibm.ws.management.discovery.protocol.MUdpAdv;
import com.ibm.ws.management.discovery.protocol.TcpAdv;
import com.ibm.ws.management.discovery.protocol.TransportAdvertisement;
import com.ibm.ws.management.discovery.protocol.UdpAdv;
import com.ibm.ws.management.discovery.transport.MUdpTransport;
import com.ibm.ws.management.discovery.transport.TcpTransport;
import com.ibm.ws.management.discovery.transport.TransportProtocol;
import com.ibm.ws.management.discovery.transport.UdpTransport;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;

public class Endpoint {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register(Endpoint.class, "Admin", "com.ibm.ws.management.resources.discovery");
    private Hashtable handlers = new Hashtable();
    private Hashtable transports = new Hashtable();
    private TransportProtocol primaryTransport;
    private EndpointAdv epadv;
    private String name;
    private EndpointAddress address;
    private ThreadPoolMgr tpMgr;

    public Endpoint(EndpointAdv endpointAdv) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Endpoint");
        }
        this.epadv = endpointAdv;
        this.name = endpointAdv.getName();
        try {
            this.address = new EndpointAddress(endpointAdv.getEndpointAddress().trim());
        }
        catch (InvalidEndpointAddressException invalidEndpointAddressException) {
            FFDCFilter.processException((Throwable)invalidEndpointAddressException, "com.ibm.ws.management.discovery.Endpoint.Endpoint", "61", this);
            Tr.error(tc, "ADMD0010E");
            return;
        }
        TransportAdvertisement transportAdvertisement = endpointAdv.getTransportAdvertisement();
        String string = transportAdvertisement.getProtocol();
        if (string.equalsIgnoreCase("TCP")) {
            TcpTransport tcpTransport = new TcpTransport((TcpAdv)transportAdvertisement);
            this.addProtocol(tcpTransport);
        } else if (string.equalsIgnoreCase("UDP")) {
            UdpTransport udpTransport = new UdpTransport((UdpAdv)transportAdvertisement);
            this.addProtocol(udpTransport);
        } else if (string.equalsIgnoreCase("MUDP")) {
            MUdpTransport mUdpTransport = new MUdpTransport((MUdpAdv)transportAdvertisement);
            this.addProtocol(mUdpTransport);
        } else {
            Tr.error(tc, "ADMD0011E");
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Endpoint");
        }
    }

    public ThreadPoolMgr getThreadPoolMgr() {
        return this.tpMgr;
    }

    public boolean initialize(ThreadPoolMgr threadPoolMgr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        boolean bl = true;
        this.tpMgr = threadPoolMgr;
        Enumeration enumeration = this.transports.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TransportProtocol transportProtocol = (TransportProtocol)enumeration.nextElement();
            if (tc.isDebugEnabled() && ++n > 1) {
                Tr.debug(tc, "There are " + n + " protocols for this Endpoint.");
            }
            try {
                bl = transportProtocol.init(this);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.discovery.Endpoint.initialize", "101", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to initilize the transport", exception);
                }
                bl = false;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
        return bl;
    }

    public void demux(Message message) {
        EndpointAddress endpointAddress;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "demux");
        }
        if (!this.addressMatched(endpointAddress = message.getDestinationAddress())) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "the incoming message is not for this endpoint", new Object[]{endpointAddress, this.address});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "demux - failed");
            }
            return;
        }
        String string = endpointAddress.getServiceName();
        if (string == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The message doesn't specify the target service");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "demux - failed");
            }
            return;
        }
        QueryHandler queryHandler = this.lookupHandler(string);
        if (queryHandler == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No handler is found for the incoming message", string);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "demux - failed");
            }
            return;
        }
        queryHandler.demux(message);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "demux");
        }
    }

    public synchronized void registerHandler(String string, QueryHandler queryHandler) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "registerHandler", string);
        }
        this.handlers.put(string, queryHandler);
    }

    public synchronized QueryHandler lookupHandler(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "lookupHandler", string);
        }
        return (QueryHandler)this.handlers.get(string);
    }

    public void addProtocol(TransportProtocol transportProtocol) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addProtocol: " + transportProtocol.getProtocolName());
        }
        if (this.primaryTransport == null) {
            this.primaryTransport = transportProtocol;
        }
        this.transports.put(transportProtocol.getProtocolName(), transportProtocol);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addProtocol");
        }
    }

    public TransportProtocol getProtocol(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getProtocol", string);
        }
        return (TransportProtocol)this.transports.get(string);
    }

    public EndpointAddress getEndpointAddress() {
        return this.address;
    }

    public EndpointMessenger getMessenger(EndpointAddress endpointAddress) throws IOException {
        return this.primaryTransport.getMessenger(endpointAddress);
    }

    private boolean addressMatched(EndpointAddress endpointAddress) {
        boolean bl;
        block7: {
            String string;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "addressMatched", endpointAddress);
            }
            if ((bl = endpointAddress.getProtocolName().equalsIgnoreCase(this.address.getProtocolName())) && !endpointAddress.getProtocolAddress().equalsIgnoreCase(this.address.getProtocolAddress()) && !(string = endpointAddress.getProtocolHost()).equals("127.0.0.1")) {
                String string2 = this.address.getProtocolHost();
                try {
                    if (!InetAddress.getByName(string).equals(InetAddress.getByName(string2))) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "target host does not match local host", new Object[]{string, string2});
                        }
                        bl = false;
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug(tc, "can not get host inetaddress", unknownHostException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addressMatched", new Boolean(bl));
        }
        return bl;
    }
}

