/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.discovery.exception.InvalidEndpointAddressException;

public class EndpointAddress {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register(EndpointAddress.class, "Admin", "com.ibm.ws.management.resources.discovery");
    private String protocol;
    private String protocolHost;
    private String protocolPort;
    private String serviceName;
    private boolean unified = true;
    private boolean warningIssued = false;

    public EndpointAddress() {
    }

    public EndpointAddress(int n, String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "EndpointAddress", new Object[]{new Integer(n), string, string2});
        }
        if (n == 1) {
            this.protocol = "TCP";
        } else if (n == 0) {
            this.protocol = "UDP";
        } else if (n == 2) {
            this.protocol = "MUDP";
        }
        this.serviceName = string3;
        if (string.indexOf(58) > -1 && string.indexOf(91) < 0) {
            string = "[" + string + "]";
        }
        this.protocolHost = string;
        this.protocolPort = string2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "EndpointAddress");
        }
    }

    public EndpointAddress(String string, String string2, String string3, String string4) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "EndpointAddress", new Object[]{string, string2, string3});
        }
        this.protocol = string;
        this.serviceName = string4;
        if (string2.indexOf(58) > -1 && string2.indexOf(91) < 0) {
            string2 = "[" + string2 + "]";
        }
        this.protocolHost = string2;
        this.protocolPort = string3;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "EndpointAddress");
        }
    }

    public EndpointAddress(String string) throws InvalidEndpointAddressException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "EndpointAddress", string);
        }
        this.parse(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "EndpointAddress");
        }
    }

    private String unifyHost(String string) {
        return string;
    }

    private void parse(String string) throws InvalidEndpointAddressException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parse", string);
        }
        int n = string.indexOf("://");
        String string2 = null;
        if (n == -1) {
            throw new InvalidEndpointAddressException(string);
        }
        this.protocol = string.substring(0, n);
        string2 = string.substring(n + 3);
        this.parse1(string2);
    }

    private void parse1(String string) {
        int n = string.indexOf("/");
        String string2 = null;
        int n2 = string.indexOf(93);
        if (n2 < 0) {
            n2 = 0;
        }
        if (n == -1) {
            int n3 = string.indexOf(58, n2);
            if (n3 != -1) {
                this.protocolHost = this.unifyHost(string.substring(0, n3));
                this.protocolPort = string.substring(n3 + 1);
            } else {
                this.protocolHost = this.unifyHost(string);
            }
        } else {
            String string3 = string.substring(0, n);
            int n4 = string3.indexOf(58, n2);
            if (n4 != -1) {
                this.protocolHost = this.unifyHost(string3.substring(0, n4));
                this.protocolPort = string3.substring(n4 + 1);
            } else {
                this.protocolHost = this.unifyHost(string3);
            }
            string2 = string.substring(n + 1);
            n = string2.indexOf("/");
            this.serviceName = n == -1 ? string2 : string2.substring(0, n);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "protocol = " + this.protocol + " host = " + this.protocolHost + "port = " + this.protocolPort + " service = " + this.serviceName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parse");
        }
    }

    public String getProtocolName() {
        return this.protocol;
    }

    public void setProtocolName(String string) {
        this.protocol = string;
    }

    public String getProtocolAddress() {
        if (this.protocolPort != null) {
            return this.getProtocolHost() + ":" + this.protocolPort;
        }
        return this.getProtocolHost();
    }

    public String getProtocolHost() {
        if (!this.unified) {
            this.protocolHost = this.unifyHost(this.protocolHost);
        }
        return this.protocolHost;
    }

    public String getProtocolPort() {
        return this.protocolPort;
    }

    public void setProtocolAddress(String string) {
        this.parse1(string);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String string) {
        this.serviceName = string;
    }

    public String getURI() {
        if (this.serviceName != null) {
            return this.protocol + "://" + this.protocolHost + ":" + this.protocolPort + "/" + this.serviceName;
        }
        return this.protocol + "://" + this.protocolHost + ":" + this.protocolPort + "/";
    }

    public String toString() {
        return this.getURI();
    }
}

