/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.exception.InvalidEndpointAddressException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;

public class Message {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register(Message.class, "Admin", "com.ibm.ws.management.resources.discovery");
    public static final String XMLEncoding = "<?xml version=\"1.0\"  standalone='yes'?>";
    public static final String DestinationTagStart = "<JxtaMessageDest>";
    public static final String DestinationTagEnd = "</JxtaMessageDest>";
    public static final String SourceTagStart = "<JxtaMessageSrc>";
    public static final String SourceTagEnd = "</JxtaMessageSrc>";
    public static final String DigestTagStart = "<JxtaMessageDigest>";
    public static final String DigestTagEnd = "</JxtaMessageDigest>";
    private InputStream stream;
    private InputStream headerStream;
    private InputStream dataStream;
    private EndpointAddress source;
    private EndpointAddress destination;

    public Message(InputStream inputStream) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Message(InputStream)");
        }
        this.dataStream = inputStream;
        this.headerStream = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Message(InputStream)");
        }
    }

    public Message(InputStream inputStream, EndpointAddress endpointAddress, EndpointAddress endpointAddress2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Message(InputStream, EndpointAddress, EndpointAddress)");
        }
        this.source = endpointAddress;
        this.destination = endpointAddress2;
        this.dataStream = inputStream;
        this.pushHeader(this.source, this.destination);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Message(InputStream,EndpointAddress, EndpointAddress)");
        }
    }

    public Message(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Message(byte[])");
        }
        this.stream = new ByteArrayInputStream(byArray);
        this.extractHeader(byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Message(byte[])");
        }
    }

    public Message(byte[] byArray, int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Message(byte[], int, int)");
        }
        this.stream = new ByteArrayInputStream(byArray, n, n2);
        this.extractHeader(byArray, n, n2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Message(byte[], int, int)");
        }
    }

    private void pushHeader(EndpointAddress endpointAddress, EndpointAddress endpointAddress2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pushHeader(source, destination)", new Object[]{endpointAddress, endpointAddress2});
        }
        String string = "<?xml version=\"1.0\"  standalone='yes'?><JxtaMessageDest>" + endpointAddress2.toString() + DestinationTagEnd + SourceTagStart + endpointAddress.toString() + SourceTagEnd;
        this.headerStream = new ByteArrayInputStream(string.getBytes());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "header byte size: " + string.getBytes().length);
        }
        this.stream = new SequenceInputStream(this.headerStream, this.dataStream);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pushHeader(source, destination)");
        }
    }

    private void extractHeader(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractHeader(byte[])");
        }
        this.extractHeader(byArray, 0, byArray.length);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractHeader(byte[])");
        }
    }

    private void extractHeader(byte[] byArray, int n, int n2) {
        int n3;
        String string;
        int n4;
        block34: {
            block33: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "extractHeader(byte[], int, int)");
                }
                n4 = -1;
                for (int i = n; i < byArray.length; ++i) {
                    if (byArray[i] != 60) continue;
                    n4 = i;
                    break;
                }
                if (n4 == -1) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No XML tag within the message");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "extractHeader - incomplete");
                    }
                    return;
                }
                string = new String(byArray, n4, XMLEncoding.length());
                if (!string.equals(XMLEncoding)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "only XML encoding accepted");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "extractHeader - incomplete");
                    }
                    return;
                }
                string = new String(byArray, n4 += XMLEncoding.length(), DestinationTagStart.length());
                if (!string.equals(DestinationTagStart)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid message: Destination Start Tag not found");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "extractHeader - incomplete");
                    }
                    return;
                }
                n3 = n4 += DestinationTagStart.length();
                for (n3 = n4; n3 < byArray.length && byArray[n3] != 60; ++n3) {
                }
                if (n3 == byArray.length) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Invalid message; Destination End Tag not found");
                    }
                    return;
                }
                try {
                    this.destination = new EndpointAddress(new String(byArray, n4, n3 - n4));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "message targeting", this.destination);
                    }
                }
                catch (InvalidEndpointAddressException invalidEndpointAddressException) {
                    FFDCFilter.processException((Throwable)invalidEndpointAddressException, "com.ibm.ws.management.discovery.Message.extractHeader", "161", this);
                    if (!tc.isDebugEnabled()) break block33;
                    Tr.debug(tc, "Invalid message: destination address format error", invalidEndpointAddressException);
                }
            }
            n4 = n3;
            string = new String(byArray, n4, DestinationTagEnd.length());
            if (!string.equals(DestinationTagEnd)) {
                this.destination = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid message: Destination End Tag not found");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "extractHeader - incomplete");
                }
                return;
            }
            string = new String(byArray, n4 += DestinationTagEnd.length(), SourceTagStart.length());
            if (!string.equals(SourceTagStart)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invalid message : Source Start Tag not found");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "extractHeader - incomplete");
                }
                return;
            }
            n3 = n4 += SourceTagStart.length();
            for (n3 = n4; n3 < byArray.length && byArray[n3] != 60; ++n3) {
            }
            if (n3 == byArray.length) {
                Tr.warning(tc, "ADMD0013W");
                return;
            }
            try {
                this.source = new EndpointAddress(new String(byArray, n4, n3 - n4));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "message coming from", this.source);
                }
            }
            catch (InvalidEndpointAddressException invalidEndpointAddressException) {
                FFDCFilter.processException((Throwable)invalidEndpointAddressException, "com.ibm.ws.management.discovery.Message.extractHeader", "204", this);
                if (!tc.isDebugEnabled()) break block34;
                Tr.debug(tc, "Invalid message: source address format error", invalidEndpointAddressException);
            }
        }
        n4 = n3;
        string = new String(byArray, n4, SourceTagEnd.length());
        if (!string.equals(SourceTagEnd)) {
            this.source = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invalid message invalid : not Source End Tag");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "extractHeader - incomplete");
            }
            return;
        }
        n4 += SourceTagEnd.length();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "data stream starting at " + (n4 - n));
        }
        this.dataStream = new ByteArrayInputStream(byArray, n4, n2 + n - n4);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractHeader(byte[], int, int)");
        }
    }

    public InputStream getInputStream() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getInputStream");
        }
        if (this.headerStream == null) {
            this.pushHeader(this.source, this.destination);
        }
        return this.stream;
    }

    public InputStream getDataInputStream() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getDataInputStream");
        }
        return this.dataStream;
    }

    public EndpointAddress getDestinationAddress() {
        return this.destination;
    }

    public EndpointAddress getSourceAddress() {
        return this.source;
    }

    public void setDestinationAddress(EndpointAddress endpointAddress) {
        this.destination = endpointAddress;
    }

    public void setSourceAddress(EndpointAddress endpointAddress) {
        this.source = endpointAddress;
    }
}

