/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.protocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.discovery.protocol.Advertisement;
import com.ibm.ws.management.discovery.protocol.MUdpAdv;
import com.ibm.ws.management.discovery.protocol.TcpAdv;
import com.ibm.ws.management.discovery.protocol.TransportAdvertisement;
import com.ibm.ws.management.discovery.protocol.UdpAdv;
import com.ibm.ws.management.discovery.protocol.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EndpointAdv
implements Advertisement {
    private static TraceComponent tc = Tr.register(EndpointAdv.class);
    private String name = null;
    private TransportAdvertisement transport = null;
    private String endpointAddress = null;

    public EndpointAdv(String string, String string2, TransportAdvertisement transportAdvertisement) {
        this.name = string;
        this.endpointAddress = string2;
        this.transport = transportAdvertisement;
    }

    public EndpointAdv(Element element) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "EndpointAdv(Element)");
        }
        this.initialize(element.getElementsByTagName(this.getAdvertisementType()).item(0));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "EndpointAdv(Element)");
        }
    }

    private void initialize(Node node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2 instanceof Element && tc.isDebugEnabled()) {
                Tr.debug(tc, "Node name = " + node2.getNodeName() + " value = " + node2.getFirstChild().getNodeValue());
            }
            if (node2.getNodeName().equals("Name")) {
                this.setName(node2.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (node2.getNodeName().equals("Address")) {
                this.setEndpointAddress(node2.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (!node2.getNodeName().equals("Transport")) continue;
            for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                if (node3.getNodeName().equalsIgnoreCase("jxta:TCPTransportAdvertisement")) {
                    this.setTransportAdvertisement(new TcpAdv((Element)node3));
                    continue;
                }
                if (node3.getNodeName().equalsIgnoreCase("jxta:UDPTransportAdvertisement")) {
                    this.setTransportAdvertisement(new UdpAdv((Element)node3));
                    continue;
                }
                if (!node3.getNodeName().equalsIgnoreCase("jxta:MUDPTransportAdvertisement")) continue;
                this.setTransportAdvertisement(new MUdpAdv((Element)node3));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public String getAdvertisementType() {
        return "jxta:EndpointAdvertisement";
    }

    public XMLDocument getXMLDocument() {
        XMLDocument xMLDocument = null;
        try {
            xMLDocument = new XMLDocument(this.getAdvertisementType());
            Element element = null;
            if (this.getName() != null) {
                element = xMLDocument.createElement("Name", this.getName());
                xMLDocument.appendChild(element);
            }
            if (this.getEndpointAddress() != null) {
                element = xMLDocument.createElement("Address", this.getEndpointAddress());
                xMLDocument.appendChild(element);
            }
            element = xMLDocument.createElement("Transport");
            xMLDocument.appendChild(element);
            TransportAdvertisement transportAdvertisement = this.getTransportAdvertisement();
            XMLDocument xMLDocument2 = transportAdvertisement.getXMLDocument();
            xMLDocument.copyElements(xMLDocument2, element);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.discovery.EndpointAdv.getXMLDocument", "120", this);
            exception.printStackTrace();
        }
        return xMLDocument;
    }

    public String getName() {
        return this.name;
    }

    private void setName(String string) {
        this.name = string;
    }

    public TransportAdvertisement getTransportAdvertisement() {
        return this.transport;
    }

    private void setTransportAdvertisement(TransportAdvertisement transportAdvertisement) {
        this.transport = transportAdvertisement;
    }

    public String getEndpointAddress() {
        return this.endpointAddress;
    }

    private void setEndpointAddress(String string) {
        this.endpointAddress = string;
    }
}

