/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.protocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.discovery.protocol.TcpAdv;
import com.ibm.ws.management.discovery.protocol.TransportAdvertisement;
import com.ibm.ws.management.discovery.protocol.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MUdpAdv
extends TransportAdvertisement {
    private static TraceComponent tc = Tr.register(TcpAdv.class);
    protected String protocol = null;
    protected String port = null;
    private String multicastAddr = null;

    public MUdpAdv(String string, String string2, String string3) {
        this.protocol = string;
        this.port = string3;
        this.multicastAddr = string2;
    }

    public MUdpAdv(Element element) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "MUdpAdv(Element)");
        }
        this.initialize(element);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "MUdpAdv(Element)");
        }
    }

    private void initialize(Node node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2 instanceof Element && tc.isDebugEnabled()) {
                Tr.debug(tc, "Node name = " + node2.getNodeName() + " value = " + node2.getFirstChild().getNodeValue());
            }
            if (node2.getNodeName().equalsIgnoreCase("Protocol")) {
                this.setProtocol(node2.getFirstChild().getNodeValue());
                continue;
            }
            if (node2.getNodeName().equals("Port")) {
                this.setPort(node2.getFirstChild().getNodeValue().trim());
                continue;
            }
            if (!node2.getNodeName().equals("MulticastAddr")) continue;
            this.setMulticastAddr(node2.getFirstChild().getNodeValue().trim());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public XMLDocument getXMLDocument() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXMLDocument");
        }
        XMLDocument xMLDocument = null;
        try {
            xMLDocument = new XMLDocument(this.getAdvertisementType());
            Element element = null;
            if (this.getProtocol() != null) {
                element = xMLDocument.createElement("Protocol", this.getProtocol());
                xMLDocument.appendChild(element);
            }
            if (this.getPort() != null) {
                element = xMLDocument.createElement("Port", this.getPort());
                xMLDocument.appendChild(element);
            }
            if (this.getMulticastAddr() != null) {
                element = xMLDocument.createElement("MulticastAddr", this.getMulticastAddr());
                xMLDocument.appendChild(element);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.discovery.MUdpAdv.getXMLDocument", "105", this);
            exception.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXMLDocument");
        }
        return xMLDocument;
    }

    public String getAdvertisementType() {
        return "jxta:MUDPTransportAdvertisement";
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String string) {
        this.port = string;
    }

    public String getMulticastAddr() {
        return this.multicastAddr;
    }

    public void setMulticastAddr(String string) {
        this.multicastAddr = string;
    }
}

