/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.protocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.discovery.protocol.Advertisement;
import com.ibm.ws.management.discovery.protocol.EndpointAdv;
import com.ibm.ws.management.discovery.protocol.FeaturePackAdv;
import com.ibm.ws.management.discovery.protocol.ServiceAdv;
import com.ibm.ws.management.discovery.protocol.XMLDocument;
import java.util.Properties;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PeerAdv
implements Advertisement {
    private static TraceComponent tc = Tr.register(PeerAdv.class);
    private String name = null;
    private String pid = null;
    private String cell = null;
    private String node = null;
    private String role = null;
    private String version = null;
    private EndpointAdv endpointAdv = null;
    private ServiceAdv serviceAdv = null;
    private FeaturePackAdv featurePackAdv = null;

    public String getAdvertisementType() {
        return "jxta:PeerAdvertisement";
    }

    public PeerAdv() {
    }

    public PeerAdv(ServerInfo serverInfo, ServiceAdv serviceAdv, EndpointAdv endpointAdv, FeaturePackAdv featurePackAdv) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "PeerAdv", new Object[]{serverInfo, serviceAdv, endpointAdv, featurePackAdv});
        }
        this.name = serverInfo.getName();
        this.pid = serverInfo.getPid();
        this.cell = serverInfo.getCell();
        this.node = serverInfo.getNode();
        this.role = serverInfo.getRole();
        this.version = serverInfo.getVersion();
        this.serviceAdv = serviceAdv;
        this.endpointAdv = endpointAdv;
        this.featurePackAdv = featurePackAdv;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "PeerAdv");
        }
    }

    public PeerAdv(ServerInfo serverInfo, ServiceAdv serviceAdv, EndpointAdv endpointAdv) {
        this(serverInfo, serviceAdv, endpointAdv, null);
    }

    public PeerAdv(Element element) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "PeerAdv(Element)");
        }
        this.initialize(element);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "PeerAdv(Element)");
        }
    }

    public void initialize(Node node) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", node);
        }
        block0: for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2 instanceof Element && tc.isDebugEnabled()) {
                Tr.debug(tc, "Node name = " + node2.getNodeName() + " value = " + node2.getFirstChild().getNodeValue());
            }
            if (node2.getNodeName().equals("Name")) {
                this.name = node2.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (node2.getNodeName().equals("Pid")) {
                this.pid = node2.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (node2.getNodeName().equals("Version")) {
                this.version = node2.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (node2.getNodeName().equals("Cell")) {
                this.cell = node2.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (node2.getNodeName().equals("Node")) {
                this.node = node2.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (node2.getNodeName().equals("Role")) {
                this.role = node2.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (node2.getNodeName().equals("Service")) {
                this.serviceAdv = new ServiceAdv((Element)node2);
                continue;
            }
            if (node2.getNodeName().equals("Endpoint")) {
                this.endpointAdv = new EndpointAdv((Element)node2);
                continue;
            }
            if (!node2.getNodeName().equals("FeaturePack")) continue;
            NodeList nodeList = node2.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node3 = nodeList.item(i);
                if (!(node3 instanceof Element)) continue;
                this.featurePackAdv = new FeaturePackAdv((Element)node3);
                continue block0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public XMLDocument getXMLDocument() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXMLDocument");
        }
        XMLDocument xMLDocument = new XMLDocument(this.getAdvertisementType());
        Element element = null;
        if (this.getName() != null) {
            element = xMLDocument.createElement("Name", this.getName());
            xMLDocument.appendChild(element);
        }
        if (this.getPid() != null) {
            element = xMLDocument.createElement("Pid", this.getPid());
            xMLDocument.appendChild(element);
        }
        if (this.getVersion() != null) {
            element = xMLDocument.createElement("Version", this.getVersion());
            xMLDocument.appendChild(element);
        }
        if (this.getCell() != null) {
            element = xMLDocument.createElement("Cell", this.getCell());
            xMLDocument.appendChild(element);
        }
        if (this.getNode() != null) {
            element = xMLDocument.createElement("Node", this.getNode());
            xMLDocument.appendChild(element);
        }
        if (this.getCell() != null) {
            element = xMLDocument.createElement("Role", this.getRole());
            xMLDocument.appendChild(element);
        }
        element = xMLDocument.createElement("Endpoint");
        EndpointAdv endpointAdv = this.getEndpointAdv();
        XMLDocument xMLDocument2 = endpointAdv.getXMLDocument();
        xMLDocument.copyElements(xMLDocument2, element);
        xMLDocument.appendChild(element);
        element = xMLDocument.createElement("Service");
        ServiceAdv serviceAdv = this.getServiceAdv();
        xMLDocument2 = serviceAdv.getXMLDocument();
        xMLDocument.copyElements(xMLDocument2, element);
        xMLDocument.appendChild(element);
        element = xMLDocument.createElement("FeaturePack");
        FeaturePackAdv featurePackAdv = this.getFeaturePackAdv();
        xMLDocument2 = featurePackAdv.getXMLDocument();
        xMLDocument.copyElements(xMLDocument2, element);
        xMLDocument.appendChild(element);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXMLDocument");
        }
        return xMLDocument;
    }

    public String getName() {
        return this.name;
    }

    public String getPid() {
        return this.pid;
    }

    public String getCell() {
        return this.cell;
    }

    public String getNode() {
        return this.node;
    }

    public String getRole() {
        return this.role;
    }

    public EndpointAdv getEndpointAdv() {
        return this.endpointAdv;
    }

    public ServiceAdv getServiceAdv() {
        return this.serviceAdv;
    }

    public void setServiceAdv(ServiceAdv serviceAdv) {
        this.serviceAdv = serviceAdv;
    }

    public FeaturePackAdv getFeaturePackAdv() {
        return this.featurePackAdv;
    }

    public void setFeaturePackAdv(FeaturePackAdv featurePackAdv) {
        this.featurePackAdv = featurePackAdv;
    }

    public String toString() {
        Properties properties = new Properties();
        properties.setProperty("Name", this.getName());
        properties.setProperty("Cell", this.getCell());
        properties.setProperty("Node", this.getNode());
        properties.setProperty("Role", this.getRole());
        properties.setProperty("FeaturePackON", this.getFeaturePackAdv() == null ? "" : this.getFeaturePackAdv().getFeaturePackVersions().toString());
        return properties.toString();
    }

    public String getVersion() {
        return this.version;
    }
}

