/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.protocol;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XMLDocument {
    private static TraceComponent tc = Tr.register(XMLDocument.class);
    protected Document xmlDoc;

    public XMLDocument() {
    }

    public XMLDocument(String string) throws Exception {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            DOMImplementation dOMImplementation = document.getImplementation();
            DocumentType documentType = dOMImplementation.createDocumentType(string, null, null);
            this.xmlDoc = dOMImplementation.createDocument("http://www.jxta.org/jxta", string, documentType);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.discovery.XMLDocument.XMLDocument", "59", this);
            this.xmlDoc = null;
            throw exception;
        }
    }

    public XMLDocument(InputStream inputStream) throws Exception {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(false);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.xmlDoc = documentBuilder.parse(new InputSource(inputStream));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.discovery.XMLDocument.XMLDocument", "86", this);
            this.xmlDoc = null;
            throw exception;
        }
    }

    public Element createElement(String string) {
        return this.xmlDoc.createElement(string);
    }

    public Element createElement(String string, String string2) {
        Element element = this.xmlDoc.createElement(string);
        if (null != string2) {
            element.appendChild(this.xmlDoc.createTextNode(string2));
        }
        return element;
    }

    public void appendChild(Element element) {
        this.getDocumentElement().appendChild(element);
    }

    public void copyElements(XMLDocument xMLDocument, Element element) {
        this.copyElements(this, xMLDocument.getDocumentElement(), element);
    }

    private void copyElements(XMLDocument xMLDocument, Node node, Element element) {
        String string = node.getNodeName();
        String string2 = node.getNodeValue();
        if (node.getFirstChild().getNodeType() == 3) {
            string2 = node.getFirstChild().getNodeValue();
        }
        String string3 = null;
        if (string2 != null && string2 instanceof String) {
            string3 = string2;
        }
        Element element2 = xMLDocument.createElement(string, string3);
        element.appendChild(element2);
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (!(node2 instanceof Element)) continue;
            this.copyElements(xMLDocument, node2, element2);
        }
    }

    public InputStream getInputStream() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStream");
        }
        try {
            StringWriter stringWriter = new StringWriter();
            this.sendToWriter(stringWriter);
            String string = stringWriter.toString();
            int n = string.length();
            char[] cArray = new char[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '\n' || c == '\r') continue;
                cArray[n2] = c;
                ++n2;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getStream - successful");
            }
            return new ByteArrayInputStream(String.valueOf(cArray, 0, n2).getBytes("UTF-8"));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.discovery.XMLDocument.getInputStream", "189", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getStream - failed");
            }
            return null;
        }
    }

    public void sendToStream(OutputStream outputStream) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        this.sendToWriter(bufferedWriter);
        ((Writer)bufferedWriter).flush();
    }

    public Reader getReader() {
        try {
            StringWriter stringWriter = new StringWriter();
            this.sendToWriter(stringWriter);
            return new StringReader(stringWriter.toString());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.discovery.XMLDocument.getReader", "222", this);
            return null;
        }
    }

    public void sendToWriter(Writer writer) throws IOException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            Properties properties = new Properties();
            properties.put("method", "xml");
            properties.put("omit-xml-declaration", "no");
            properties.put("version", "1.0");
            properties.put("encoding", "UTF-8");
            properties.put("indent", "yes");
            transformer.setOutputProperties(properties);
            transformer.transform(new DOMSource(this.xmlDoc), new StreamResult(writer));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.discovery.XMLDocument.sendToWriter", "242", this);
            throw new IOException(exception.toString());
        }
    }

    public Element getDocumentElement() {
        return this.xmlDoc.getDocumentElement();
    }

    public String getName() {
        return this.getDocumentElement().getNodeName();
    }

    public String toString() {
        DOMSource dOMSource = new DOMSource(this.xmlDoc);
        StreamResult streamResult = new StreamResult(new StringWriter());
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            FFDCFilter.processException(transformerException, "com.ibm.ws.management.discovery.XMLDocument.toString", "280");
        }
        return streamResult.getWriter().toString();
    }
}

