/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.EndpointMessenger;
import com.ibm.ws.management.discovery.transport.MUdpMessenger;
import com.ibm.ws.management.discovery.transport.TcpMessenger;
import com.ibm.ws.management.discovery.transport.TcpTransport;
import com.ibm.ws.management.discovery.transport.TransportProtocol;
import com.ibm.ws.management.discovery.transport.UdpMessenger;
import java.io.IOException;

public class MessengerFactory {
    private static TraceComponent tc = Tr.register(TcpTransport.class);

    public static EndpointMessenger createMessenger(EndpointAddress endpointAddress, TransportProtocol transportProtocol) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMessenger", new Object[]{endpointAddress, transportProtocol.getProtocolName()});
        }
        String string = endpointAddress.getProtocolName();
        EndpointMessenger endpointMessenger = null;
        if (string.equalsIgnoreCase("TCP")) {
            endpointMessenger = new TcpMessenger(endpointAddress, transportProtocol);
        } else if (string.equalsIgnoreCase("UDP")) {
            endpointMessenger = new UdpMessenger(endpointAddress, transportProtocol);
        } else if (string.equalsIgnoreCase("MUDP")) {
            endpointMessenger = new MUdpMessenger(endpointAddress, transportProtocol);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createMessenger");
        }
        return endpointMessenger;
    }
}

