/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.discovery.Endpoint;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.discovery.transport.UdpConnection;
import com.ibm.ws.management.discovery.transport.UdpServer;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.management.util.Utils;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.util.ObjectPool;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class MulticastServer
extends UdpServer {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register(MulticastServer.class, "Admin", "com.ibm.ws.management.resources.discovery");
    private MulticastSocket serverSocket;
    private EndpointAddress mAddress;
    private InetAddress group;
    private String defaultAddr = "232.133.104.73";
    private int multicastSize;
    private boolean alive;
    private Thread acceptThread = null;
    private Endpoint endpoint;
    private static NodeAgentConnector nodeAgentConnector;
    private static boolean rediscover_called;
    private static String SLEEP_INTERVAL_PROPERTY;
    private static String ATTEMPTS_THRESHOLD_PROPERTY;

    public MulticastServer(Endpoint endpoint) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "MulticastServer");
        }
        this.endpoint = endpoint;
        ThreadPoolMgr threadPoolMgr = endpoint.getThreadPoolMgr();
        int n = 2;
        String string = System.getProperty("com.ibm.websphere.management.processDiscoveryThreads");
        if (string != null) {
            n = new Integer(string);
        }
        this.threadPool = this.getThreadPool(threadPoolMgr, "ProcessDiscovery", n);
        this.connectionPool = new ObjectPool("Tcp Connection", 20){

            protected Object createObject() {
                return MulticastServer.this.createUdpConnection();
            }
        };
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "MulticastServer");
        }
    }

    public EndpointAddress getMulticastAddress() {
        return this.mAddress;
    }

    public boolean initialize(EndpointAddress endpointAddress, int n, int n2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize @" + n);
        }
        boolean bl = true;
        this.port = n;
        this.alive = true;
        this.mAddress = new EndpointAddress();
        this.mAddress.setProtocolName("MUDP");
        if (endpointAddress.getProtocolAddress() != null) {
            this.mAddress.setProtocolAddress(endpointAddress.getProtocolAddress());
        } else {
            this.mAddress.setProtocolAddress(this.defaultAddr);
        }
        this.multicastSize = n2 <= 0 ? this.bufSize : n2;
        try {
            this.group = InetAddress.getByName(this.mAddress.getProtocolAddress());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "the multicast group is " + this.group);
            }
        }
        catch (UnknownHostException unknownHostException) {
            FFDCFilter.processException((Throwable)unknownHostException, "com.ibm.ws.management.discovery.transport.MulticastServer.initialize", "89", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to initialize the mutlicast server", unknownHostException);
            }
            Tr.warning(tc, "ADMD0014W", new Integer(n));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize - failed");
            }
            return false;
        }
        boolean bl2 = false;
        try {
            this.serverSocket = new MulticastSocket(n);
            this.serverSocket.joinGroup(this.group);
            bl2 = true;
        }
        catch (IOException iOException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to join the multicast group", iOException);
            }
        }
        catch (Exception exception) {
            Tr.debug(tc, "MulticastSocket Exception", exception);
        }
        if (bl2) {
            this.acceptThread = new Thread((Runnable)this, this.serverSocket.toString());
            this.acceptThread.setDaemon(true);
            this.acceptThread.start();
        } else {
            bl = false;
            if (!rediscover_called) {
                rediscover_called = true;
                this.rediscover();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
        return bl;
    }

    public void shutdown(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "shutdown");
        }
        this.alive = false;
        try {
            try {
                this.serverSocket.leaveGroup(this.group);
                this.serverSocket.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.discovery.transport.MulticastServer.shutdown", "124", this);
                this.acceptThread.interrupt();
            }
            this.acceptThread.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.management.discovery.transport.MulticastServer.shutdown", "129", this);
            Tr.warning(tc, "ADMD0016W", this.getMessage(interruptedException));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "shutdown");
        }
    }

    public void run() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "run");
        }
        DatagramPacket datagramPacket = null;
        int n = 30000;
        int n2 = 0;
        int n3 = this.parsePositiveIntegerProperty(SLEEP_INTERVAL_PROPERTY, "15");
        int n4 = this.parsePositiveIntegerProperty(ATTEMPTS_THRESHOLD_PROPERTY, "3");
        while (this.alive && !Thread.interrupted()) {
            block24: {
                boolean bl;
                block23: {
                    ++n2;
                    bl = true;
                    try {
                        this.serverSocket.setSoTimeout(n);
                        byte[] byArray = new byte[this.multicastSize];
                        datagramPacket = new DatagramPacket(byArray, byArray.length);
                        this.serverSocket.receive(datagramPacket);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Datagram packet(port, length): ", new Object[]{Integer.toString(datagramPacket.getPort()), Integer.toString(datagramPacket.getLength())});
                        }
                    }
                    catch (IOException iOException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "IOException received on attempt: " + Integer.toString(n2));
                            Tr.warning(tc, "ADMD0017W", this.getMessage(iOException));
                            Tr.warning(tc, "...and the multicast address is  " + this.mAddress.getProtocolAddress());
                        }
                        bl = false;
                        if (rediscover_called) break block23;
                        rediscover_called = true;
                        this.rediscover();
                    }
                }
                n = 0;
                if (this.alive && bl) {
                    UdpConnection udpConnection = null;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "got good result - attempts: " + Integer.toString(n2));
                    }
                    n2 = 0;
                    try {
                        udpConnection = this.allocateConnection();
                        udpConnection.init(this.endpoint, datagramPacket);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "The connection is initialized");
                        }
                        this.handleConnection(udpConnection);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.management.discovery.transport.MulticastServer.run", "185", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "connection  handling failure:", throwable);
                        }
                        if (udpConnection == null) break block24;
                        this.freeConnection(udpConnection);
                    }
                }
            }
            if (n2 < n4) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, new StringBuilder().append("sleeping for ").append(Integer.toString(n3)).append(" seconds after ").append(Integer.toString(n2)).append(" attempts failed").toString());
            }
            n2 = 0;
            try {
                block25: {
                    Thread.sleep(n3 * 1000);
                    try {
                        this.serverSocket.leaveGroup(this.group);
                        this.serverSocket.close();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "left the multicast Group.");
                        }
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block25;
                        Tr.debug(tc, "Unable to leave the multicast group", exception);
                    }
                }
                try {
                    this.serverSocket = new MulticastSocket(this.port);
                    this.serverSocket.joinGroup(this.group);
                }
                catch (IOException iOException) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Unable to re-join the multicast group", iOException);
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "MulticastSocket Exception", exception);
                }
            }
            catch (InterruptedException interruptedException) {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Sleep interrupted, MulticastServer is shutting down: " + this.getMessage(interruptedException));
                break;
            }
        }
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "run");
        }
    }

    private int parsePositiveIntegerProperty(String string, String string2) {
        int n = 0;
        boolean bl = false;
        String string3 = System.getProperty(string);
        if (string3 == null) {
            string3 = string2;
            bl = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "property: " + string + " not passed, using default value: " + string2);
            }
        }
        try {
            n = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        if (n < 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "property: " + string + " value: " + string3 + " is invalid, using default value: " + string2);
            }
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (!bl && tc.isDebugEnabled()) {
            Tr.debug(tc, "using " + string + "=" + string3);
        }
        return n;
    }

    private String getMessage(Throwable throwable) {
        String string = throwable.getMessage();
        if (string == null) {
            string = throwable.getCause().getMessage();
        }
        if (string == null) {
            string = throwable.toString();
        }
        return string;
    }

    void rediscover() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rediscover");
        }
        AdminClient adminClient = null;
        boolean bl = false;
        Subject subject = SecurityHelper.getServerSubject();
        if (subject != null) {
            SecurityHelper.pushInvocationSubject(subject);
        }
        try {
            adminClient = nodeAgentConnector.create();
        }
        catch (ConnectorException connectorException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unable to create admin client to nodeagent", connectorException);
            }
            bl = true;
        }
        if (adminClient != null) {
            ObjectName objectName = null;
            try {
                objectName = new ObjectName("*:*,type=Discovery,process=" + Utils.getNodeAgentName());
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                // empty catch block
            }
            try {
                Set set = adminClient.queryNames(objectName, null);
                if (set.iterator().hasNext()) {
                    ObjectName objectName2 = (ObjectName)set.iterator().next();
                    adminClient.invoke(objectName2, "query", new Object[]{RoutingTable.getInstance().getOwnInfo()}, new String[]{ServerInfo.class.getName()});
                } else {
                    bl = true;
                }
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "failed to send out discover message", exception);
                }
                bl = true;
            }
        }
        if (bl) {
            Tr.warning(tc, "ADMD0024W", Utils.getNodeAgentName());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rediscover");
        }
    }

    public static void setupNodeAgentConnector(EndPointMgr endPointMgr) {
        nodeAgentConnector = new NodeAgentConnector(endPointMgr);
    }

    static {
        SLEEP_INTERVAL_PROPERTY = "com.ibm.websphere.management.multicastserver.sleepInterval";
        ATTEMPTS_THRESHOLD_PROPERTY = "com.ibm.websphere.management.multicastserver.retryLimit";
    }

    private static class NodeAgentConnector {
        String bootstrapPort;
        String soapPort;
        String hostname;

        NodeAgentConnector(EndPointMgr endPointMgr) {
            EndPointMgr.NodeEndPoints nodeEndPoints = endPointMgr.getNodeEndPoints("@");
            EndPointMgr.ServerEndPoints serverEndPoints = nodeEndPoints.getServerEndPoints(Utils.getNodeAgentName());
            EndPoint endPoint = serverEndPoints.getEndPoint("BOOTSTRAP_ADDRESS");
            if (endPoint != null) {
                this.bootstrapPort = new Integer(endPoint.getPort()).toString();
            }
            if ((endPoint = serverEndPoints.getEndPoint("SOAP_CONNECTOR_ADDRESS")) != null) {
                this.hostname = endPoint.getHost();
                this.soapPort = new Integer(endPoint.getPort()).toString();
            }
        }

        AdminClient create() throws ConnectorException {
            Properties properties;
            AdminClient adminClient;
            block11: {
                boolean bl;
                block10: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry(tc, "create");
                    }
                    adminClient = null;
                    bl = false;
                    String string = SecurityHelper.getHelper().isSecurityEnabled() ? "true" : "false";
                    properties = new Properties();
                    properties.setProperty("securityEnabled", string);
                    if (this.hostname != null && this.hostname.length() > 0) {
                        properties.setProperty("host", this.hostname);
                    } else {
                        properties.setProperty("host", "localhost");
                    }
                    properties.setProperty("isInternal", "true");
                    if (this.soapPort != null) {
                        properties.setProperty("port", this.soapPort);
                        properties.setProperty("type", "SOAP");
                        properties.setProperty("securityEnabled", string);
                        try {
                            adminClient = AdminClientFactory.createAdminClient(properties);
                            bl = true;
                        }
                        catch (ConnectorException connectorException) {
                            if (!tc.isDebugEnabled()) break block10;
                            Tr.debug(tc, "Unable to create soap client to nodeagent for rediscover", new Object[]{properties});
                        }
                    }
                }
                if (!bl && this.bootstrapPort != null) {
                    properties.setProperty("port", this.bootstrapPort);
                    properties.setProperty("type", "RMI");
                    try {
                        adminClient = AdminClientFactory.createAdminClient(properties);
                        bl = true;
                    }
                    catch (ConnectorException connectorException) {
                        if (!tc.isDebugEnabled()) break block11;
                        Tr.debug(tc, "Unable to create rmi client to nodeagent for rediscover", new Object[]{properties});
                    }
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "create", properties);
            }
            return adminClient;
        }
    }
}

