/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.discovery.Endpoint;
import com.ibm.ws.management.discovery.Message;
import com.ibm.ws.management.discovery.transport.Header;
import java.io.InputStream;
import java.net.Socket;

public class TcpConnection
implements Runnable {
    private static TraceComponent tc = Tr.register(TcpConnection.class);
    private static final String MAX_MSG_SIZE_PROPERTY = "com.ibm.ws.management.discovery.transport.maxTcpMsgSize";
    private static final int MAX_MSG_SIZE = Integer.getInteger("com.ibm.ws.management.discovery.transport.maxTcpMsgSize", 100000);
    Endpoint endpoint;
    Socket socket;
    public static final int SoTimeout = 180000;

    public void init(Endpoint endpoint, Socket socket) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        this.endpoint = endpoint;
        this.socket = socket;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void run() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "run");
        }
        InputStream inputStream = null;
        try {
            inputStream = this.socket.getInputStream();
            if (inputStream == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No InputStream");
                }
                this.socket.close();
                return;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.discovery.transport.TcpConnection.run", "61", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " failed to create inputStream");
            }
            try {
                this.socket.close();
            }
            catch (Exception exception2) {
                FFDCFilter.processException((Throwable)exception2, "com.ibm.ws.management.discovery.transport.TcpConnection.run", "66", this);
            }
            return;
        }
        while (true) {
            int n = 0;
            try {
                byte[] byArray = new byte[Header.length];
                this.socket.setSoTimeout(180000);
                n = inputStream.read(byArray, 0, Header.length);
                if (-1 == n) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, " End of inputstream. Closing socket");
                    }
                    inputStream.close();
                    this.socket.close();
                    return;
                }
                if (n != Header.length) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "TcpHeader size mismatch( " + n + "," + Header.length + ")");
                    }
                    inputStream.close();
                    this.socket.close();
                    return;
                }
                Header header2 = new Header();
                if (!header2.decipher(byArray, 0)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "can not understand the TcpHeader");
                    }
                    inputStream.close();
                    this.socket.close();
                    return;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "message size = " + header2.size);
                }
                if (header2.size > MAX_MSG_SIZE) {
                    String string = "Incoming message rejected, size is greater than " + MAX_MSG_SIZE + " bytes. " + "Header values:\n" + "cmd = " + header2.cmd + '\n' + "srcAddr = " + (header2.srcAddr[0] & 0xFF) + "." + (header2.srcAddr[1] & 0xFF) + "." + (header2.srcAddr[2] & 0xFF) + "." + (header2.srcAddr[3] & 0xFF) + '\n' + "srcPort = " + header2.srcPort + '\n' + "size = " + header2.size + '\n' + "option = " + header2.option + '\n' + "packetId = " + header2.packetId;
                    FFDCFilter.processException((Throwable)new Exception(string), "com.ibm.ws.management.discovery.transport.TcpConnection.run", "136", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, string);
                    }
                    inputStream.close();
                    this.socket.close();
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "run");
                    }
                    return;
                }
                int n2 = 0;
                byte[] byArray2 = new byte[header2.size];
                for (n = 0; n < header2.size; n += n2) {
                    try {
                        n2 = inputStream.read(byArray2, n, header2.size - n);
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.discovery.transport.TcpConnection.run", "117", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "inputStream is broken");
                        }
                        inputStream.close();
                        this.socket.close();
                        return;
                    }
                    if (n2 != -1) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "no more bytes to receive - incomplete message");
                    }
                    inputStream.close();
                    this.socket.close();
                    return;
                }
                if (n != header2.size) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "size mismatch, message corrupted");
                    }
                    inputStream.close();
                    this.socket.close();
                    return;
                }
                Message message = new Message(byArray2, 0, header2.size);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, " forward the message up to the endpoint");
                }
                this.endpoint.demux(message);
                if (!tc.isEntryEnabled()) continue;
                Tr.exit(tc, "run");
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.discovery.transport.TcpConnection.run", "150", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "run - exception", exception);
                }
                return;
            }
        }
    }
}

