/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.discovery.Endpoint;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.EndpointMessenger;
import com.ibm.ws.management.discovery.protocol.TcpAdv;
import com.ibm.ws.management.discovery.transport.MessengerFactory;
import com.ibm.ws.management.discovery.transport.TransportProtocol;
import com.ibm.ws.management.discovery.transport.UnicastServer;
import java.io.IOException;
import java.net.InetAddress;

public class TcpTransport
implements TransportProtocol {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register(TcpTransport.class, "Admin", "com.ibm.ws.management.resources.discovery");
    private boolean initialized = false;
    protected int port;
    protected EndpointAddress localAddress;
    private UnicastServer unicastServer;

    public TcpTransport(TcpAdv tcpAdv) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TcpTransport");
        }
        InetAddress inetAddress = null;
        this.port = new Integer(tcpAdv.getPort());
        String string = tcpAdv.getLocalAddress();
        try {
            if (string == null) {
                inetAddress = AdminHelper.getInstance().getLocalHost();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "In TcpTransport, the hostname or IP addr obtained from TcpAdv is null");
                }
            } else {
                inetAddress = InetAddress.getByName(string);
            }
            if (inetAddress.getHostAddress().equals("127.0.0.1")) {
                Tr.warning(tc, "ADMD0025W");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.discovery.transport.TcpTransport.TcpTransport", "60", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Failed to initialize TcpTransport with exception: ", exception);
            }
            Tr.error(tc, "ADMD0018E", exception.getMessage());
        }
        this.localAddress = new EndpointAddress();
        this.localAddress.setProtocolName("TCP");
        if (AdminHelper.getPlatformHelper().isZOS()) {
            this.localAddress.setProtocolAddress(inetAddress.getHostAddress() + ":" + this.port);
        } else if (string == null) {
            this.localAddress.setProtocolAddress(inetAddress.getHostName() + ":" + this.port);
        } else {
            this.localAddress.setProtocolAddress(string + ":" + this.port);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TcpTransport");
        }
    }

    public boolean init(Endpoint endpoint) throws Exception {
        if (this.initialized) {
            throw new IOException();
        }
        this.initialized = true;
        this.unicastServer = new UnicastServer(endpoint);
        this.unicastServer.initialize(this.port);
        return true;
    }

    public EndpointMessenger getMessenger(EndpointAddress endpointAddress) throws IOException {
        return MessengerFactory.createMessenger(endpointAddress, this);
    }

    public void close() {
        this.unicastServer.shutdown(true);
    }

    public String getProtocolName() {
        return "TCP";
    }

    public EndpointAddress getLocalAddress() {
        return this.localAddress;
    }

    public int getPort() {
        return this.port;
    }
}

