/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.discovery.Endpoint;
import com.ibm.ws.management.discovery.Message;
import com.ibm.ws.management.discovery.transport.Header;
import java.net.DatagramPacket;

public class UdpConnection
implements Runnable {
    private static TraceComponent tc = Tr.register(UdpConnection.class);
    Endpoint endpoint;
    DatagramPacket packet;

    public void init(Endpoint endpoint, DatagramPacket datagramPacket) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        this.endpoint = endpoint;
        this.packet = datagramPacket;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void run() {
        Message message;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "run");
            }
            Header header2 = new Header();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "start to retrieve data");
            }
            byte[] byArray = this.packet.getData();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "data retrieved successfully");
            }
            int n = this.packet.getLength();
            if (!header2.decipher(byArray, 0)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "can not understand the TcpHeader");
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "the incoming datagram size is " + header2.size);
            }
            if (header2.size > byArray.length) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "The incoming message is truncated: " + header2.size + ">" + byArray.length);
                }
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "run - failed");
                }
                return;
            }
            message = null;
            try {
                message = new Message(byArray, Header.length, header2.size);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.discovery.transport.UdpConnection.run", "73", this);
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug(tc, "can not construct discoveyr message", throwable);
            }
        }
        if (message != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, " forward the message up to the endpoint");
            }
            this.endpoint.demux(message);
        }
    }
}

