/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.EndpointMessenger;
import com.ibm.ws.management.discovery.Message;
import com.ibm.ws.management.discovery.transport.Header;
import com.ibm.ws.management.discovery.transport.TransportProtocol;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Vector;

public class UdpMessenger
implements EndpointMessenger {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private TraceComponent tc = Tr.register(UdpMessenger.class, "Admin", "com.ibm.ws.management.resources.discovery");
    private TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.management.resources.discovery");
    protected TransportProtocol protocol;
    protected DatagramSocket socket;
    protected int port;
    protected EndpointAddress destination;
    protected EndpointAddress source;
    protected InetAddress inetAddress;
    protected Header header;

    protected UdpMessenger() {
    }

    public UdpMessenger(EndpointAddress endpointAddress, TransportProtocol transportProtocol) throws IOException {
        int n;
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "UdpMessenger", endpointAddress);
        }
        this.destination = endpointAddress;
        this.protocol = transportProtocol;
        this.header = new Header();
        this.source = transportProtocol.getLocalAddress();
        String string = this.destination.getProtocolAddress();
        int n2 = string.indexOf(93);
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = string.indexOf(58, n2)) == -1) {
            if (this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "UdpMessenger - failed");
            }
            throw new IOException(this.nls.getString("ADMD0010E"));
        }
        this.port = Integer.valueOf(string.substring(n + 1));
        if (this.tc.isDebugEnabled()) {
            Tr.debug(this.tc, "port = " + this.port);
        }
        this.inetAddress = InetAddress.getByName(string.substring(0, n));
        if (!this.openSocket()) {
            if (this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "UdpMessenger - failed");
            }
            throw new IOException(this.nls.getFormattedMessage("ADMD0005E", new Object[]{new Integer(this.port)}, "can not open the UDP socket: {0}"));
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "UdpMessenger");
        }
    }

    public void sendMessage(Message message) throws IOException {
        block12: {
            Object object;
            int n;
            if (this.tc.isEntryEnabled()) {
                Tr.entry(this.tc, "sendMessage");
            }
            if (this.destination == null) {
                if (this.tc.isEntryEnabled()) {
                    Tr.exit(this.tc, "sendMessage - failed");
                }
                throw new IOException(this.nls.getString("ADMD0006E"));
            }
            int n2 = 0;
            int n3 = 4096;
            InputStream inputStream = message.getInputStream();
            Vector<byte[]> vector = new Vector<byte[]>();
            vector.addElement(new byte[Header.length]);
            while ((n = inputStream.read((byte[])(object = new byte[n3]))) != -1) {
                if (n == 0) continue;
                if (n < n3) {
                    byte[] byArray = new byte[n];
                    System.arraycopy(object, 0, byArray, 0, n);
                    object = byArray;
                }
                n2 += ((byte[])object).length;
                vector.addElement((byte[])object);
            }
            this.header.cmd = (byte)2;
            object = this.protocol.getLocalAddress().getProtocolHost();
            if (this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "local host name is: " + (String)object);
            }
            this.header.srcAddr = InetAddress.getByName((String)object).getAddress();
            this.header.srcPort = this.protocol.getPort();
            this.header.option = 2;
            this.header.size = n2;
            this.header.cipher((byte[])vector.elementAt(0), 0);
            byte[] byArray = new byte[Header.length + n2];
            int n4 = 0;
            if (this.tc.isDebugEnabled()) {
                Tr.debug(this.tc, "header size: " + Header.length + " message size : " + n2);
            }
            for (int i = 0; i < vector.size(); ++i) {
                byte[] byArray2 = (byte[])vector.elementAt(i);
                System.arraycopy(byArray2, 0, byArray, n4, byArray2.length);
                n4 += byArray2.length;
                if (!this.tc.isDebugEnabled()) continue;
                Tr.debug(this.tc, "size for one pile: " + byArray2.length + " offset: " + n4);
            }
            if (this.socket == null && !this.openSocket()) {
                throw new IOException(this.nls.getFormattedMessage("ADMD0005E", new Object[]{new Integer(this.port)}, "can not open the UDP socket: {0}"));
            }
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, this.inetAddress, this.port);
            try {
                this.socket.send(datagramPacket);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.discovery.transport.UdpMessenger.sendMessage", "183", this);
                if (!this.tc.isDebugEnabled()) break block12;
                Tr.debug(this.tc, "Failed to send out the datagram", exception);
            }
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "sendMessage");
        }
    }

    public void close() {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "close");
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.discovery.transport.UdpMessenger.close", "200", this);
            }
        }
        if (this.tc.isEntryEnabled()) {
            Tr.exit(this.tc, "close");
        }
    }

    private boolean openSocket() {
        if (this.tc.isEntryEnabled()) {
            Tr.entry(this.tc, "openSocket");
        }
        this.socket = null;
        try {
            this.socket = new DatagramSocket();
            if (this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "openSocket - good");
            }
            return true;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.discovery.transport.UdpMessenger.openSocket", "218", this);
            if (this.tc.isEntryEnabled()) {
                Tr.exit(this.tc, "openSocket - bad", exception);
            }
            return false;
        }
    }
}

