/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.process.ProcessFactory;
import com.ibm.websphere.models.config.process.ProcessPackage;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.discovery.Endpoint;
import com.ibm.ws.management.discovery.transport.UdpConnection;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.util.ObjectPool;
import com.ibm.ws.util.ThreadPool;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.eclipse.emf.ecore.EPackage;

public class UdpServer
implements Runnable {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register(UdpServer.class, "Admin", "com.ibm.ws.management.resources.discovery");
    protected ThreadPool threadPool = null;
    protected ObjectPool connectionPool = null;
    protected int port;
    protected int bufSize = 16384;
    protected boolean alive;
    protected Thread acceptThread = null;
    protected Endpoint endpoint;
    private DatagramSocket serverSocket;
    private Boolean useMultiHome;
    private int retryLimit = 4;
    private int retryInterval = 1000;

    public UdpServer() {
    }

    public UdpServer(Endpoint endpoint) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "UdpServer");
        }
        this.endpoint = endpoint;
        ThreadPoolMgr threadPoolMgr = endpoint.getThreadPoolMgr();
        int n = 2;
        String string = System.getProperty("com.ibm.websphere.management.processDiscoveryThreads");
        if (string != null) {
            n = new Integer(string);
        }
        this.threadPool = this.getThreadPool(threadPoolMgr, "ProcessDiscovery", n);
        this.connectionPool = new ObjectPool("Tcp Connection", 20){

            protected Object createObject() {
                return UdpServer.this.createUdpConnection();
            }
        };
        this.retryLimit = Integer.getInteger("com.ibm.websphere.management.discovery.udp.retryLimit", 4);
        this.retryInterval = Integer.getInteger("com.ibm.websphere.management.discovery.udp.retryInterval", 1000);
        if (this.retryInterval > 30000) {
            this.retryInterval = 30000;
        }
        if (this.retryInterval < 1000) {
            this.retryInterval = 1000;
        }
        this.useMultiHome = AdminHelper.getInstance().useMultiHome();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "UdpServer");
        }
    }

    public void initialize(int n) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize @" + n);
        }
        this.alive = true;
        this.port = n;
        this.init();
        this.acceptThread = new Thread((Runnable)this, this.serverSocket.toString());
        this.acceptThread.setDaemon(true);
        this.acceptThread.start();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize - successful");
        }
    }

    private void init() throws Exception {
        if (this.useMultiHome == null) {
            this.serverSocket = new DatagramSocket(this.port);
        } else if (this.useMultiHome.booleanValue()) {
            this.serverSocket = new DatagramSocket(this.port, null);
        } else {
            InetAddress inetAddress = InetAddress.getByName(this.endpoint.getEndpointAddress().getProtocolHost());
            this.serverSocket = new DatagramSocket(this.port, inetAddress);
        }
    }

    public void shutdown(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "shutdown");
        }
        this.alive = false;
        try {
            try {
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.discovery.transport.UdpServer.shutdown", "124", this);
                this.acceptThread.interrupt();
            }
            this.acceptThread.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.management.discovery.transport.UdpServer.shutdown", "129", this);
            Tr.warning(tc, "ADMD0016W", this.getMessage(interruptedException));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "shutdown");
        }
    }

    protected UdpConnection createUdpConnection() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createUdpConnection");
        }
        return new UdpConnection();
    }

    public void handleConnection(UdpConnection udpConnection) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "handleConnection");
        }
        try {
            this.threadPool.execute(udpConnection);
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.management.discovery.transport.UdpServer.handleConnection", "148", this);
        }
    }

    public UdpConnection allocateConnection() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "allocateConnection");
        }
        return (UdpConnection)this.connectionPool.remove();
    }

    public boolean freeConnection(UdpConnection udpConnection) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "freeConnection");
        }
        return !this.connectionPool.add(udpConnection);
    }

    public void run() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "run");
        }
        int n = 0;
        DatagramPacket datagramPacket = null;
        Exception exception = null;
        while (this.alive) {
            if (n >= this.retryLimit) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, new StringBuilder().append("UdpServer.run exceeded retry limit of ").append(Integer.toString(this.retryLimit)).append(", beginning long sleep ...").toString());
                }
                while (exception != null && this.alive) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, new StringBuilder().append("UdpServer.run: sleeping for ").append(Integer.toString(30)).append(" seconds").toString());
                    }
                    try {
                        Thread.sleep(30000L);
                        this.init();
                        exception = null;
                    }
                    catch (InterruptedException interruptedException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "UdpServer.run long sleep is interrupted ... shutting down");
                        }
                        this.alive = false;
                        break;
                    }
                    catch (Exception exception2) {
                        exception = exception2;
                    }
                }
                n = 0;
            }
            if (this.acceptThread.isInterrupted()) break;
            try {
                byte[] byArray = new byte[this.bufSize];
                datagramPacket = new DatagramPacket(byArray, byArray.length);
                this.serverSocket.receive(datagramPacket);
                n = 0;
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.discovery.transport.UdpServer.run", "170", this);
                if (this.alive) {
                    Tr.warning(tc, "ADMD0017W", this.getMessage(iOException));
                }
                exception = iOException;
                ++n;
                try {
                    if (n == 1 && tc.isDebugEnabled()) {
                        Tr.debug(tc, new StringBuilder().append("UdpServer.run caught ").append(this.getMessage(iOException)).append(" and will sleep for at most ").append(Integer.toString(this.retryLimit)).append(" iterations of ").append(Integer.toString(this.retryInterval)).append(" milliseconds...").toString());
                    }
                    Thread.sleep(this.retryInterval);
                }
                catch (InterruptedException interruptedException) {
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Thread Interrupted.. shutting down");
                    break;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Datagram packet(port, length): ", new Object[]{Integer.toString(datagramPacket.getPort()), Integer.toString(datagramPacket.getLength())});
            }
            if (!this.alive) continue;
            UdpConnection udpConnection = null;
            try {
                udpConnection = this.allocateConnection();
                udpConnection.init(this.endpoint, datagramPacket);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "the connection is initialized");
                }
                this.handleConnection(udpConnection);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws.management.discovery.transport.UdpServer.run", "185", this);
                if (udpConnection != null) {
                    this.freeConnection(udpConnection);
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "connection handling failure: " + this.getMessage(throwable));
            }
        }
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "run");
        }
    }

    private String getMessage(Throwable throwable) {
        String string = throwable.getMessage();
        if (string == null) {
            string = throwable.getCause().getMessage();
        }
        if (string == null) {
            string = throwable.toString();
        }
        return string;
    }

    protected ThreadPool getThreadPool(ThreadPoolMgr threadPoolMgr, String string, int n) {
        ThreadPool threadPool = null;
        ProcessPackage processPackage = (ProcessPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/process.xmi");
        ProcessFactory processFactory = processPackage.getProcessFactory();
        com.ibm.websphere.models.config.process.ThreadPool threadPool2 = processFactory.createThreadPool();
        threadPool2.setMinimumSize(1);
        threadPool2.setMaximumSize(n);
        threadPool2.setIsGrowable(true);
        threadPool = threadPoolMgr.getThreadPool(string, threadPool2);
        return threadPool;
    }
}

