/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.discovery.Endpoint;
import com.ibm.ws.management.discovery.EndpointAddress;
import com.ibm.ws.management.discovery.EndpointMessenger;
import com.ibm.ws.management.discovery.protocol.UdpAdv;
import com.ibm.ws.management.discovery.transport.MessengerFactory;
import com.ibm.ws.management.discovery.transport.TransportProtocol;
import com.ibm.ws.management.discovery.transport.UdpServer;
import java.io.IOException;
import java.net.InetAddress;

public class UdpTransport
implements TransportProtocol {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register(UdpTransport.class, "Admin", "com.ibm.ws.management.resources.discovery");
    protected int port;
    protected boolean initialized = false;
    protected EndpointAddress localAddress;
    private UdpServer udpServer;

    public UdpTransport() {
    }

    public UdpTransport(UdpAdv udpAdv) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "UdpTransport");
        }
        InetAddress inetAddress = null;
        this.port = new Integer(udpAdv.getPort());
        String string = udpAdv.getLocalAddress();
        try {
            if (string == null) {
                inetAddress = AdminHelper.getInstance().getLocalHost();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "In UdpTransport, the hostname or IP addr obtained from UdpAdv is null");
                }
            } else {
                inetAddress = InetAddress.getByName(string);
            }
            if (inetAddress.getHostAddress().equals("127.0.0.1")) {
                Tr.warning(tc, "ADMD0025W");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.discovery.transport.UdpTransport.UdpTransport", "57", this);
            Tr.error(tc, "ADMD0019E", exception.getMessage());
        }
        this.localAddress = new EndpointAddress();
        this.localAddress.setProtocolName("UDP");
        if (AdminHelper.getPlatformHelper().isZOS()) {
            this.localAddress.setProtocolAddress(inetAddress.getHostAddress() + ":" + this.port);
        } else if (string == null) {
            this.localAddress.setProtocolAddress(inetAddress.getHostName() + ":" + this.port);
        } else {
            this.localAddress.setProtocolAddress(string + ":" + this.port);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "UdpTransport");
        }
    }

    public EndpointMessenger getMessenger(EndpointAddress endpointAddress) throws IOException {
        return MessengerFactory.createMessenger(endpointAddress, this);
    }

    public boolean init(Endpoint endpoint) throws Exception {
        if (this.initialized) {
            throw new IOException();
        }
        this.initialized = true;
        this.udpServer = new UdpServer(endpoint);
        this.udpServer.initialize(this.port);
        return true;
    }

    public EndpointAddress getLocalAddress() {
        return this.localAddress;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocolName() {
        return "UDP";
    }

    public void close() {
        this.udpServer.shutdown(true);
    }
}

