/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.discovery.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.process.ProcessFactory;
import com.ibm.websphere.models.config.process.ProcessPackage;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.discovery.Endpoint;
import com.ibm.ws.management.discovery.transport.TcpConnection;
import com.ibm.ws.runtime.service.ThreadPoolMgr;
import com.ibm.ws.util.ObjectPool;
import com.ibm.ws.util.ThreadPool;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.emf.ecore.EPackage;

public class UnicastServer
implements Runnable {
    private static final String bundleName = "com.ibm.ws.management.resources.discovery";
    private static TraceComponent tc = Tr.register(UnicastServer.class, "Admin", "com.ibm.ws.management.resources.discovery");
    private ThreadPool threadPool = null;
    private ObjectPool connectionPool = null;
    private ServerSocket serverSocket;
    private boolean alive;
    private Thread acceptThread = null;
    private Endpoint endpoint;
    private int port;
    private Boolean useMultiHome;
    private int retryLimit = 4;
    private int retryInterval = 1000;

    public UnicastServer(Endpoint endpoint) {
        this.endpoint = endpoint;
        ThreadPoolMgr threadPoolMgr = endpoint.getThreadPoolMgr();
        int n = 2;
        String string = System.getProperty("com.ibm.websphere.management.processDiscoveryThreads");
        if (string != null) {
            n = new Integer(string);
        }
        this.threadPool = this.getThreadPool(threadPoolMgr, "ProcessDiscovery", n);
        this.connectionPool = new ObjectPool("Tcp Connection", 20){

            protected Object createObject() {
                return UnicastServer.this.createTcpConnection();
            }
        };
        this.retryLimit = Integer.getInteger("com.ibm.websphere.management.discovery.unicast.retryLimit", 4);
        this.retryInterval = Integer.getInteger("com.ibm.websphere.management.discovery.unicast.retryInterval", 1000);
        if (this.retryInterval > 30000) {
            this.retryInterval = 30000;
        }
        if (this.retryInterval < 1000) {
            this.retryInterval = 1000;
        }
        this.useMultiHome = AdminHelper.getInstance().useMultiHome();
    }

    public void initialize(int n) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize @" + n);
        }
        this.alive = true;
        this.port = n;
        this.init();
        this.acceptThread = new Thread((Runnable)this, this.serverSocket.toString());
        this.acceptThread.setDaemon(true);
        this.acceptThread.start();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize - successful");
        }
    }

    private void init() throws Exception {
        if (this.useMultiHome == null) {
            this.serverSocket = new ServerSocket(this.port);
        } else if (this.useMultiHome.booleanValue()) {
            this.serverSocket = new ServerSocket(this.port, 50, null);
        } else {
            InetAddress inetAddress = InetAddress.getByName(this.endpoint.getEndpointAddress().getProtocolHost());
            this.serverSocket = new ServerSocket(this.port, 50, inetAddress);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "useMultiHome == false: host name = " + inetAddress);
            }
        }
    }

    public void shutdown(boolean bl) {
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "shutdown");
            }
            this.alive = false;
            try {
                try {
                    Socket socket = new Socket("localhost", this.serverSocket.getLocalPort());
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.discovery.transport.UnicastServer.shutdown", "78", this);
                    this.acceptThread.interrupt();
                }
                this.acceptThread.join(10000L);
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.management.discovery.transport.UnicastServer.shutdown", "83", this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "failed to shutdown the UnicastServer", interruptedException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "shutdown");
        }
    }

    protected TcpConnection createTcpConnection() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "createTcpConnection");
        }
        return new TcpConnection();
    }

    public void handleConnection(TcpConnection tcpConnection) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "handleConnection");
        }
        try {
            this.threadPool.execute(tcpConnection);
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws.management.discovery.transport.UnicastServer.handleConnection", "101", this);
        }
    }

    public TcpConnection allocateConnection() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "allocateConnection");
        }
        return (TcpConnection)this.connectionPool.remove();
    }

    public boolean freeConnection(TcpConnection tcpConnection) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "freeConnection");
        }
        return !this.connectionPool.add(tcpConnection);
    }

    public void run() {
        block27: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "run");
            }
            int n = 0;
            Exception exception = null;
            while (this.alive) {
                Socket socket;
                block26: {
                    if (n >= this.retryLimit) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, new StringBuilder().append("UnicastServer.run is exceeded retry limit of ").append(Integer.toString(this.retryLimit)).append(", beginning long sleep ...").toString());
                        }
                        while (exception != null && this.alive) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, new StringBuilder().append("UnicastServer.run: sleeping for ").append(Integer.toString(30)).append(" seconds").toString());
                            }
                            try {
                                Thread.sleep(30000L);
                                this.init();
                                exception = null;
                            }
                            catch (InterruptedException interruptedException) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "UnicastServer.run long sleep is interrupted ... shutting down");
                                }
                                this.alive = false;
                                break;
                            }
                            catch (Exception exception2) {
                                exception = exception2;
                            }
                        }
                        n = 0;
                    }
                    if (this.acceptThread.isInterrupted() || !this.alive) break;
                    socket = null;
                    try {
                        socket = this.serverSocket.accept();
                        n = 0;
                    }
                    catch (IOException iOException) {
                        exception = iOException;
                        FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.discovery.transport.UnicastServer.run", "118", this);
                        ++n;
                        try {
                            if (n == 1 && tc.isDebugEnabled()) {
                                Tr.debug(tc, new StringBuilder().append("UnicastServer.run caught ").append(this.getMessage(iOException)).append(" and will sleep for at most ").append(Integer.toString(this.retryLimit)).append(" iterations of ").append(Integer.toString(this.retryInterval)).append(" milliseconds...").toString());
                            }
                            Thread.sleep(this.retryInterval);
                        }
                        catch (InterruptedException interruptedException) {
                            if (!tc.isDebugEnabled()) break;
                            Tr.debug(tc, "Thread Interrupted.. shutting down");
                            break;
                        }
                        if (!this.alive || n != 1) break block26;
                        Tr.warning(tc, "ADMD0020W", this.getMessage(iOException));
                    }
                }
                if (this.alive && socket != null) {
                    TcpConnection tcpConnection = null;
                    try {
                        tcpConnection = this.allocateConnection();
                        tcpConnection.init(this.endpoint, socket);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "the connection is initialized");
                        }
                        this.handleConnection(tcpConnection);
                    }
                    catch (Throwable throwable) {
                        FFDCFilter.processException(throwable, "com.ibm.ws.management.discovery.transport.UnicastServer.run", "130", this);
                        if (tcpConnection != null) {
                            this.freeConnection(tcpConnection);
                        }
                        Tr.warning(tc, "ADMD0021W", this.getMessage(throwable));
                    }
                    continue;
                }
                if (socket == null) continue;
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.discovery.transport.UnicastServer.run", "138", this);
                }
            }
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, "com.ibm.ws.management.discovery.transport.UnicastServer.run", "147", this);
                    if (!tc.isDebugEnabled()) break block27;
                    Tr.debug(tc, "failed to close server socket", iOException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "run");
        }
    }

    private String getMessage(Throwable throwable) {
        String string = throwable.getMessage();
        if (string == null) {
            string = throwable.getCause().getMessage();
        }
        if (string == null) {
            string = throwable.toString();
        }
        return string;
    }

    private ThreadPool getThreadPool(ThreadPoolMgr threadPoolMgr, String string, int n) {
        ThreadPool threadPool = null;
        ProcessPackage processPackage = (ProcessPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/process.xmi");
        ProcessFactory processFactory = processPackage.getProcessFactory();
        com.ibm.websphere.models.config.process.ThreadPool threadPool2 = processFactory.createThreadPool();
        threadPool2.setMinimumSize(1);
        threadPool2.setMaximumSize(n);
        threadPool2.setIsGrowable(true);
        threadPool = threadPoolMgr.getThreadPool(string, threadPool2);
        return threadPool;
    }
}

