/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.event.NotificationService;
import com.ibm.ws.management.event.RemoteSender;
import com.ibm.ws.management.util.SecurityHelper;
import java.io.NotSerializableException;
import javax.management.Notification;
import javax.security.auth.Subject;
import org.apache.soap.SOAPException;

public abstract class AbstractPushRemoteSender
extends RemoteSender
implements AlarmListener {
    private static TraceComponent tc = Tr.register(AbstractPushRemoteSender.class, "Admin", "com.ibm.ws.management.resources.event");
    private static final int MAX_CACHED = 5;
    private static final int BATCH_SIZE = 20;
    private static final long MAX_NORMAL_WAIT_TIME = 500L;
    private static final long MAX_FAILURE_WAIT_TIME = 60000L;
    private Alarm sendAlarm = null;
    private long currentWaitTime = 500L;
    private boolean connectorExceptionOccurred = false;

    public void handleNotification(Notification notification) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", NotificationService.getInfo(notification));
        }
        super.handleNotification(notification);
        if (this.getNumNotifications() >= 5 || this.isStoppingNotification(notification)) {
            this.flushNotifications();
        } else {
            this.createAlarmIfNecessary(this.currentWaitTime);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    public void stop() {
        super.stop();
        this.cancelAlarm();
    }

    private boolean isStoppingNotification(Notification notification) {
        return notification.getType().endsWith("stopping");
    }

    protected void receiverPermanentlyUnavailable() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "receiverPermanentlyUnavailable");
        }
        super.receiverPermanentlyUnavailable();
        this.stop();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "receiverPermanentlyUnavailable");
        }
    }

    private synchronized void cancelAlarm() {
        if (this.sendAlarm != null) {
            this.sendAlarm.cancel();
            this.deleteAlarm();
        }
    }

    private synchronized void deleteAlarm() {
        this.sendAlarm = null;
    }

    private synchronized void createAlarmIfNecessary(long l) {
        if (this.isActive() && this.sendAlarm == null && this.getNumNotifications() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Setting alarm for " + l + "ms");
            }
            this.sendAlarm = AlarmManager.createNonDeferrable(l, this);
        }
    }

    private void flushNotifications() {
        this.cancelAlarm();
        this.createAlarmIfNecessary(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm");
        }
        Subject subject = null;
        Subject subject2 = null;
        try {
            subject = SecurityHelper.getServerSubject();
            if (subject != null) {
                subject2 = SecurityHelper.pushInvocationSubject(subject);
            }
            if (this.getNumNotifications() > 0) {
                Notification[] notificationArray = this.getNotifications(20);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Sending " + notificationArray.length + " notifications " + "to " + this.getIdentifier());
                }
                try {
                    if (!this.pushNotifications(notificationArray)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "send returned false; requeuing");
                        }
                        this.requeueNotifications(notificationArray);
                    }
                    this.connectorExceptionOccurred = false;
                }
                catch (ConnectorException connectorException) {
                    Throwable throwable = connectorException.getCause();
                    if (throwable instanceof SOAPException) {
                        if (!((throwable = ((SOAPException)throwable).getTargetException()) instanceof NotSerializableException)) {
                            this.connectorExceptionOccurred = true;
                        }
                    } else {
                        this.connectorExceptionOccurred = true;
                    }
                    if (this.connectorExceptionOccurred) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "send got ConnectorException, nested exception; requeuing", connectorException);
                        }
                        this.requeueNotifications(notificationArray);
                        FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.event.AbstractPushRemoteSender.alarm", "231", this);
                    }
                }
            }
        }
        finally {
            try {
                if (subject != null) {
                    SecurityHelper.popInvocationSubject(subject2);
                }
            }
            finally {
                this.deleteAlarm();
                this.currentWaitTime = this.connectorExceptionOccurred ? Math.min(60000L, this.currentWaitTime * 2L) : 500L;
                this.createAlarmIfNecessary(this.currentWaitTime);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm");
        }
    }

    protected abstract boolean pushNotifications(Notification[] var1) throws ConnectorException;
}

