/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminClientImpl;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.DownstreamProcessManager;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.PushUpstreamServerSender;
import com.ibm.ws.management.event.RemoteNotificationBroadcaster;
import com.ibm.ws.management.exception.ReceiverNotFoundException;
import com.ibm.ws.management.util.SecurityHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.Subject;

public class DownstreamServerManager
implements DownstreamProcessManager {
    private static TraceComponent tc = Tr.register(DownstreamServerManager.class, "Admin", "com.ibm.ws.management.resources.event");
    private Map _filterMap;
    private Map _serverMap;
    private ThreadManager _threadManager = new ThreadManager();
    private QueueManager _queueManager = new QueueManager(this._threadManager);

    public DownstreamServerManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this._filterMap = new HashMap();
        this._serverMap = new HashMap();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public void addDownstreamServer(ServerInfo serverInfo) throws ConnectorException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addDownstreamServer", serverInfo);
        }
        ServerUpdateOpInfo serverUpdateOpInfo = new ServerUpdateOpInfo(0, serverInfo);
        this._queueManager.queueUpOperation(serverUpdateOpInfo);
        try {
            bl = serverUpdateOpInfo.waitForRequestToComplete();
        }
        catch (ConnectorException connectorException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addDownstreamServer", "ConnectorException: " + connectorException);
            }
            throw connectorException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addDownstreamServer", "updateCompleted=" + bl);
        }
    }

    public void addDownstreamProcess(ServerInfo serverInfo) throws ConnectorException {
        this.addDownstreamServer(serverInfo);
    }

    public void removeDownstreamServer(ServerInfo serverInfo) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeDownstreamServer", serverInfo);
        }
        ServerUpdateOpInfo serverUpdateOpInfo = new ServerUpdateOpInfo(1, serverInfo);
        this._queueManager.queueUpOperation(serverUpdateOpInfo);
        boolean bl = false;
        try {
            bl = serverUpdateOpInfo.waitForRequestToComplete();
        }
        catch (ConnectorException connectorException) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeDownstreamServer", "updateCompleted=" + bl);
        }
    }

    public void removeDownstreamProcess(ServerInfo serverInfo) throws ConnectorException {
        this.removeDownstreamServer(serverInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(Object object, ConsolidatedFilter consolidatedFilter) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setFilter", new Object[]{object, consolidatedFilter});
        }
        Map map = this._filterMap;
        synchronized (map) {
            this._filterMap.put(object, consolidatedFilter);
        }
        this.updateServerListeners();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setFilter");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetFilter(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unsetFilter", object);
        }
        Map map = this._filterMap;
        synchronized (map) {
            this._filterMap.remove(object);
        }
        this.updateServerListeners();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unsetFilter");
        }
    }

    private ListenerIdentifier addRemoteListener(ServerInfo serverInfo, ConsolidatedFilter consolidatedFilter) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRemoteListener", new Object[]{serverInfo, consolidatedFilter});
        }
        RemoteNotificationBroadcaster remoteNotificationBroadcaster = this.getRemoteProxy(serverInfo);
        PushUpstreamServerSender pushUpstreamServerSender = new PushUpstreamServerSender();
        ListenerIdentifier listenerIdentifier = remoteNotificationBroadcaster.addNotificationListener(consolidatedFilter, pushUpstreamServerSender);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRemoteListener", listenerIdentifier);
        }
        return listenerIdentifier;
    }

    private void removeRemoteListener(ServerInfo serverInfo, DSMEntry dSMEntry) throws ReceiverNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeRemoteListener", new Object[]{serverInfo, dSMEntry});
        }
        RemoteNotificationBroadcaster remoteNotificationBroadcaster = this.getRemoteProxy(serverInfo);
        remoteNotificationBroadcaster.removeNotificationListener(dSMEntry.listenerId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeRemoteListener");
        }
    }

    private void updateRemoteListener(ServerInfo serverInfo, DSMEntry dSMEntry) throws ReceiverNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateRemoteListener", new Object[]{serverInfo, dSMEntry});
        }
        RemoteNotificationBroadcaster remoteNotificationBroadcaster = this.getRemoteProxy(serverInfo);
        remoteNotificationBroadcaster.resetFilter(dSMEntry.listenerId, dSMEntry.filter);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateRemoteListener");
        }
    }

    private RemoteNotificationBroadcaster getRemoteProxy(ServerInfo serverInfo) throws ConnectorException {
        return ((AdminClientImpl)serverInfo.getAdminClient()).getProxy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServerListeners() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateServerListeners");
        }
        ArrayList<ServerInfo> arrayList = new ArrayList<ServerInfo>();
        ServerInfo[] serverInfoArray = this._serverMap;
        synchronized (this._serverMap) {
            Object object = this._serverMap.keySet().iterator();
            while (object.hasNext()) {
                ServerInfo serverInfo = (ServerInfo)object.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Updating server " + serverInfo);
                }
                arrayList.add(serverInfo);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            serverInfoArray = new ServerInfo[arrayList.size()];
            arrayList.toArray(serverInfoArray);
            object = new ServerUpdateOpInfo(2, serverInfoArray);
            this._queueManager.queueUpOperation((ServerUpdateOpInfo)object);
            boolean bl = false;
            try {
                bl = ((ServerUpdateOpInfo)object).waitForRequestToComplete();
            }
            catch (ConnectorException connectorException) {
                // empty catch block
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "updateServerListeners", "updateCompleted=" + bl);
            }
            return;
        }
    }

    private DSMEntry createDSMEntry(ServerInfo serverInfo) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDSMEntry", serverInfo);
        }
        DSMEntry dSMEntry = null;
        ConsolidatedFilter consolidatedFilter = this.createFilter(serverInfo);
        if (!consolidatedFilter.isEmpty()) {
            ListenerIdentifier listenerIdentifier = this.addRemoteListener(serverInfo, consolidatedFilter);
            dSMEntry = new DSMEntry(consolidatedFilter, listenerIdentifier);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDSMEntry", dSMEntry);
        }
        return dSMEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsolidatedFilter createFilter(ServerInfo serverInfo) {
        ConsolidatedFilter consolidatedFilter;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createFilter", serverInfo);
        }
        Map map = this._filterMap;
        synchronized (map) {
            consolidatedFilter = new ConsolidatedFilter();
            Iterator iterator = this._filterMap.values().iterator();
            while (iterator.hasNext()) {
                consolidatedFilter.appendFilterEntries((ConsolidatedFilter)iterator.next(), serverInfo);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createFilter", consolidatedFilter);
        }
        return consolidatedFilter;
    }

    class QueueConsumerThread
    implements Runnable {
        private static final int MAX_ENTRIES_TO_SERVICE_PER_QUEUE = 5;
        private final int _threadIndex;
        private final ThreadManager _threadManager;
        private String TRACE_HEADING;
        private Queue _queue = null;
        private int _requestsServicedOnCurrentQueue;
        private Thread _thread = null;
        private ConnectorException _connExc;

        public QueueConsumerThread(ThreadManager threadManager, int n) {
            this._threadManager = threadManager;
            this._threadIndex = n;
            this.setTraceHeading();
        }

        public synchronized void startUp(Queue queue) {
            if (this._thread == null) {
                this._queue = queue;
                this._requestsServicedOnCurrentQueue = 0;
                this._connExc = null;
                this.setTraceHeading();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, this.TRACE_HEADING + "Starting thread.");
                }
                this._thread = new Thread((Runnable)this, this.createThreadName(queue.getServerInfo()));
                this._thread.setDaemon(true);
                this._thread.start();
            } else {
                Exception exception = new Exception("Thread called to start up when already started.");
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.event.DownstreamServerManager.QueueConsumerThread.startUp", "1083", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, this.TRACE_HEADING + "Thread called to start up when already started.");
                }
            }
        }

        private synchronized QueueEntry getNextQueueEntry() {
            this._connExc = null;
            Thread thread = this._thread;
            QueueEntry queueEntry = null;
            do {
                if (this._requestsServicedOnCurrentQueue >= 5) {
                    this._queue = this._threadManager.unbindQueue(this._queue, this._threadIndex);
                    if (tc.isDebugEnabled() && this._queue != null) {
                        Tr.debug(tc, this.TRACE_HEADING + "getNextQueueEntry:", "Now bound to queue " + this._queue.getQueueNumber());
                    }
                    this._requestsServicedOnCurrentQueue = 0;
                    this.setTraceHeading();
                }
                if (this._queue == null) {
                    this._thread = null;
                    continue;
                }
                queueEntry = this._queue.getNextEntry();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, this.TRACE_HEADING + "getNextQueueEntry:", queueEntry);
                }
                if (queueEntry != null) {
                    ++this._requestsServicedOnCurrentQueue;
                    this._thread.setName(this.createThreadName(this._queue.getServerInfo()));
                    continue;
                }
                this._requestsServicedOnCurrentQueue = 5;
            } while (queueEntry == null && this._queue != null);
            return queueEntry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Subject subject = SecurityHelper.getServerSubject();
            if (subject != null) {
                SecurityHelper.pushInvocationSubject(subject);
            }
            try {
                QueueEntry queueEntry = this.getNextQueueEntry();
                while (queueEntry != null) {
                    block14: {
                        try {
                            ServerInfo serverInfo = queueEntry.getServerInfo();
                            switch (queueEntry.getOperation()) {
                                case 0: {
                                    this.addServer(serverInfo);
                                    break;
                                }
                                case 1: {
                                    this.removeServer(serverInfo);
                                    break;
                                }
                                case 2: {
                                    this.updateServers(serverInfo);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException(throwable, "com.ibm.ws.management.event.DownstreamServerManager.QueueConsumerThread.run", "1173", this);
                            if (!tc.isEventEnabled()) break block14;
                            Tr.event(tc, this.TRACE_HEADING + "Unexpected error.", throwable);
                        }
                    }
                    int n = this._queue.getQueueNumber();
                    queueEntry.getServerOpInfo().markServerUpdateComplete(n, this._connExc);
                    queueEntry = this.getNextQueueEntry();
                }
            }
            finally {
                if (subject != null) {
                    SecurityHelper.popInvocationSubject(subject);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, this.TRACE_HEADING + "Ending thread.");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addServer(ServerInfo serverInfo) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, this.TRACE_HEADING + "addServer", serverInfo);
            }
            try {
                DSMEntry dSMEntry = DownstreamServerManager.this.createDSMEntry(serverInfo);
                Map map = DownstreamServerManager.this._serverMap;
                synchronized (map) {
                    DownstreamServerManager.this._serverMap.put(serverInfo, dSMEntry);
                }
            }
            catch (ConnectorException connectorException) {
                FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.event.DownstreamServerManager.QueueConsumerThread.addServers", "1205", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, this.TRACE_HEADING + "addServer: ConnectorException:", connectorException);
                }
                this._connExc = connectorException;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, this.TRACE_HEADING + "addServer");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeServer(ServerInfo serverInfo) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, this.TRACE_HEADING + "removeServer", serverInfo);
            }
            Map map = DownstreamServerManager.this._serverMap;
            synchronized (map) {
                DownstreamServerManager.this._serverMap.remove(serverInfo);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, this.TRACE_HEADING + "removeServer");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateServers(ServerInfo serverInfo) {
            block24: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, this.TRACE_HEADING + "updateServers", serverInfo);
                }
                try {
                    DSMEntry dSMEntry;
                    boolean bl = true;
                    Object object = DownstreamServerManager.this._serverMap;
                    synchronized (object) {
                        dSMEntry = (DSMEntry)DownstreamServerManager.this._serverMap.get(serverInfo);
                        if (dSMEntry == null) {
                            bl = DownstreamServerManager.this._serverMap.containsKey(serverInfo);
                        }
                    }
                    if (dSMEntry == null) {
                        if (bl) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, this.TRACE_HEADING + "updateServers: DSMEntry null.");
                            }
                            if ((dSMEntry = DownstreamServerManager.this.createDSMEntry(serverInfo)) == null) break block24;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, this.TRACE_HEADING + "updateServers: " + "Setting non-null DSMEntry.");
                            }
                            object = DownstreamServerManager.this._serverMap;
                            synchronized (object) {
                                DownstreamServerManager.this._serverMap.put(serverInfo, dSMEntry);
                                break block24;
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, this.TRACE_HEADING + "updateServers: No server map entry.");
                        }
                        break block24;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, this.TRACE_HEADING + "DSMEntry: " + dSMEntry);
                    }
                    object = DownstreamServerManager.this.getRemoteProxy(serverInfo);
                    ConsolidatedFilter consolidatedFilter = DownstreamServerManager.this.createFilter(serverInfo);
                    if (consolidatedFilter != null) {
                        if (!consolidatedFilter.equals(dSMEntry.filter)) {
                            dSMEntry.filter = consolidatedFilter;
                            DownstreamServerManager.this.updateRemoteListener(serverInfo, dSMEntry);
                        }
                        break block24;
                    }
                    DownstreamServerManager.this.removeRemoteListener(serverInfo, dSMEntry);
                    Map map = DownstreamServerManager.this._serverMap;
                    synchronized (map) {
                        DownstreamServerManager.this._serverMap.put(serverInfo, null);
                    }
                }
                catch (ReceiverNotFoundException receiverNotFoundException) {
                    FFDCFilter.processException((Throwable)receiverNotFoundException, "com.ibm.ws.management.event.DownstreamServerManager.QueueConsumerThread.updateServers", "1295", this);
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, this.TRACE_HEADING + "updateServers: Exception:", receiverNotFoundException);
                    }
                }
                catch (ConnectorException connectorException) {
                    FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.event.DownstreamServerManager.QueueConsumerThread.updateServers", "1303", this);
                    if (!tc.isEventEnabled()) break block24;
                    Tr.event(tc, this.TRACE_HEADING + "updateServers ConnectorException");
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, this.TRACE_HEADING + "updateServers");
            }
        }

        private void setTraceHeading() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("QueueConsumerThread[");
            stringBuffer.append(this._threadIndex);
            stringBuffer.append("]");
            stringBuffer.append("(Q");
            if (this._queue != null) {
                stringBuffer.append(this._queue.getQueueNumber());
            } else {
                stringBuffer.append("U");
            }
            stringBuffer.append(")");
            stringBuffer.append(": ");
            this.TRACE_HEADING = stringBuffer.toString();
        }

        private String createThreadName(ServerInfo serverInfo) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.TRACE_HEADING);
            stringBuffer.append(serverInfo.getCell());
            stringBuffer.append("/");
            stringBuffer.append(serverInfo.getNode());
            stringBuffer.append("/");
            stringBuffer.append(serverInfo.getName());
            return stringBuffer.toString();
        }
    }

    class ThreadManager {
        private static final int NUMBER_OF_THREADS = 50;
        private QueueConsumerThread[] _threads = new QueueConsumerThread[50];
        private boolean[] _threadWorking = new boolean[50];
        private int _numThreadsWorking;
        private ArrayList _unboundQueues = new ArrayList();
        private HashMap _queueToThread = new HashMap();

        public ThreadManager() {
            for (int i = 0; i < 50; ++i) {
                this._threads[i] = new QueueConsumerThread(this, i);
                this._threadWorking[i] = false;
            }
            this._numThreadsWorking = 0;
        }

        public synchronized void entryAddedToQueues(Queue[] queueArray) {
            int n;
            int n2;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "TM.entryAddedToQueues");
            }
            for (n2 = 0; n2 < queueArray.length && (n = this.indexOfIdleThread()) != -1; ++n2) {
                Queue queue = queueArray[n2];
                if (!this._queueToThread.containsKey(queue)) {
                    QueueConsumerThread queueConsumerThread = this._threads[n];
                    this._queueToThread.put(queue, queueConsumerThread);
                    this._threadWorking[n] = true;
                    ++this._numThreadsWorking;
                    this.removeUnboundQueue(queue);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "TM.entryAdded: Queue " + queue.getQueueNumber() + " bound to thread " + n + ".");
                    }
                    queueConsumerThread.startUp(queue);
                    continue;
                }
                if (!tc.isEntryEnabled()) continue;
                Tr.exit(tc, "TM.entryAdded: Queue already bound", "queue=" + queue.getQueueNumber());
            }
            while (n2 < queueArray.length) {
                Queue queue = queueArray[n2];
                if (!this._queueToThread.containsKey(queue)) {
                    this.addUnboundQueue(queue);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "TM.entryAdded: Queue added to unbound queue list.", "queue=" + queue.getQueueNumber());
                    }
                } else if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "TM.entryAdded: Queue already bound.", "queue=" + queue.getQueueNumber());
                }
                ++n2;
            }
        }

        public synchronized Queue unbindQueue(Queue queue, int n) {
            Queue queue2;
            int n2;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "TM.unbindQueue");
            }
            this._queueToThread.remove(queue);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TM.unbindQueue: Queue " + queue.getQueueNumber() + " unbound from thread " + n + ".");
            }
            if (queue.size() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "TM.unbindQueue: put queue on unbound queue list.");
                }
                this.addUnboundQueue(queue);
            }
            if ((n2 = this._unboundQueues.size()) == 0) {
                this._threadWorking[n] = false;
                --this._numThreadsWorking;
                queue2 = null;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "TM.unbindQueue: No more unbound queues to bind.");
                }
            } else {
                queue2 = (Queue)this._unboundQueues.remove(0);
                this._queueToThread.put(queue2, this._threads[n]);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "TM.unbindQueue: Queue " + queue2.getQueueNumber() + " bound to thread " + n + ".");
                }
            }
            return queue2;
        }

        private int indexOfIdleThread() {
            if (this._numThreadsWorking == 50) {
                Exception exception = new Exception("All downstream server update threads are busy.");
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.event.DownstreamServerManager.ThreadManager.indexOfIdleThread", "993", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "TM.indexOfIdleThread: All threads are busy.");
                }
                return -1;
            }
            for (int i = 0; i < 50; ++i) {
                if (this._threadWorking[i]) continue;
                return i;
            }
            return -1;
        }

        private void addUnboundQueue(Queue queue) {
            int n = this._unboundQueues.indexOf(queue);
            if (n == -1) {
                this._unboundQueues.add(queue);
            }
        }

        private void removeUnboundQueue(Queue queue) {
            int n = this._unboundQueues.indexOf(queue);
            if (n != -1) {
                this._unboundQueues.remove(n);
            }
        }
    }

    class QueueEntry {
        public static final int OP_ADD_DOWNSTREAM_SERVER = 0;
        public static final int OP_REMOVE_DOWNSTREAM_SERVER = 1;
        public static final int OP_UPDATE_LISTENERS = 2;
        private final ServerUpdateOpInfo _opInfo;
        private final int _operation;
        private final ServerInfo _serverInfo;

        public QueueEntry(ServerUpdateOpInfo serverUpdateOpInfo, int n) {
            this._opInfo = serverUpdateOpInfo;
            this._operation = serverUpdateOpInfo.getOperation();
            this._serverInfo = serverUpdateOpInfo.getServerInfo(n);
        }

        public int getOperation() {
            return this._operation;
        }

        public ServerInfo getServerInfo() {
            return this._serverInfo;
        }

        public ServerUpdateOpInfo getServerOpInfo() {
            return this._opInfo;
        }

        public String toString() {
            return "op=" + this._operation + "; serverInfo=" + this._serverInfo;
        }
    }

    class Queue {
        private static final int QUEUE_SIZE_LIMIT = 100;
        private final Vector _queue = new Vector();
        private final ServerInfo _serverInfo;
        private final int _queueNumber;
        private final String TRACE_HEADING;

        public Queue(ServerInfo serverInfo, int n) {
            this._serverInfo = serverInfo;
            this._queueNumber = n;
            this.TRACE_HEADING = "Queue(" + n + "): ";
        }

        public synchronized void addEntry(QueueEntry queueEntry) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, this.TRACE_HEADING + "addEntry", "queueEntry=" + queueEntry);
            }
            if (this._queue.size() == 100) {
                Exception exception = new Exception("QueueHandler: Queue size limit exceeded.  Downstream server update not executed.");
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.event.DownstreamServerManager.Queue.addEntry", "667", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, this.TRACE_HEADING + "Queue limit exceeded.");
                }
                return;
            }
            this._queue.addElement(queueEntry);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, this.TRACE_HEADING + "Queue size: " + this._queue.size());
            }
        }

        public synchronized QueueEntry getNextEntry() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, this.TRACE_HEADING + "getNextEntry");
            }
            QueueEntry queueEntry = this._queue.size() == 0 ? null : (QueueEntry)this._queue.remove(0);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, this.TRACE_HEADING + "getNextEntry", "queueEntry=" + queueEntry);
            }
            return queueEntry;
        }

        public synchronized boolean clear() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, this.TRACE_HEADING + "clear");
            }
            while (this._queue.size() != 0) {
                QueueEntry queueEntry = (QueueEntry)this._queue.get(0);
                if (queueEntry.getOperation() == 0) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, this.TRACE_HEADING + "Queue not cleared.  Add operation is queued.");
                    }
                    return false;
                }
                queueEntry.getServerOpInfo().markServerUpdateComplete(this._queueNumber, null);
                this._queue.remove(0);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, this.TRACE_HEADING + "Queue cleared.");
            }
            return true;
        }

        public synchronized int size() {
            return this._queue.size();
        }

        public ServerInfo getServerInfo() {
            return this._serverInfo;
        }

        public int getQueueNumber() {
            return this._queueNumber;
        }

        public int hashCode() {
            return this._serverInfo.hashCode();
        }
    }

    class QueueManager {
        private HashMap _queues = new HashMap();
        private ThreadManager _threadManager;
        private int _queueNumber = 0;

        public QueueManager(ThreadManager threadManager) {
            this._threadManager = threadManager;
        }

        public synchronized void queueUpOperation(ServerUpdateOpInfo serverUpdateOpInfo) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "QM.queueUpOperation", "op=" + serverUpdateOpInfo.getOperation());
            }
            ServerInfo[] serverInfoArray = serverUpdateOpInfo.getServerInfoList();
            Queue[] queueArray = new Queue[serverInfoArray.length];
            for (int i = 0; i < serverInfoArray.length; ++i) {
                QueueEntry queueEntry = new QueueEntry(serverUpdateOpInfo, i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "QM.queueUpOperation", "serverInfo=" + queueEntry.getServerInfo());
                }
                Queue queue = this.getQueue(queueEntry);
                queue.addEntry(queueEntry);
                queueArray[i] = queue;
            }
            this._threadManager.entryAddedToQueues(queueArray);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "QM.queueUpOperation");
            }
        }

        private Queue getQueue(QueueEntry queueEntry) {
            ServerInfo serverInfo = queueEntry.getServerInfo();
            Queue queue = (Queue)this._queues.get(serverInfo);
            if (queue == null) {
                queue = new Queue(serverInfo, this._queueNumber++);
                this._queues.put(serverInfo, queue);
            }
            return queue;
        }

        public synchronized void removeQueue(ServerInfo serverInfo) {
            Queue queue;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "QM.removeQueue", "serverInfo=" + serverInfo);
            }
            if ((queue = (Queue)this._queues.get(serverInfo)) != null) {
                if (queue.clear()) {
                    this._queues.remove(serverInfo);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "QM.removeQueue: Queue removed.");
                    }
                } else if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "QM.removeQueue: Queue not removed. Entries remain.");
                }
            } else if (tc.isEntryEnabled()) {
                Tr.exit(tc, "QM.removeQueue: Queue does not exist.");
            }
        }
    }

    class ServerUpdateOpInfo {
        public static final int TIMEOUT = 120000;
        public static final int OP_ADD_DOWNSTREAM_SERVER = 0;
        public static final int OP_REMOVE_DOWNSTREAM_SERVER = 1;
        public static final int OP_UPDATE_LISTENERS = 2;
        private final int _operation;
        private final ServerInfo[] _serverInfoList;
        private int _numUpdatesComplete = 0;
        private ConnectorException _connExc = null;

        public ServerUpdateOpInfo(int n, ServerInfo[] serverInfoArray) {
            this._operation = n;
            this._serverInfoList = serverInfoArray;
        }

        public ServerUpdateOpInfo(int n, ServerInfo serverInfo) {
            this._operation = n;
            this._serverInfoList = new ServerInfo[1];
            this._serverInfoList[0] = serverInfo;
        }

        public int getOperation() {
            return this._operation;
        }

        public ServerInfo[] getServerInfoList() {
            return this._serverInfoList;
        }

        public ServerInfo getServerInfo(int n) {
            return this._serverInfoList[n];
        }

        public synchronized boolean waitForRequestToComplete() throws ConnectorException {
            block11: {
                try {
                    if (this._connExc == null && this._numUpdatesComplete < this._serverInfoList.length) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "OpInfo: Waiting for update to complete.");
                        }
                        if (this._operation == 0) {
                            this.wait();
                        } else {
                            this.wait(120000L);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!tc.isDebugEnabled()) break block11;
                    Tr.debug(tc, "OpInfo: received exception on wait for completion.", interruptedException);
                }
            }
            if (this._connExc != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "OpInfo: Finished waiting.  Throwing ConnectorException.");
                }
                throw this._connExc;
            }
            if (this._numUpdatesComplete == this._serverInfoList.length) {
                if (tc.isDebugEnabled() && this._serverInfoList.length > 0) {
                    Tr.debug(tc, "OpInfo: Finished.  All server updates have completed.");
                }
                return true;
            }
            Exception exception = new Exception("Finished waiting.  Timeout occurred while waiting for downstream server  updates to complete.");
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.event.DownstreamServerManager.ServerUpdateOpInfo.waitForRequestToComplete", "484", this);
            if (tc.isEventEnabled()) {
                Tr.event(tc, "OpInfo: Finished waiting.  Not all server updates have completed.  Missing notifications could result.");
            }
            return false;
        }

        public synchronized void markServerUpdateComplete(int n, ConnectorException connectorException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "OpInfo: Server update on queue Q" + n + " has completed.");
            }
            this._connExc = connectorException;
            ++this._numUpdatesComplete;
            if (connectorException != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "OpInfo: Server update exception: " + connectorException);
                }
                this.notify();
            } else if (this._numUpdatesComplete == this._serverInfoList.length) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "OpInfo: All server updates have completed.");
                }
                this.notify();
            }
        }
    }

    class DSMEntry {
        ConsolidatedFilter filter;
        ListenerIdentifier listenerId;

        DSMEntry(ConsolidatedFilter consolidatedFilter, ListenerIdentifier listenerIdentifier) {
            this.filter = consolidatedFilter;
            this.listenerId = listenerIdentifier;
        }

        public String toString() {
            return "DSMEntry:[listenerId=" + this.listenerId + ";filter=" + this.filter + "]";
        }
    }
}

