/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.event.NotificationInfo;
import com.ibm.ws.management.event.WsNotifListener;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.management.util.SecurityServiceMonitor;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public class ListenerInfo
implements WsNotifListener {
    private static TraceComponent _tc = Tr.register(ListenerInfo.class, "Admin", "com.ibm.ws.management.event");
    private final NotificationInfo _ntfyInfo;
    private final NotificationListener _listener;
    private final Object _handback;
    private final SecurityServiceMonitor _sh;
    private final Subject _listenerSubject;
    private final boolean _initPhaseRuntimeListener;

    ListenerInfo(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        boolean bl;
        Subject subject;
        block5: {
            this._sh = this.getSecurityMonitor();
            this._ntfyInfo = new NotificationInfo(objectName, notificationFilter);
            this._listener = notificationListener;
            this._handback = object;
            subject = null;
            bl = false;
            try {
                subject = SecurityHelper.retrieveSubject();
                if (subject == null) {
                    bl = this.isInitPhaseRuntimeListener();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "ListenerInfo: subject is null.", "runtimeInit=" + bl);
                    }
                } else {
                    Tr.debug(_tc, "ListenerInfo: subject is not null.");
                }
            }
            catch (Throwable throwable) {
                if (!_tc.isEventEnabled()) break block5;
                Tr.event(_tc, "ListenerInfo: could not obtain subject.  Listener will be invoked with no credentials.", throwable);
            }
        }
        this._initPhaseRuntimeListener = bl;
        this._listenerSubject = subject;
    }

    protected SecurityServiceMonitor getSecurityMonitor() {
        return SecurityHelper.getHelper();
    }

    public ObjectName getObjectName() {
        return this._ntfyInfo.getName();
    }

    public NotificationFilter getNotificationFilter() {
        return this._ntfyInfo.getFilter();
    }

    public NotificationListener getNotificationListener() {
        return this._listener;
    }

    public Object getHandback() {
        return this._handback;
    }

    public boolean isNotificationEnabled(Notification notification) {
        return this._ntfyInfo.isNotificationEnabled(notification);
    }

    public void handleNotification(Notification notification) {
        if (this.isNotificationEnabled(notification)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Listener enabled");
            }
            if (this._sh.isSecurityServiceStarted() && this._sh.isSecurityServiceStopped()) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "Security Server was running but has been stopped.  Listener NOT invoked", new String[]{"Listener=" + this._listener, "Notification=" + notification});
                }
                return;
            }
            final Notification notification2 = notification;
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ListenerInfo.this._listener.handleNotification(notification2, ListenerInfo.this._handback);
                    return null;
                }
            };
            try {
                ContextManager contextManager = ContextManagerFactory.getInstance();
                if (this._initPhaseRuntimeListener) {
                    contextManager.runAsSystem(privilegedExceptionAction);
                } else {
                    contextManager.runAsSpecified(this._listenerSubject, privilegedExceptionAction);
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Exception occurred from handleNotification call.", new Object[]{this._ntfyInfo.getName(), this._handback, privilegedActionException.getException()});
                }
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), "com.ibm.ws.management.event.ListenerInfo.handleNotification", "158", this);
            }
            catch (Throwable throwable) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Exception occurred setting up handleNotification call.", new Object[]{this._ntfyInfo.getName(), this._handback, throwable});
                }
                FFDCFilter.processException(throwable, "com.ibm.ws.management.event.ListenerInfo.handleNotification", "165", this);
            }
        }
    }

    public boolean containsName(ObjectName objectName) {
        return this._ntfyInfo.containsName(objectName);
    }

    public boolean isMatching(ObjectName objectName, NotificationListener notificationListener) {
        return (objectName == null || this._ntfyInfo.getName().equals(objectName)) && this._listener.equals(notificationListener);
    }

    public boolean isMatching(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        return (objectName == null || this._ntfyInfo.getName().equals(objectName)) && this._listener.equals(notificationListener) && this._ntfyInfo.getFilter().equals(notificationFilter) && this._handback.equals(object);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object == null) {
            bl = false;
        } else {
            try {
                ListenerInfo listenerInfo = (ListenerInfo)object;
                if (this._listener.equals(listenerInfo._listener) && this._ntfyInfo.getName().equals(listenerInfo._ntfyInfo.getName())) {
                    bl = this._handback == null && listenerInfo._handback == null ? true : (this._handback == null && listenerInfo._handback != null || this._handback != null && listenerInfo._handback == null ? false : this._handback.equals(listenerInfo._handback));
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = 0;
        if (this._listener != null) {
            n += this._listener.hashCode();
        }
        if (this._handback != null) {
            n += this._handback.hashCode();
        }
        if (this._ntfyInfo.getName() != null) {
            n += this._ntfyInfo.getName().hashCode();
        }
        return n;
    }

    public String toString() {
        return "ListenerInfo: [listener=" + this._listener + ";ntfyInfo=" + this._ntfyInfo + ";handback=" + this._handback + "]";
    }

    private boolean isInitPhaseRuntimeListener() {
        if (AdminServiceFactory.getAdminService() == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ListenerInfo: client process.");
            }
            return false;
        }
        if (this._sh.isSecurityServiceStarted() && !this._sh.isSecurityServiceStopped()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ListenerInfo: security service is started.");
            }
            return false;
        }
        return true;
    }
}

