/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.PlatformMBeanServer;
import com.ibm.ws.management.event.NotificationService;
import com.ibm.ws.management.event.WsNotifDelegator;
import com.ibm.ws.management.event.WsNotifListener;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;

class MBeanServerDelegateListener
extends WsNotifDelegator
implements NotificationListener {
    private static TraceComponent tc = Tr.register(MBeanServerDelegateListener.class, "Admin", "com.ibm.ws.management.resources.event");

    public MBeanServerDelegateListener(MBeanServer mBeanServer, WsNotifListener wsNotifListener) {
        super(wsNotifListener);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        try {
            ObjectName objectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
            mBeanServer.addNotificationListener(objectName, this, null, (Object)this);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            FFDCFilter.processException((Throwable)malformedObjectNameException, "com.ibm.ws.management.event.LocalNotificationListener.LocalNotificationListener", "57", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to construct object name for mbeanserver", malformedObjectNameException);
            }
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, "com.ibm.ws.management.event.LocalNotificationListener.LocalNotificationListener", "63", this);
            Tr.warning(tc, "ADME0003W", instanceNotFoundException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public void handleNotification(Notification notification, Object object) {
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handleNotification", new Object[]{NotificationService.getInfo(notification), object});
            }
            if (object == this) {
                MBeanServerNotification mBeanServerNotification = (MBeanServerNotification)notification;
                ObjectName objectName = mBeanServerNotification.getMBeanName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "MBean activated:", objectName);
                }
                try {
                    MBeanNotificationInfo[] mBeanNotificationInfoArray;
                    if (!mBeanServerNotification.getType().equals("JMX.mbean.registered")) break block17;
                    MBeanServer mBeanServer = AdminServiceFactory.getAdminService().getMBeanFactory().getMBeanServer();
                    if (mBeanServer instanceof PlatformMBeanServer) {
                        mBeanServer = ((PlatformMBeanServer)mBeanServer).getDefaultMBeanServer();
                    }
                    if ((mBeanNotificationInfoArray = mBeanServer.getMBeanInfo(objectName).getNotifications()) != null) {
                        if (mBeanNotificationInfoArray.length > 0) {
                            mBeanServer.addNotificationListener(objectName, this, null, (Object)objectName);
                        } else if (mBeanNotificationInfoArray.length == 0 && mBeanServer.isInstanceOf(objectName, "javax.management.NotificationBroadcaster")) {
                            mBeanServer.addNotificationListener(objectName, this, null, (Object)objectName);
                        }
                    }
                    break block17;
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    FFDCFilter.processException((Throwable)instanceNotFoundException, "com.ibm.ws.management.event.LocalNotificationListener.handleNotification", "100", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "unexpected exception is thrown", instanceNotFoundException);
                    }
                    break block17;
                }
                catch (IntrospectionException introspectionException) {
                    FFDCFilter.processException((Throwable)introspectionException, "com.ibm.ws.management.event.LocalNotificationListener.handleNotification", "112", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "unexpected exception is thrown", introspectionException);
                    }
                    break block17;
                }
                catch (ReflectionException reflectionException) {
                    FFDCFilter.processException((Throwable)reflectionException, "com.ibm.ws.management.event.LocalNotificationListener.handleNotification", "118", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "unexpected exception is thrown", reflectionException);
                    }
                    break block17;
                }
            }
            if (object instanceof ObjectName) {
                notification.setSource(object);
            }
        }
        this.handleNotification(notification);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }
}

