/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.event.ListenerInfo;
import com.ibm.ws.management.event.ReceiverPermanentlyUnavailableException;
import com.ibm.ws.management.event.WsNotifListener;
import com.ibm.ws.management.event.WsNotifListenerContainer;
import com.ibm.ws.management.event.WsStickyListener;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws.util.ThreadPool;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.security.auth.Subject;

public class NotificationDispatcher
implements WsNotifListener {
    private static TraceComponent tc = Tr.register(NotificationDispatcher.class, "Admin", "com.ibm.ws.management.resources.event");
    public static final String[] ASYNC_NOTIFS = new String[]{"websphere.ras"};
    private final ThreadPool dispatchPool;
    private final WsNotifListenerContainer container;
    private final WsNotifListener[] listeners;
    private final boolean removeNonresponsiveListeners;
    private static int _nextNotifDispatcherID = 1;
    private final String _ndIDString;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationDispatcher(WsNotifListenerContainer wsNotifListenerContainer, WsNotifListener[] wsNotifListenerArray, boolean bl, ThreadPool threadPool) {
        this.container = wsNotifListenerContainer;
        this.listeners = wsNotifListenerArray;
        this.removeNonresponsiveListeners = bl;
        this.dispatchPool = threadPool;
        NotificationDispatcher notificationDispatcher = this;
        synchronized (notificationDispatcher) {
            this._ndIDString = "(ndID=" + _nextNotifDispatcherID++ + ")";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "NotificationDispatcher: " + this._ndIDString);
        }
    }

    public boolean isNotificationEnabled(Notification notification) {
        return true;
    }

    public void handleNotification(Notification notification) {
        if (this.listeners.length > 0) {
            new DispatchANotificationToAllListeners(notification).dispatch();
        }
    }

    void sendWarningInSeparateThread(String string, Object[] objectArray) {
        this.sendTrInSeparateThread(false, string, objectArray);
    }

    void sendErrorInSeparateThread(String string, Object[] objectArray) {
        this.sendTrInSeparateThread(true, string, objectArray);
    }

    private void sendTrInSeparateThread(final boolean bl, final String string, final Object[] objectArray) {
        try {
            this.dispatchPool.execute(new Runnable(){

                public void run() {
                    if (bl) {
                        Tr.error(tc, string, objectArray);
                    } else {
                        Tr.warning(tc, string, objectArray);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    class DispatchANotificationToAListener
    implements Runnable {
        private int listenerId;
        private Notification notif;
        private DispatchANotificationToAllListeners dispatcher;
        private Subject subject;

        public DispatchANotificationToAListener(int n, Notification notification, DispatchANotificationToAllListeners dispatchANotificationToAllListeners) {
            this.listenerId = n;
            this.notif = notification;
            this.dispatcher = dispatchANotificationToAllListeners;
        }

        public void run() {
            this.setServerCredentials();
            WsNotifListener wsNotifListener = NotificationDispatcher.this.listeners[this.listenerId];
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, NotificationDispatcher.this._ndIDString + ": Dispatching to listener #" + this.listenerId + " notification " + this.notif, wsNotifListener);
            }
            try {
                wsNotifListener.handleNotification(this.notif);
            }
            catch (ReceiverPermanentlyUnavailableException receiverPermanentlyUnavailableException) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, NotificationDispatcher.this._ndIDString + ": Removing listener #" + this.listenerId + " because of ReceiverPermanentlyUnavailableException.", receiverPermanentlyUnavailableException);
                }
                FFDCFilter.processException((Throwable)receiverPermanentlyUnavailableException, "com.ibm.ws.management.event.NotificationDispatcher.run", "219", this);
                NotificationDispatcher.this.container.removeListener(wsNotifListener);
            }
            catch (Throwable throwable) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, NotificationDispatcher.this._ndIDString + ": Error occurred notifying listener #" + this.listenerId + ".", throwable);
                }
                NotificationDispatcher.this.sendWarningInSeparateThread("ADME0006W", new Object[]{this.notif, wsNotifListener, throwable});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, NotificationDispatcher.this._ndIDString + ": Returned from listener #" + this.listenerId);
            }
            this.unsetServerCredentials();
            this.dispatcher.markComplete(this.listenerId);
        }

        private void setServerCredentials() {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    DispatchANotificationToAListener.this.subject = SecurityHelper.getServerSubject();
                    if (DispatchANotificationToAListener.this.subject != null) {
                        SecurityHelper.pushInvocationSubject(DispatchANotificationToAListener.this.subject);
                    }
                    return null;
                }
            });
        }

        private void unsetServerCredentials() {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (DispatchANotificationToAListener.this.subject != null) {
                        SecurityHelper.popInvocationSubject(DispatchANotificationToAListener.this.subject);
                    }
                    return null;
                }
            });
        }
    }

    class DispatchANotificationToAllListeners {
        private final Notification notif;
        private boolean[] completeRegistry;
        private int numListenersDispatched;
        private int numListenersReturned;
        private final long timeout;

        public DispatchANotificationToAllListeners(Notification notification) {
            this.notif = notification;
            this.completeRegistry = new boolean[NotificationDispatcher.this.listeners.length];
            this.timeout = (Long)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Long.getLong("com.ibm.ws.management.event.LocalNotificationService.handleNotificationTimeout", 300000L);
                }
            });
        }

        public void dispatch() {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, NotificationDispatcher.this._ndIDString + ": Emitting to " + NotificationDispatcher.this.listeners.length + " listeners: " + this.notif);
                for (int i = 0; i < NotificationDispatcher.this.listeners.length; ++i) {
                    Tr.debug(tc, NotificationDispatcher.this._ndIDString + ": " + i + ": " + NotificationDispatcher.this.listeners[i]);
                }
            }
            this.numListenersDispatched = 0;
            this.numListenersReturned = 0;
            if (this.executeDispatchers() && !this.isAsyncNotif()) {
                this.waitForDispatchers();
                if (!this.isNotificationComplete() && NotificationDispatcher.this.removeNonresponsiveListeners) {
                    this.removeUncompletedListeners();
                }
            }
        }

        private boolean executeDispatchers() {
            for (int i = 0; i < NotificationDispatcher.this.listeners.length; ++i) {
                if (NotificationDispatcher.this.listeners[i].isNotificationEnabled(this.notif)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, NotificationDispatcher.this._ndIDString + ": Listener #" + i + " is enabled");
                    }
                    try {
                        NotificationDispatcher.this.dispatchPool.execute(new DispatchANotificationToAListener(i, this.notif, this));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++this.numListenersDispatched;
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, NotificationDispatcher.this._ndIDString + ": Listener #" + i + " not enabled");
                }
                this.completeRegistry[i] = true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, NotificationDispatcher.this._ndIDString + ": Dispatched to " + this.numListenersDispatched + " listeners");
            }
            return this.numListenersDispatched > 0;
        }

        private boolean isAsyncNotif() {
            String string = this.notif.getType();
            for (int i = 0; i < ASYNC_NOTIFS.length; ++i) {
                if (!string.startsWith(ASYNC_NOTIFS[i])) continue;
                return true;
            }
            return false;
        }

        private synchronized void waitForDispatchers() {
            if (this.isNotificationComplete()) {
                return;
            }
            try {
                this.wait(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, NotificationDispatcher.this._ndIDString + ": Finished emitting notification");
            }
        }

        private boolean isNotificationComplete() {
            return this.numListenersReturned >= this.numListenersDispatched;
        }

        private void removeUncompletedListeners() {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, NotificationDispatcher.this._ndIDString + ": Some listeners not complete -- removing");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < this.completeRegistry.length; ++i) {
                NotificationListener notificationListener;
                if (this.completeRegistry[i]) continue;
                WsNotifListener wsNotifListener = NotificationDispatcher.this.listeners[i];
                if (wsNotifListener instanceof ListenerInfo && (notificationListener = ((ListenerInfo)wsNotifListener).getNotificationListener()) instanceof WsStickyListener && ((WsStickyListener)((Object)notificationListener)).checkNotification(this.notif)) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Listener #" + i + " is sticky listener, not removed");
                    continue;
                }
                NotificationDispatcher.this.container.removeListener(wsNotifListener);
                arrayList.add(wsNotifListener.toString());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, NotificationDispatcher.this._ndIDString + ": " + arrayList.size() + " listeners removed");
            }
            if (!arrayList.isEmpty()) {
                this.sendListenersRemovedError(arrayList);
            }
        }

        private void sendListenersRemovedError(List list) {
            String string = Long.toString(this.timeout);
            String string2 = this.notif.getType();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                NotificationDispatcher.this.sendErrorInSeparateThread("ADME0005E", new Object[]{string2, string, iterator.next()});
            }
        }

        synchronized void markComplete(int n) {
            this.completeRegistry[n] = true;
            ++this.numListenersReturned;
            if (this.isNotificationComplete()) {
                this.notify();
            }
        }
    }
}

