/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.DownstreamProcessManager;
import com.ibm.ws.management.event.DownstreamServerManager;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.MBeanServerDelegateListener;
import com.ibm.ws.management.event.NotificationDispatcher;
import com.ibm.ws.management.event.NullDownstreamProcessManager;
import com.ibm.ws.management.event.ProcessListener;
import com.ibm.ws.management.event.PullRemoteSender;
import com.ibm.ws.management.event.PushNotificationListener;
import com.ibm.ws.management.event.PushRemoteSender;
import com.ibm.ws.management.event.PushUpstreamServerSender;
import com.ibm.ws.management.event.RemoteNotificationBroadcaster;
import com.ibm.ws.management.event.RemoteSender;
import com.ibm.ws.management.event.WsNotifListener;
import com.ibm.ws.management.event.WsNotifListenerContainer;
import com.ibm.ws.management.event.ZControlNotificationManager;
import com.ibm.ws.management.event.ZServantListener;
import com.ibm.ws.management.event.ZServantNotificationManager;
import com.ibm.ws.management.exception.ReceiverNotFoundException;
import com.ibm.ws.util.ThreadPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.Notification;

public class NotificationService
implements WsNotifListener,
WsNotifListenerContainer,
RemoteNotificationBroadcaster {
    private static TraceComponent tc = Tr.register(NotificationService.class, "Admin", "com.ibm.ws.management.resources.event");
    private static final int DISPATCH_POOL_MIN = 1;
    private static final int DISPATCH_POOL_MAX = 100;
    private List listeners;
    private NotificationDispatcher dispatcher;
    private ThreadPool dispatchPool;
    private boolean listenersUpdated = true;
    private Map remoteSenders = new HashMap();
    private DownstreamProcessManager downstreamManager;
    private PushRemoteSender upstreamServerSender;
    private Object upstreamServerSenderLock = new Object();
    private DownstreamProcessManager servantProcessManager = null;
    private ListenerIdentifier controlJVMid = null;

    public NotificationService(MBeanServer mBeanServer) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.listeners = new ArrayList();
        if (AdminHelper.getPlatformHelper().isZOS()) {
            String string = AdminServiceFactory.getAdminService().getProcessType();
            if (AdminHelper.getPlatformHelper().isServantJvm()) {
                this.downstreamManager = new ZControlNotificationManager();
            } else if (string.equals("DeploymentManager") || string.equals("NodeAgent")) {
                this.downstreamManager = new DownstreamServerManager();
                new ProcessListener(this);
            } else {
                this.downstreamManager = new NullDownstreamProcessManager();
            }
            if (AdminHelper.getPlatformHelper().isControlJvm() && !string.equals("NodeAgent")) {
                this.servantProcessManager = new ZServantNotificationManager();
                new ZServantListener(this);
            }
            new MBeanServerDelegateListener(mBeanServer, this);
        } else {
            this.downstreamManager = new DownstreamServerManager();
            new MBeanServerDelegateListener(mBeanServer, this);
            new ProcessListener(this);
        }
        this.dispatchPool = new ThreadPool("NotificationServiceDispatcher", 1, 100);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public ListenerIdentifier addNotificationListener(ConsolidatedFilter consolidatedFilter, PushNotificationListener pushNotificationListener) {
        RemoteSender remoteSender;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNotificationListener", new Object[]{consolidatedFilter, pushNotificationListener});
        }
        if (pushNotificationListener == null) {
            remoteSender = new PullRemoteSender();
        } else {
            remoteSender = new PushRemoteSender(pushNotificationListener);
            if (pushNotificationListener instanceof PushUpstreamServerSender) {
                this.replaceUpstreamServerSender((PushRemoteSender)remoteSender);
            }
        }
        remoteSender.setFilter(consolidatedFilter);
        this.addListener(remoteSender);
        ListenerIdentifier listenerIdentifier = remoteSender.getIdentifier();
        this.downstreamManager.setFilter(listenerIdentifier, consolidatedFilter);
        if (AdminHelper.getPlatformHelper().isZOS() && this.servantProcessManager != null) {
            this.servantProcessManager.setFilter(listenerIdentifier, consolidatedFilter);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNotificationListener", listenerIdentifier);
        }
        return listenerIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(WsNotifListener wsNotifListener) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addListener", wsNotifListener);
        }
        Map map = this.remoteSenders;
        synchronized (map) {
            object = null;
            try {
                object = ((RemoteSender)wsNotifListener).getIdentifier();
                this.remoteSenders.put(object, wsNotifListener);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        boolean bl = false;
        object = this.listeners;
        synchronized (object) {
            bl = this.listeners.add(wsNotifListener);
        }
        if (bl) {
            this.listenersUpdated = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addListener", new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(WsNotifListener wsNotifListener) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeListener", wsNotifListener);
        }
        Map map = this.remoteSenders;
        synchronized (map) {
            object = null;
            try {
                object = ((RemoteSender)wsNotifListener).getIdentifier();
                RemoteSender remoteSender = (RemoteSender)this.remoteSenders.remove(object);
                if (remoteSender != null) {
                    remoteSender.stop();
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        boolean bl = false;
        object = this.listeners;
        synchronized (object) {
            bl = this.listeners.remove(wsNotifListener);
        }
        if (bl) {
            this.listenersUpdated = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeListener", new Boolean(bl));
        }
        return bl;
    }

    public boolean isNotificationEnabled(Notification notification) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification notification) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotification", NotificationService.getInfo(notification));
        }
        Object var2_2 = null;
        if (this.listenersUpdated) {
            List list = this.listeners;
            synchronized (list) {
                WsNotifListener[] wsNotifListenerArray = null;
                if (AdminHelper.getPlatformHelper().isZOS() && this.getControlJVMListener() != null) {
                    wsNotifListenerArray = new WsNotifListener[]{this.getControlJVMListener()};
                } else {
                    wsNotifListenerArray = new WsNotifListener[this.listeners.size()];
                    wsNotifListenerArray = this.listeners.toArray(wsNotifListenerArray);
                }
                this.dispatcher = new NotificationDispatcher(this, wsNotifListenerArray, false, this.dispatchPool);
            }
        }
        this.dispatcher.handleNotification(notification);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRemoteNotification(Notification notification) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRemoteNotification", NotificationService.getInfo(notification));
        }
        if (this.listenersUpdated) {
            List list = this.listeners;
            synchronized (list) {
                WsNotifListener wsNotifListener = this.getControlJVMListener();
                WsNotifListener[] wsNotifListenerArray = null;
                if (wsNotifListener != null) {
                    boolean bl = false;
                    ArrayList<WsNotifListener> arrayList = new ArrayList<WsNotifListener>();
                    Iterator iterator = this.listeners.iterator();
                    while (iterator.hasNext()) {
                        WsNotifListener wsNotifListener2 = (WsNotifListener)iterator.next();
                        if (wsNotifListener2 == wsNotifListener) {
                            bl = true;
                            continue;
                        }
                        arrayList.add(wsNotifListener2);
                    }
                    wsNotifListenerArray = arrayList.toArray(new WsNotifListener[arrayList.size()]);
                    if (tc.isDebugEnabled() && !bl) {
                        Tr.debug(tc, "unable to find control JVM listener");
                    }
                } else {
                    wsNotifListenerArray = new WsNotifListener[this.listeners.size()];
                    wsNotifListenerArray = this.listeners.toArray(wsNotifListenerArray);
                }
                this.dispatcher = new NotificationDispatcher(this, wsNotifListenerArray, false, this.dispatchPool);
            }
        }
        this.dispatcher.handleNotification(notification);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRemoteNotification");
        }
    }

    public ListenerIdentifier addControlNotificationListener(ConsolidatedFilter consolidatedFilter, PushNotificationListener pushNotificationListener) {
        ListenerIdentifier listenerIdentifier;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addControlNotificationListener", new Object[]{consolidatedFilter, pushNotificationListener});
        }
        RemoteSender remoteSender = pushNotificationListener == null ? new PullRemoteSender() : new PushRemoteSender(pushNotificationListener);
        remoteSender.setFilter(consolidatedFilter);
        this.addListener(remoteSender);
        this.controlJVMid = listenerIdentifier = remoteSender.getIdentifier();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addControlNotificationListener", listenerIdentifier);
        }
        return listenerIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceUpstreamServerSender(PushRemoteSender pushRemoteSender) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "replaceUpstreamServerSender");
        }
        Object object = this.upstreamServerSenderLock;
        synchronized (object) {
            if (this.upstreamServerSender != null) {
                try {
                    this.removeNotificationListener(this.upstreamServerSender.getIdentifier());
                }
                catch (ReceiverNotFoundException receiverNotFoundException) {
                    // empty catch block
                }
            }
            this.upstreamServerSender = pushRemoteSender;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "replaceUpstreamServerSender");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ListenerIdentifier listenerIdentifier) throws ReceiverNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener", listenerIdentifier);
        }
        RemoteSender remoteSender = null;
        Map map = this.remoteSenders;
        synchronized (map) {
            remoteSender = (RemoteSender)this.remoteSenders.get(listenerIdentifier);
        }
        if (remoteSender == null) {
            throw new ReceiverNotFoundException(listenerIdentifier);
        }
        this.removeListener(remoteSender);
        if (!AdminHelper.getPlatformHelper().isZOS()) {
            this.downstreamManager.unsetFilter(listenerIdentifier);
        } else {
            if (listenerIdentifier != null && listenerIdentifier.equals(this.controlJVMid)) {
                this.controlJVMid = null;
            } else {
                this.downstreamManager.unsetFilter(listenerIdentifier);
            }
            if (this.servantProcessManager != null) {
                this.servantProcessManager.unsetFilter(listenerIdentifier);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetFilter(ListenerIdentifier listenerIdentifier, ConsolidatedFilter consolidatedFilter) throws ReceiverNotFoundException {
        RemoteSender remoteSender;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetFilter", new Object[]{listenerIdentifier, consolidatedFilter});
        }
        Map map = this.remoteSenders;
        synchronized (map) {
            remoteSender = (RemoteSender)this.remoteSenders.get(listenerIdentifier);
        }
        if (remoteSender == null) {
            throw new ReceiverNotFoundException(listenerIdentifier);
        }
        remoteSender.setFilter(consolidatedFilter);
        if (!AdminHelper.getPlatformHelper().isZOS()) {
            this.downstreamManager.setFilter(listenerIdentifier, consolidatedFilter);
        } else {
            if (listenerIdentifier == null || !listenerIdentifier.equals(this.controlJVMid)) {
                this.downstreamManager.setFilter(listenerIdentifier, consolidatedFilter);
            }
            if (this.servantProcessManager != null) {
                this.servantProcessManager.setFilter(listenerIdentifier, consolidatedFilter);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetFilter");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Notification[] pullNotifications(ListenerIdentifier listenerIdentifier, Integer n) throws ReceiverNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pullNotifications", new Object[]{listenerIdentifier, n});
        }
        Notification[] notificationArray = this.remoteSenders;
        synchronized (this.remoteSenders) {
            PullRemoteSender pullRemoteSender = (PullRemoteSender)this.remoteSenders.get(listenerIdentifier);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (pullRemoteSender == null) {
                throw new ReceiverNotFoundException(listenerIdentifier);
            }
            notificationArray = pullRemoteSender.pullNotifications(n);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "pullNotifications");
            }
            return notificationArray;
        }
    }

    public void stopUpstreamServerSending() {
    }

    public void restartUpstreamServerSending() {
    }

    public DownstreamProcessManager getDownstreamProcessManager() {
        return this.downstreamManager;
    }

    public DownstreamServerManager getDownstreamServerManager() {
        return (DownstreamServerManager)this.downstreamManager;
    }

    public DownstreamProcessManager getServantProcessManager() {
        return this.servantProcessManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WsNotifListener getControlJVMListener() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getControlJVMListener");
        }
        WsNotifListener wsNotifListener = null;
        Map map = this.remoteSenders;
        synchronized (map) {
            wsNotifListener = (WsNotifListener)this.remoteSenders.get(this.controlJVMid);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getControlJVMListener", wsNotifListener);
        }
        return wsNotifListener;
    }

    public static String getInfo(Notification notification) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(notification.getType());
        stringBuffer.append(" [source=" + notification.getSource());
        stringBuffer.append(",userData=" + notification.getUserData() + "]");
        return stringBuffer.toString();
    }

    public static String getInfo(Notification[] notificationArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        for (int i = 0; i < notificationArray.length; ++i) {
            stringBuffer.append(NotificationService.getInfo(notificationArray[i]));
            if (i + 1 >= notificationArray.length) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "NotificationService";
    }
}

