/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.RoutingListener;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.discovery.ServerInfo;
import com.ibm.ws.management.event.NotificationService;

public class ProcessListener
implements RoutingListener {
    private static TraceComponent tc = Tr.register(ProcessListener.class, "Admin", "com.ibm.ws.management.resources.event");
    private NotificationService notifService;

    public ProcessListener(NotificationService notificationService) {
        this.notifService = notificationService;
        RoutingTable.getInstance().addRoutingListener(this);
    }

    public void childAdded(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "childAdded", serverInfo);
        }
        if (!this.isDownlevelServer(serverInfo)) {
            try {
                this.notifService.getDownstreamProcessManager().addDownstreamProcess(serverInfo);
            }
            catch (ConnectorException connectorException) {
                FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.event.ProcessListener.childAdded", "79", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "childAdded");
        }
    }

    private boolean isDownlevelServer(ServerInfo serverInfo) {
        return serverInfo.getVersion().equals("5.0");
    }

    public void childRemoved(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "childRemoved", serverInfo);
        }
        if (!this.isDownlevelServer(serverInfo)) {
            try {
                this.notifService.getDownstreamProcessManager().removeDownstreamProcess(serverInfo);
            }
            catch (ConnectorException connectorException) {
                FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.event.ProcessListener.childRemoved", "107", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "childRemoved");
        }
    }

    public void parentAdded(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parentAdded", serverInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parentAdded");
        }
    }

    public void parentRemoved(ServerInfo serverInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parentRemoved", serverInfo);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "parentRemoved");
        }
    }
}

