/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.connector.AdminServiceProxy;
import com.ibm.ws.management.event.RemoteReceiver;
import com.ibm.ws.management.exception.ReceiverNotFoundException;
import javax.management.Notification;

public class PullRemoteReceiver
extends RemoteReceiver
implements AlarmListener {
    private static TraceComponent tc = Tr.register(PullRemoteReceiver.class, "Admin", "com.ibm.ws.management.resources.event");
    private static final int BATCH_SIZE = 20;
    static final int MAX_WAIT_TIME = 20000;
    private static final int MIN_WAIT_TIME = 500;
    private static final float MAX_RATE_DECREASE = 0.75f;
    private static final float IDEAL_RATE = 0.05f;
    private static final float RATE_CHANGE_MULTIPLIER = 10.0f;
    private int waitTime = 3000;
    private Alarm pullAlarm = null;
    private long alarmId = 0L;

    public PullRemoteReceiver(AdminServiceProxy adminServiceProxy) {
        super(adminServiceProxy);
    }

    public void alarm(Object object) {
        this.getNotifications(object);
    }

    protected void unsubscribe() throws ReceiverNotFoundException, ConnectorException {
        super.unsubscribe();
        this.pullAlarm.cancel();
    }

    protected void subscribe() throws ConnectorException {
        super.subscribe();
        this.registerAlarm(0, new Long(++this.alarmId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getNotifications(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNotifications");
        }
        if (this.getListenerId() == null) {
            return;
        }
        try {
            float f = 0.0f;
            float f2 = 0.0f;
            do {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Pulling 20 notifications from ListenerId " + this.getListenerId());
                }
                Notification[] notificationArray = this.getRemoteNotificationService().pullNotifications(this.getListenerId(), new Integer(20));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got " + notificationArray.length + " notifications");
                }
                for (int i = 0; i < notificationArray.length; ++i) {
                    this.handleNotification(notificationArray[i]);
                }
                f = (float)notificationArray.length / 20.0f;
                f2 += f;
            } while ((double)f >= 1.0);
            this.adjustWaitTime(f2);
        }
        catch (ReceiverNotFoundException receiverNotFoundException) {
            FFDCFilter.processException((Throwable)receiverNotFoundException, "com.ibm.ws.management.event.PullRemoteReceiver.getNotifications", "132", this);
            try {
                if (this.isActive() && object.equals(new Long(this.alarmId))) {
                    this.subscribe();
                }
            }
            catch (ConnectorException connectorException) {
                FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.event.PullRemoteReceiver.getNotifications", "137", this);
            }
        }
        catch (ConnectorException connectorException) {
            FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.event.PullRemoteReceiver.getNotifications", "141", this);
        }
        finally {
            if (this.isActive() && object.equals(new Long(this.alarmId))) {
                this.registerAlarm(this.waitTime, object);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNotifications");
        }
    }

    private void adjustWaitTime(float f) {
        int n = this.waitTime;
        float f2 = f - 0.05f;
        f2 = f2 > 0.0f ? 1.0f + f2 * 10.0f : (f2 == 0.0f ? 1.0f : f);
        this.waitTime = Math.min(20000, (int)Math.max(500.0f, (float)this.waitTime / Math.max(0.75f, f2)));
        if (tc.isDebugEnabled() && n != this.waitTime) {
            Tr.debug(tc, "Rate = " + f2 + "; wait time adjusted from " + n + "ms to " + this.waitTime + "ms");
        }
    }

    private void registerAlarm(int n, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerAlarm", new Object[]{new Integer(n), object});
        }
        this.pullAlarm = AlarmManager.createNonDeferrable(n, this, object);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerAlarm");
        }
    }

    private void cancelAlarm() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cancelAlarm");
        }
        this.pullAlarm.cancel();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cancelAlarm");
        }
    }
}

