/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.event.ReceiverPermanentlyUnavailableException;
import com.ibm.ws.management.event.RemoteSender;
import javax.management.Notification;

public class PullRemoteSender
extends RemoteSender
implements AlarmListener {
    private static TraceComponent tc = Tr.register(PullRemoteSender.class, "Admin", "com.ibm.ws.management.resources.event");
    private static final int MAX_ALLOWABLE_PULL_MULTIPLIER = 20;
    private static final int MAX_ALLOWABLE_PULL_MULTIPLIER_ZOS = 5;
    private Alarm deadManSwitch;

    public Notification[] pullNotifications(int n) {
        this.resetAlarm();
        return this.getNotifications(n);
    }

    private synchronized void resetAlarm() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetAlarm");
        }
        if (this.deadManSwitch != null) {
            this.deadManSwitch.cancel();
        }
        this.deadManSwitch = AdminHelper.getPlatformHelper().isZOS() ? AlarmManager.createNonDeferrable(100000L, this) : AlarmManager.createNonDeferrable(this.getMaxAllowablePullTime(), this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetAlarm");
        }
    }

    private long getMaxAllowablePullTime() {
        if (AdminHelper.getPlatformHelper().isZOS()) {
            return 100000L;
        }
        return 400000L;
    }

    public void alarm(Object object) {
        if (this.isActive()) {
            FFDCFilter.processException((Throwable)new ReceiverPermanentlyUnavailableException("Notification not pulled within " + this.getMaxAllowablePullTime() / 1000L + " seconds from listener " + this.getIdentifier()), "com.ibm.ws.management.event.PullRemoteSender.alarm", "96", this);
            this.receiverPermanentlyUnavailable();
        }
    }
}

