/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.management.RoutingTable;
import com.ibm.ws.management.event.NotificationService;
import com.ibm.ws.management.event.PushNotificationListener;
import com.ibm.ws.management.util.SecurityHelper;
import java.io.Serializable;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class PushUpstreamServerSender
implements PushNotificationListener,
Serializable {
    private static final long serialVersionUID = 4175751728101288881L;
    private static TraceComponent tc = Tr.register(PushUpstreamServerSender.class, "Admin", "com.ibm.ws.management.resources.event");
    private static final String[] PROPAGATE_METHOD_PARAMS = new String[]{"[Ljavax.management.Notification;"};
    private transient boolean runLocally = false;
    private transient NotificationService notificationService = null;
    private transient AdminClient adminClient;
    private transient String serverName;
    private transient String nodeName;
    private transient ObjectName notifServiceMBean;
    private transient String pid;

    public void setRunLocally() {
        this.runLocally = true;
        this.notificationService = ((AdminServiceImpl)AdminServiceFactory.getAdminService()).getNotificationService();
    }

    public void handleNotifications(Notification[] notificationArray) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleNotifications", NotificationService.getInfo(notificationArray));
        }
        if (this.runLocally) {
            if (notificationArray != null) {
                for (int i = 0; i < notificationArray.length; ++i) {
                    if (!this.notificationService.isNotificationEnabled(notificationArray[i])) continue;
                    this.notificationService.handleNotification(notificationArray[i]);
                }
            }
        } else {
            SecurityHelper securityHelper = SecurityHelper.getHelper();
            if (securityHelper.isSecurityServiceStarted() && securityHelper.isSecurityServiceStopped()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "handleNotifications", "Security Server was running but has been stopped.  Notifications NOT propagated.");
                }
                return;
            }
            if (this.notifServiceMBean == null) {
                this.initialize();
                if (this.notifServiceMBean == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "handleNotifications: Null Notif Service MBean reference.");
                    }
                    return;
                }
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Propagating notifs to " + this.serverName + " on node " + this.nodeName);
                }
                this.adminClient.invoke(this.notifServiceMBean, "propagateNotifications", new Object[]{notificationArray}, PROPAGATE_METHOD_PARAMS);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "handleNotifications:  Exception received:", instanceNotFoundException);
                }
                FFDCFilter.processException((Throwable)instanceNotFoundException, "com.ibm.ws.management.event.PushUpstreamServerSender.handleNotifications", "107", this);
            }
            catch (MBeanException mBeanException) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "handleNotifications:  Exception received:", mBeanException);
                }
                FFDCFilter.processException((Throwable)mBeanException, "com.ibm.ws.management.event.PushUpstreamServerSender.handleNotifications", "109", this);
            }
            catch (ReflectionException reflectionException) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "handleNotifications:  Exception received:", reflectionException);
                }
                FFDCFilter.processException((Throwable)reflectionException, "com.ibm.ws.management.event.PushUpstreamServerSender.handleNotifications", "111", this);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotifications");
        }
    }

    private void initialize() throws ConnectorException {
        block5: {
            this.adminClient = RoutingTable.getInstance().getParent();
            this.serverName = this.adminClient.getServerMBean().getKeyProperty("process");
            this.nodeName = this.adminClient.getServerMBean().getKeyProperty("node");
            this.pid = RoutingTable.getInstance().getPid(this.serverName);
            try {
                this.notifServiceMBean = (ObjectName)this.adminClient.queryNames(new ObjectName("WebSphere:*,type=NotificationService,process=" + this.serverName + ",node=" + this.nodeName), null).iterator().next();
            }
            catch (ConnectorException connectorException) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "initialize:  Exception received:", connectorException);
                }
                FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws.management.event.PushUpstreamServerSender.initialize", "65", this);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "initialize:  Exception received:", malformedObjectNameException);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "sending notifications to node=" + this.nodeName + ",server=" + this.serverName + ",pid=" + this.pid);
        }
    }
}

